--[[---------------------------------------------------------------------------
	Chocolatier Development: Quest
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local content = {x=14,y=14}
local function CloseFunction()
	UpdateStandardUI()
	CloseWindow()
end

local function QuestSorter(q1,q2) return q1.name < q2.name end

local function QuestActivate(q)
	if q then
		q.starter:OfferQuest(q)
		CloseFunction()
	end
end

local checkButtonGraphics = { "control/std_checked", "control/std_checkbox_over", "control/std_checked_over", }


local q = gSim.quest
if q and q.complete then q=nil end

local y = 0

if gSim.mode == "empire" and q then
	local done = q:EvaluateGoals()

	table.insert(content, Text { x=0,y=0,w=300,h=14, label="#"..q.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	y=14

	local s = "#Force Encounter"
	if done then s = s .. " (Goals Complete)" end
	table.insert(content, Button { x=0,y=y, type=kPush, graphics=nextButtonGraphics, scale=14/64,
		command = function()
				q.ender:UIHandleQuest(q)
				CloseFunction()
			end })
	table.insert(content, Text { x=16,y=y,w=300,h=14, label=s, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	y=y+14

	local s = "#Force Completion"
	table.insert(content, Button { x=0,y=y, type=kPush, graphics=nextButtonGraphics, scale=14/64,
		command = function()
				q.ender:CompleteQuest(q)
				CloseFunction()
			end })
	table.insert(content, Text { x=16,y=y,w=300,h=14, label=s, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	y=y+14
	
	s = "#Starter: " .. tostring(q.starter)
	table.insert(content, Text { x=0,y=y,w=300,h=14, label=s, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	y=y+14
	
	s = "#Ender: " .. tostring(q.ender)
	table.insert(content, Text { x=0,y=y,w=300,h=14, label=s, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	y=y+14

	if q.followup then
		s = "#Followup: " .. tostring(q.followup)
		table.insert(content, Text { x=0,y=y,w=300,h=14, label=s, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
		y=y+14
	end
	
	local r = q.requirements
	if r == nil or table.getn(r) == 0 then
		table.insert(content, Text { x=0,y=y,w=300,h=14, label="#No Requirements", font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	else
		table.insert(content, Text { x=0,y=y,w=300,h=14, label="#Requirements:", font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
		for k,v in pairs(q.requirements) do
			if type(v) == "table" then
				y=y+14
				s = "#"..tostring(k)..":"
				table.insert(content, Text { x=10,y=y,w=290,h=14, label=s, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
				for k1,v1 in pairs(v) do
					y=y+14
					s = "#"..tostring(k1)..":"..tostring(v1)
					table.insert(content, Text { x=20,y=y,w=280,h=14, label=s, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
				end
			elseif type(k) ~= "number" then
				y=y+14
				s = "#"..tostring(k)..":"..tostring(v)
				table.insert(content, Text { x=10,y=y,w=290,h=14, label=s, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
			end
		end
		for _,v in ipairs(q.requirements) do
			y=y+14
			s = "#"..tostring(v)
			table.insert(content, Text { x=10,y=y,w=290,h=14, label=s, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
		end
	end
	y=y+14
elseif gSim.mode == "empire" then
	table.insert(content, Text { x=0,y=0,w=300,h=14, label="#No Quest Active (push to activate)", font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })

	local eligible = {}
	local completed = {}
	local others = {}
	for q in LQuest:AllQuests() do
		if q.complete then table.insert(completed, q)
		elseif q:EvaluateRequirements() then table.insert(eligible, q)
		else table.insert(others, q)
		end
	end
	table.sort(completed, QuestSorter)
	table.sort(eligible, QuestSorter)
	table.sort(others, QuestSorter)
	
	y=14
	local x=800
	table.insert(content, Text { x=0,y=y,w=400,h=14, label="#Eligible Quests:", font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	for i,q in ipairs(eligible) do
		local target = q
		x = x + 120
		if x > 600 then x = 0 y = y + 14 end
		table.insert(content, Button { x=x,y=y, type=kPush, graphics=nextButtonGraphics, scale=14/64,
			command = function() QuestActivate(target) end })
		table.insert(content, Text { x=x+14,y=y,w=110,h=14, label="#"..q.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	end
	
	y=y+14
	x=800	
	table.insert(content, Text { x=0,y=y,w=400,h=14, label="#Other Quests:", font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	for i,q in ipairs(others) do
		local target = q
		x = x + 120
		if x > 600 then x = 0 y = y + 14 end
		table.insert(content, Button { x=x,y=y, type=kPush, graphics=nextButtonGraphics, scale=14/64,
			command = function() QuestActivate(target) end })
		table.insert(content, Text { x=x+14,y=y,w=110,h=14, label="#"..q.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	end
	
	y=y+14
	x=800	
	table.insert(content, Text { x=0,y=y,w=400,h=14, label="#Completed Quests:", font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	for i,q in ipairs(completed) do
		local target = q
		x = x + 120
		if x > 600 then x = 0 y = y + 14 end
		table.insert(content, Button { x=x,y=y, type=kPush, graphics=checkButtonGraphics, scale=14/32,
			command = function() QuestActivate(target) end })
		table.insert(content, Text { x=x+14,y=y,w=110,h=14, label="#"..q.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	end
	
	y = y + 14
	x = 0
else
	table.insert(content, Text { x=0,y=0,w=200,h=14, label="#No Quests in Free Play Mode", font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
end

local c = table.getn(content)
if c > 40 then c = 40 end

MakeDialog
{
	Frame
	{
		x=74,y=14,h=28+y,color=CheatBackgroundColor,
		AppendStyle { font=CheatDialogFont },
		Window(content),
		Button { x=0,y=0, scale=14/64, graphics=genericButtonGraphics, command=CloseFunction },
	}
}
