--[[---------------------------------------------------------------------------
	Chocolatier Development: Products
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local products = {x=14,y=14}
local y = 0
local x = 0
local count = 0
for p in LItem:AllProducts() do
	local n = gSim:GetInventory(p.name) or 0
	table.insert(products,
		Rectangle { x=x,y=y,w=50,h=14, color=Color(64,64,64,255),
			TextEdit { x=0,y=0,w=kMax,h=kMax, label=tostring(n), name=p.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignRight } })
	table.insert(products,
		Text { x=x+54,y=y,w=300,h=14, label=p.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	count = count + 1
	if count == 32 then x = x + 300 y=0
	else y=y+14
	end
end

MakeDialog
{
	Frame
	{
		x=100,y=14,h=14*32+28,color=CheatBackgroundColor,
		AppendStyle { font=CheatDialogFont },
		Window(products),
		Button { x=0,y=0, scale=14/64, graphics=genericButtonGraphics, command=function()
				for p in LItem:AllProducts() do
					local n = tonumber(GetLabel(p.name))
					gSim.inventory[p.name] = n
				end
				UpdateStandardUI()
				CloseWindow()
			end },
	}
}
