--[[---------------------------------------------------------------------------
	Chocolatier Development: Ports
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local content = {x=14,y=14}
local y = 0
local x = 0
local count = 0
for p in LPort:AllPorts() do
	local port = p
	table.insert(content,
		Button { x=x,y=y, type=kToggle, graphics=genCheckBoxGraphics, scale=14/32, name=port.name,
			command = function()
				if port.available then port.available= false
				else port.available = true
				end
			end })
	table.insert(content,
		Text { x=x+18,y=y,w=100,h=14, label=port.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	count = count + 1
	if count == 8 then x = 100 y=0
	else y=y+14
	end
end

MakeDialog
{
	Frame
	{
		x=325,y=14,h=14*8+28,color=CheatBackgroundColor,
		AppendStyle { font=CheatDialogFont },
		Window(content),
		Button { x=0,y=0, scale=14/64, graphics=genericButtonGraphics, command=function()
				UpdateStandardUI()
				CloseWindow()
			end },
	}
}

for p in LPort:AllPorts() do
	if p.available then UtilSetButtonOn(p.name) end
end
