--[[---------------------------------------------------------------------------
	Chocolatier Development: Ingredients
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local ingredients = {x=14,y=14}
local y = 0
local x = 0
local count = 0
for ing in LItem:AllIngredients() do
	local n = gSim:GetInventory(ing.name) or 0
	table.insert(ingredients,
		Rectangle { x=x,y=y,w=50,h=14, color=Color(64,64,64,255),
			TextEdit { x=0,y=0,w=kMax,h=kMax, label=tostring(n), name=ing.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignRight } })
	table.insert(ingredients,
		Text { x=x+54,y=y,w=150,h=14, label=ing.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	count = count + 1
	if count == 11 then x = 150 y=0
	else y=y+14
	end
end

MakeDialog
{
	Frame
	{
		x=400,y=14,h=14*11+28,color=CheatBackgroundColor,
		AppendStyle { font=CheatDialogFont },
		Window(ingredients),
		Button { x=0,y=0, scale=14/64, graphics=genericButtonGraphics, command=function()
				for ing in LItem:AllIngredients() do
					local n = tonumber(GetLabel(ing.name))
					gSim.inventory[ing.name] = n
				end
				gSim:ProjectProduction()
				UpdateStandardUI()
				CloseWindow()
			end },
	}
}
