--[[---------------------------------------------------------------------------
	Chocolatier Development: Load/Save Game States
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local function SaveGame()
	local file = GetLabel("filename")
	if not file or file == "" then file = UtilTimeStamp() end
	file = file .. ".csg"
	
	local t = gSim:SaveGameTable()
	local out =
	{
		"-- Chocolatier Debug Game State saved " .. UtilTimeStamp(),
		"return { ",
	}
	ConvertToString(t, out)
	table.insert(out, "}")
--	local s = table.concat(out)
	local s = table.concat(out, "\n")
	UtilStringToFile(file, s)
end

local function LoadGame(file)
	local s = UtilStringFromFile(file)
	local f = loadstring(s)
	if type(f) == "function" then
		local t = f()
		assert(t and t.mode)
		Simulator:Reset()
		if (t.mode =="empire") then gSim:ResetEmpireMode()
		else gSim:ResetFreePlayMode()
		end
		
		gSim:LoadGameTable(t)
		gSim:AdjustRank(gSim.rank)
		gSim:ProjectProduction()
		SetMoneyDisplay(gSim.money)

		SwapToModal("ui/map.lua")
--		table.insert(gCommandQueue,function() SwapToModal("ui/map.lua") end)
	end
end

local content =
{
	x=14,y=14,
	Button { x=0,y=0, scale=14/64, graphics=genericButtonGraphics, command=function()
			SaveGame()
			CloseWindow()
		end },
	Text { x=16,y=0,w=200,h=14, label="#Create A New Save Point:" },
	Rectangle { x=16,y=14,w=184,h=14, color=Color(64,64,64,255),
		TextEdit { x=1,y=0,w=182,h=14, length=30, name="filename", label=UtilTimeStamp() } },
	Text { x=0,y=28,w=200,h=14, label="#Load An Existing Save Point:" },
}

local y=42
local s = UtilNextSaveFile()
while s ~= "" do
	local g = s..".csg"
	table.insert(content,
		Button { x=0,y=y, scale=14/64, graphics=genericButtonGraphics, command=function() LoadGame(g) end })
	table.insert(content, Text { x=14,y=y,w=200,h=14, label="#"..s })
	y = y + 14
	s = UtilNextSaveFile()
end

MakeDialog
{
	Frame
	{
		x=275,y=14,h=y+28,color=CheatBackgroundColor,
		AppendStyle { font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft },
		Window(content),
		Button { x=0,y=0, scale=14/64, graphics=genericButtonGraphics, command=function()
				CloseWindow()
			end },
	}
}
