--[[---------------------------------------------------------------------------
	Chocolatier Development: Factories and Shops
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local targets = {
	"sffactory", "nyfactory", "riofactory", "ukfactory", "mahafactory", "hkfactory",
}

local function SelectFactory(f)
	gCheatFactorySelection = LBuilding:ByName(f)
	assert(gCheatFactorySelection)
	SetLabel("selection","Selected: "..GetString(gCheatFactorySelection.port.name))
	SetLabel("rate",tostring(gCheatFactorySelection.rate or 0))
	if gCheatFactorySelection.product then
		UtilSetButtonOn(gCheatFactorySelection.product.name)
	else
		UtilSetButtonOn("basebars")
	end
end

-- List factories
local content = {x=14,y=14}
local y = 0
local x = 0
local count = 0
for _,n in ipairs(targets) do
	local b = LBuilding:ByName(n)
	table.insert(content,
		Button { x=x,y=y, type=kPush, graphics=genericButtonGraphics, scale=14/64,
			command = function() SelectFactory(b.name) end })
	table.insert(content,
		Button { x=x+14,y=y, type=kToggle, graphics=genCheckBoxGraphics, scale=14/32, name=b.name,
			command = function()
				if b.owned then b.owned = false
				else b:Purchase()
				end
			end })
	table.insert(content,
		Text { x=x+30,y=y,w=100,h=14, label=b.port.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	count = count + 1
	if count == 3 then x = 140 y=0
	else y=y+14
	end
end

y=42
table.insert(content, Text { x=0,y=y,w=300,h=14, name="selection", font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
y=y+14
table.insert(content,
	Rectangle { x=0,y=y,w=28,h=14, color=Color(64,64,64,255),
		TextEdit { x=0,y=0,w=kMax,h=kMax, length=2, name="rate", font=CheatDialogFont, flags=kVAlignCenter+kHAlignRight } })
table.insert(content, Text { x=30,y=y,w=110,h=14, label="#Production Rate", font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })

table.insert(content,
	Button { x=120,y=y, type=kPush, default=true, graphics=genericButtonGraphics, scale=14/64,
		command = function()
				if gCheatFactorySelection then
					local v = tonumber(GetLabel("rate")) or 0
					gCheatFactorySelection:SetConfiguration(nil, v)
					gSim:ProjectProduction()
					UpdateStandardUI()
				end
			end
		})
table.insert(content,
	Text { x=136,y=y,w=150,h=14, label="#Apply Changes (enter)", font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })

y=y+14
table.insert(content,
	Text { x=0,y=y,w=150,h=14, label="#Now Producing:", font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
y = y+14

local products = {x=14,y=14+y, BeginGroup()}
local y = 0
local x = 0
local count = 0
for prod in LItem:AllProducts() do
	local p = prod
	table.insert(products,
		Button { x=x,y=y, type=kRadio, graphics=genCheckBoxGraphics, scale=14/32, name=p.name,
			command = function()
				if gCheatFactorySelection then
					gCheatFactorySelection.product = p
					gSim:ProjectProduction()
					UpdateStandardUI()
				end
			end })
	table.insert(products,
		Text { x=x+16,y=y,w=300,h=14, label=p.name, font=CheatDialogFont, flags=kVAlignCenter+kHAlignLeft })
	count = count + 1
	if count == 32 then x = x + 300 y=0
	else y=y+14
	end
end

MakeDialog
{
	Frame
	{
		x=100,y=14,h=14*32+14*6+28,color=CheatBackgroundColor,
		AppendStyle { font=CheatDialogFont },
		Window(content),
		Window(products),
		Button { x=0,y=0, scale=14/64, graphics=genericButtonGraphics, command=function()
				gCheatFactorySelection = nil
				UpdateStandardUI()
				CloseWindow()
			end },
	}
}

for _,n in ipairs(targets) do
	local b = LBuilding:ByName(n)
	if b.owned then UtilSetButtonOn(b.name) end
end

SelectFactory("sffactory")
