--[[---------------------------------------------------------------------------
	Chocolatier Port Data: Trinidad
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "trinshopkeep", appearance="trinshopkeep" }

DefineCharacter { name = "trinmarketkeep", appearance="trinmarketkeep", haggleFactor=.85 }

DefineCharacter { name = "trinparkkeep", appearance="trinparkkeep", action = Speak { "trinparkkeep01"} }
	
DefineCharacter { name = "trinfarmer", appearance="trinfarmer", action = SellItem("farm_sale", "trinidad_cacao") }

DefineCharacter { name = "trinsaloonkeep", appearance="trinsaloonkeep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "trinidad",
	available = false,
	mapx = 224, mapy = 204,  labelpos = kHAlignRight,

	availability =
	{
		sugar = true,
		milk = true,
		cacao = true,
--		trinidad_cacao = true,  removing - should be only at farm>
-- 		truffle_powder should be added later (close to when truffles recipes are learned?) if possible
--		truffle_powder = true,
		lemon = true,
		cashews = true,
	},
	
	-- NOTES: OPTIMIZED
	layout =
	{
		Building {name = "trinpark",character = "trinparkkeep", x=338,y=45,image="tr_park" },
		BitmapLayer { image="ports/tr_hillcover",x=336,y=102  },
		Building { name="trinfarm", character="trinfarmer", ambient=kFarmAmbient, x=524,y=182,image="tr_farm" },
		BitmapLayer { image="ports/tr_farmover",x=524,y=182+25},
		Shop { name="trinshop", character = "trinshopkeep",x=642,y=235,image="tr_shop", },
		BitmapLayer { image="ports/tr_shoptree",x=642,y=235},
		Building { name = "trinsaloon",character = "trinsaloonkeep", ambient=kSaloonAmbient, x=500,y=254,image="tr_saloon" },
		Market { name = "trinmarket",character = "trinmarketkeep",x=381,y=267,image="tr_market", },

		Animation { random=true,  anim="ports/wave.xml", scale= 0.6, fps = 7, animx=392,animy=388 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.7, fps = 9, animx=452,animy=368 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.7, fps = 8, animx=382,animy=373 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.8, fps = 7, animx=190,animy=410 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.5, fps = 9, animx=0,animy=338 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.6, fps = 8, animx=20,animy=388 },
	},
}
