--[[---------------------------------------------------------------------------
	Chocolatier Port Data: Sydney
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "sydshopkeep", appearance="sydshopkeep" }
	
DefineCharacter { name = "sydmarketkeep", appearance="sydmarketkeep", haggleFactor=1.18 }

DefineCharacter { name = "sydquaykeep", appearance="sydquaykeep" }

DefineCharacter { name = "sydmintkeep", appearance="sydmintkeep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "sydney",
	available = false,
	mapx = 740, mapy = 343, labelpos = kHAlignLeft,

	availability =
	{
		sugar = true,
		milk = true,
--		caramel = true,
--		raspberry = true,
		cherry = true,
		macadamias = true,
		hazelnuts = true,
		mint = true,
	},
	
	layout =
	{
		Animation { random=true,  anim="ports/wave.xml", scale= .2, fps = 8, animx=20,animy=129},
		Animation { random=true, anim="ports/airship_fly.xml", fps=24, animy=-62*.2,scale=0.2, path={time=90000,loop=true,{-300,50},{620,25},{800,18}} },
		
		Building { name = "sydmint", character = "sydmintkeep", x=153,y=89,image="syd_mint" },
		BitmapLayer { image="ports/syd_mintover",x=153+121,y=89+60},
		Market { name = "sydmarket",character = "sydmarketkeep", x=363,y=81,image="syd_market" },
		BitmapLayer { image="ports/syd_marketover",x=363+267,y=81+66 },
		Building { name = "sydquay", character = "sydquaykeep", x=629,y=168,image="syd_quay", },
		
		Animation { random=true,  anim="ports/wave.xml", scale= .7, fps = 10, animx=70,animy=186},
		Animation { random=true,  anim="ports/wave.xml", scale= .9, fps = 9, animx=230,animy=210},
		Animation { random=true,  anim="ports/wave.xml", scale= 1, fps = 8, animx=480,animy=260},
		Animation { random=true,  anim="ports/wave.xml", scale= .8, fps = 9, animx=140,animy=290},
		Animation { random=true,  anim="ports/wave.xml", scale= .8, fps = 9, animx=640,animy=230},
		
		Animation { random=true, anim="ports/boat_schooner.xml", fps=24, scale=.2, animy=-73*.15, path={time=100000,loop=true,{-100,159},{0,159},{325,190},{0,200},{-100,200}} },
		Animation { random=true, animy=-15 , anim="ports/steamship.xml", scale=.3, fps=24,path={time=75000,loop=true,{-100,226},{0,226},{545,251},{0,226},{-200,226}} },

		Animation { random=true, anim="ports/boat_schooner.xml", fps=24, scale=.2, animy=-73*.2, path={time=5000,loop=true,{575,200},{575.1,195},{575.2,200}} },
		Animation { random=true, anim="ports/boat_schooner.xml", fps=24, scale=.2, animy=-73*.2, path={time=5000,loop=true,{690,209},{690.1,205},{690.2,209}} },

		Shop { name = "sydshop",character = "sydshopkeep", x=709,y=223,image="syd_shop" },
	},
}
