--[[---------------------------------------------------------------------------
	Chocolatier Port Data: Sulawesi
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "sulashopkeep", appearance="sulashopkeep" }

DefineCharacter { name = "sulamarketkeep", appearance="sulamarketkeep", haggleFactor=1.12 }

DefineCharacter { name = "sulafarmkeep", appearance="sulafarmkeep" ,
	action = SellItem("farm_sale", "sulawesi_cacao"),
}

DefineCharacter { name = "sulalandskeep", appearance="sulalandskeep" }


-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "sulawesi",
	available = false,
	mapx = 670, mapy = 231, labelpos = kHAlignRight,

	availability =
	{
		sugar = true,
		milk = true,
		cacao = true,
		macadamias = true,
		cherry = true,
		almonds = true,
		coffee = true,
		truffle_powder = true,		
	},

	-- NOTES: OPTIMIZED
	layout =
	{
		Animation { random=true,  anim="ports/wave.xml", scale= .3, fps = 9, animx=70,animy=218},
		Animation { random=true,  anim="ports/wave.xml", scale= .3, fps = 9, animx=220,animy=218},
		Animation { random=true,  anim="ports/wave.xml", scale= .4, fps = 8, animx=150,animy=230},
		Animation { random=true,  anim="ports/wave.xml", scale= .5, fps = 8, animx=0,animy=280},

		Animation { random=true, anim="ports/boat_schooner.xml", fps=24, scale=.15, animy=-73*.15, path={time=170000,loop=true,{-100,220},{296,215},{380,220},{0,220},{-100,220}} },

		Animation { random=true, image="ports/sul_cloud1", xtile=600,flip=false, path={time=250000,loop=true,{-100,108},{900,108}} },
		BitmapLayer { image = "ports/sul_cloudmask",x=239,y=20 },
		Animation { random=true, image="ports/sul_cloud2", xtile=750,flip=false, path={time=200000,loop=true,{-100,44},{900,44}} },

		Animation { random=true, anim="ports/boat_schooner.xml", fps=24, scale=.3, path={time=5000,loop=true,{47,259},{47.1,255},{47.2,259}} },

		Market { name = "sulamarket",character = "sulamarketkeep",x=59,y=237,image = "sul_market" },
		BitmapLayer { image = "ports/sul_marketover",x=59+155,y=237,},
		Building { name = "sulalands", character = "sulalandskeep", x=351,y=73,image="sul_highlands" },
		BitmapLayer { image = "ports/sul_landover",x=351,y=73+112,},
		Building { name = "sulafarm",character = "sulafarmkeep", ambient=kFarmAmbient, x=593,y=253,image="sul_farm"},
		BitmapLayer { image = "ports/sul_farmover",x=593,y=253+42,},
		
		Animation { random=true,  anim="ports/waterfall.xml", scale= 1.18, fps = 13, animx=700-77,animy=140+27 },
		Animation { random=true,  anim="ports/waterfall.xml", scale= 1.1, fps = 12, animx=730-60,animy=140+27 },

		Animation { random=true,  anim="ports/wave.xml", scale= 1.3, fps = 8, animx=30,animy=415 },
		Animation { random=true,  anim="ports/wave.xml", scale= 1.3, fps = 8, animx=165,animy=415 },
		Animation { random=true,  anim="ports/wave.xml", scale= 1.3, fps = 8, animx=420,animy=410 },
		Animation { random=true,  anim="ports/wave.xml", scale= 1.3, fps = 7, animx=750,animy=410 },

		Shop { name = "sulashop",character = "sulashopkeep",x=295,y=283,image="sul_shop", },
	},
}
