--[[---------------------------------------------------------------------------
	Chocolatier Port Data: San Francisco
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "sfshopkeep", appearance = "sfshopkeep" }

DefineCharacter { name = "sffactorykeep", appearance = "sffactorykeep" }

DefineCharacter { name = "sfmarketkeep", appearance = "sfmarketkeep", haggleFactor=1.17 }

DefineCharacter { name = "sftutor", appearance = "sftutor", action = Speak { "tutorspeak1"}, }

DefineCharacter { name = "sfsalooner", appearance = "sfsalooner" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "sanfrancisco",
	mapx = 110, mapy = 115, labelpos = kVAlignBottom,

	availability =
	{
		sugar = true,
		milk = true,
		almonds = true,
	},
	
	editable = {"sffactory","sfshop","sftutorplace","sfsaloon","sfmarket","steamship_far","steamship_close","horsebuggy_close","horsebuggy_far", "flag","test_jitter","test_jitter_small","test_jitter_big","logo","piermask"},
	layout =
	{
		Animation { random=true, image="ports/clouds_far", xtile=800,flip=false, path={time=210000,loop=true,{-400,120},{400,120}} },
		Animation { random=true, name = "schooner_far", animy=3, anim="ports/boat_schooner.xml", fps=24, scale=0.15, path={time=40000,loop=true,{600,232},{1000,232}} },
		Animation { random=true, name = "airship_far", animy=3, anim="ports/airship_fly.xml", fps=24, scale=0.3, path={time=90000,loop=true,{200,75},{-100,75},{1200,75},{200,75}} },
		Animation { random=true, anim="ports/lighthouse_beam.xml", fps=8, animx=775,animy=200 },
  		--Animation { random=true, anim="ports/factorysmoke.xml", fps=12, animx=123,animy=53 },
 		--Animation { random=true, anim="ports/factorysmoke.xml", fps=13, animx=123+91,animy=53 },
		Factory {name = "sffactory",price=10000,character = "sffactorykeep", scale= 0.5, x=-3,y=53,image = "factory",},
		PlayerLogo { name="logo", building="sffactory", x=47,y=19,w=106 },
		Animation { random=true, name="horsebuggy_far", animy=-3, anim="ports/horsebuggywalk.xml", scale=0.3, animy=2, fps=24, path={time=60000,loop=true,{30,194},{120,194},{230,208},{120,194},{30,194},{-100,194},{30,194}} },
		Shop {name = "sfshop",character = "sfshopkeep",x=480,y=205,image = "sf_shop",},
		Building {name = "sftutorplace",character = {"sftutor",}, x=567,y=75,image = "sf_cliffhouse",},
		BitmapLayer { x=567,y=170, image="ports/sf_mask_cliff" },
		Animation { random=true, image="ports/sf_clouds", animy=64, xtile=800, path={time=75000,loop=true,{-400,0},{400,0}} },
		Building {name = "sfsaloon",character = "sfsalooner", x=359,y=150,image = "sf_saloon",},
		Animation { random=true, name="horsebuggy_close", anim="ports/horsebuggywalk.xml", scale=0.7, animy=-13, animx=-125, fps=30,path={time=50000,loop=true,{30,280},{600,286},{660,300},{600,286},{30,280}} },

		Animation { random=true, name = "schoonerboat1", anim="ports/boat_schooner.xml", fps=24, scale=1.0, path={time=5000,loop=true,{621,295},{620.9,291},{620.8,295}} },

		BitmapLayer { name = "piermask", x=514,y=354, image="ports/sf_pier_mask" },
		Market {name = "sfmarket",character = "sfmarketkeep",x=0,y=42,image = "sf_market", area={{206,0,260,256},{0,253,475,320}},},
		Animation { random=true, anim="ports/wave.xml", scale= 0.5, fps = 14, animx=43,animy=394 },
		Animation { random=true, anim="ports/wave.xml", scale= 0.7, fps = 12, animx=186,animy=396 },
		Animation { random=true, anim="ports/wave.xml", scale= 0.3, fps = 16, animx=255,animy=388 },
		Animation { random=true, anim="ports/wave.xml", scale= 0.5, fps = 12, animx=320,animy=394 },
		Animation { random=true, anim="ports/wave.xml", scale= 0.3, fps = 14, animx=390,animy=392 },
		Animation { random=true, anim="ports/wave.xml", scale= 0.7, fps = 10, animx=496,animy=397 },
		Animation { random=true, anim="ports/wave.xml", scale= 0.4, fps = 16, animx=670,animy=392 },
		Animation { random=true, anim="ports/wave.xml", scale= 0.3, fps = 18, animx=720,animy=347 },
		Animation { random=true, anim="ports/wave.xml", scale= 0.2, fps = 14, animx=747,animy=342 },

		-- Don't randomize these, they're synched
  		--Animation { anim="ports/shipsmoke.xml",scale=0.7, fps=22, animx=20, animy=-50, fps=12,path={time=25000,loop=true,{1200,305},{-400,305}} },
  		--Animation { anim="ports/shipsmoke.xml",scale=0.7, fps=24, animx=95, animy=-50, fps=12,path={time=25000,loop=true,{1200,305},{-400,305}} },
		Animation { name = "steamship_close", animy=20, anim="ports/steamship.xml", scale=1.3, fps=24,path={time=25000,loop=true,{1200,323},{-400,323}} },
 	},
}
