--[[---------------------------------------------------------------------------
	Chocolatier Travel Data
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
	
	NOTE: Creating one route automatically creates the reverse route, but
		you can over-ride the routing if desired.
--]]---------------------------------------------------------------------------

-- The Americas ---------------------------------------------------------------
-- West to East-ish: SF, Merida, Quito, New York, Trinidad, Rio de Janeiro

DefineRoute { "sanfrancisco", "merida", waypoints = { {120,139},{135,172},{146,188},{162,188} }, vehicle="train", price = 200 }
DefineRoute { "sanfrancisco", "quito",  time =2, waypoints = { {83,174},{129,217} }, price = 445 }
DefineRoute { "sanfrancisco", "newyork", waypoints = { {142,112},{187,122} }, vehicle="train" }
DefineRoute { "sanfrancisco", "trinidad", via="quito" }
DefineRoute { "sanfrancisco", "riodejaneiro", time = 3, waypoints = { {83,164},{116,279},{210,444},{278,362} }, price = 650 } -- around the horn
--DefineRoute { "sanfrancisco", "riodejaneiro", via="quito" }

DefineRoute { "merida", "quito", waypoints = { {160,192},{172,201},{178,217},{195,222} }, vehicle="train" }
DefineRoute { "merida", "newyork", waypoints = { {183,170},{210,166},{221,144} }, price = 210 }
DefineRoute { "merida", "trinidad", waypoints = { {173,174},{187,201} }, price = 183 }
DefineRoute { "merida", "riodejaneiro", via="trinidad" }

DefineRoute { "quito", "newyork", via="trinidad" }
DefineRoute { "quito", "trinidad", waypoints = { {195,221},{220,216} }, vehicle="train" }
--DefineRoute { "quito", "riodejaneiro", via = "trinidad" }
DefineRoute { "quito", "riodejaneiro", waypoints = { {160,275},{189,432},{210,444},{278,362} }, time=2 }

DefineRoute { "newyork", "trinidad", waypoints = { {231,150} }, price = 197 }
DefineRoute { "newyork", "riodejaneiro", via="trinidad" }

DefineRoute { "trinidad", "riodejaneiro", waypoints = { {260,204},{310,260},{304,299} }, price = 226 }

-- Americas to Africa/Europe --------------------------------------------------

DefineRoute { "sanfrancisco", "london", via = "newyork" }
DefineRoute { "sanfrancisco", "accra", via = "newyork" }
DefineRoute { "sanfrancisco", "istanbul", via = "newyork" }
DefineRoute { "sanfrancisco", "mahajanga", via = "riodejaneiro" }

DefineRoute { "merida", "london", via = "trinidad" }
DefineRoute { "merida", "accra", via = "trinidad" }
DefineRoute { "merida", "istanbul", via = "trinidad" }
DefineRoute { "merida", "mahajanga", via = "trinidad" }

DefineRoute { "quito", "london", via = "trinidad" }
DefineRoute { "quito", "accra", via = "trinidad" }
DefineRoute { "quito", "istanbul", via = "trinidad" }
DefineRoute { "quito", "mahajanga", via = "trinidad" }

DefineRoute { "newyork", "london", time = 2, waypoints = { {274,128},{349,111} }, price = 500 }
DefineRoute { "newyork", "accra", time = 2, waypoints = { {274,156},{344,244},{372,243} }, price = 520 }
DefineRoute { "newyork", "istanbul", via = "london" }
DefineRoute { "newyork", "mahajanga", via = "accra" }

DefineRoute { "trinidad", "london", time = 2, waypoints = { {296,185},{332,114} }, price = 517 }
DefineRoute { "trinidad", "accra", time = 2, waypoints = { {302,229},{344,244},{372,243} }, price = 494 }
DefineRoute { "trinidad", "istanbul", via = "london" }
DefineRoute { "trinidad", "mahajanga", via = "accra" }

DefineRoute { "riodejaneiro", "london", time = 3, waypoints = { {297,320},{331,242},{327,172},{348,116} }, price = 600 }
DefineRoute { "riodejaneiro", "accra", time = 2, waypoints = { {287,328},{346,258},{371,236} }, price = 550 }
DefineRoute { "riodejaneiro", "istanbul", via = "london" }
DefineRoute { "riodejaneiro", "mahajanga", time = 3, waypoints = { {406,331},{412,365},{459,354},{473,306} }, price = 583 }

-- Africa and Europe ----------------------------------------------------------
-- West to East-ish: London, Accra, Zurich, Istanbul, Mahajanga

DefineRoute { "london", "accra", time = 2, waypoints = { {338,120},{323,197},{352,243} }, price = 400 }
DefineRoute { "london", "istanbul", waypoints = { {345,134},{351,138},{386,126},{420,140},{428,127} }, price = 199 }
DefineRoute { "london", "mahajanga", via="accra" }
--waypoints = { {338,120},{323,197},{352,243},{382,243},{406,331},{412,365},{459,354},{473,306} } }

--DefineRoute { "accra", "zurich", waypoints = { {352,240},{323,197},{346,111} } }
DefineRoute { "accra", "istanbul", via="london" }
--waypoints = { {352,243},{323,197},{339,140},{386,126},{420,140},{428,127} } }
DefineRoute { "accra", "mahajanga", time=2, waypoints = { {406,331},{412,365},{459,354},{473,306} }, price = 425 }

DefineRoute { "istanbul", "mahajanga", via="london" }
--time=2, waypoints = { {429,126},{426,134},{447,152},{456,168},{478,204},{483,208},{504,200},{500,239} } }

-- Americas to Asia/Pacific ---------------------------------------------------

DefineRoute { "sanfrancisco", "colombo", via = "hongkong" }
--DefineRoute { "sanfrancisco", "ulaanbaatar", via = "hongkong" }
DefineRoute { "sanfrancisco", "hongkong", time=3, waypoints = { {73,187},{39,217},{0,248},{799,248},{704,216},{670,181} }, price = 750 }
DefineRoute { "sanfrancisco", "sulawesi", time=3, waypoints = { {73,187},{39,217},{0,248},{799,248},{704,216} }, price = 800 }
DefineRoute { "sanfrancisco", "sydney", time=3, waypoints = { {73,187},{39,217},{0,248},{799,248},{783,288},{761,314},{755,346} }, price = 778 }

DefineRoute { "merida", "colombo", via = "sanfrancisco" }
DefineRoute { "merida", "hongkong", via = "sanfrancisco" }
DefineRoute { "merida", "sulawesi", via = "sanfrancisco" }
DefineRoute { "merida", "sydney", via = "sanfrancisco" }

DefineRoute { "quito", "colombo", via = "hongkong" }
DefineRoute { "quito", "hongkong", time=3, waypoints = { {0,248},{799,248},{704,216},{670,181} }, price = 814 }
DefineRoute { "quito", "sulawesi", via = "hongkong" }
DefineRoute { "quito", "sydney", time=3, waypoints = { {0,248},{799,248},{783,288},{761,314},{755,346} }, price = 799 }

DefineRoute { "newyork", "colombo", via = "sanfrancisco" }
DefineRoute { "newyork", "hongkong", via = "sanfrancisco" }
DefineRoute { "newyork", "sulawesi", via = "sanfrancisco" }
DefineRoute { "newyork", "sydney", via = "sanfrancisco" }

DefineRoute { "trinidad", "colombo", via = "quito" }
DefineRoute { "trinidad", "hongkong", via = "quito" }
DefineRoute { "trinidad", "sulawesi", via = "quito" }
DefineRoute { "trinidad", "sydney", via = "quito" }

DefineRoute { "riodejaneiro", "colombo", via = "mahajanga" }
DefineRoute { "riodejaneiro", "hongkong", via = "mahajanga" }
DefineRoute { "riodejaneiro", "sulawesi", via = "mahajanga" }
DefineRoute { "riodejaneiro", "sydney", via = "mahajanga" }

-- Europe/Africa to Asia/Pacific ----------------------------------------------

DefineRoute { "london", "colombo", via="istanbul" }
--DefineRoute { "london", "ulaanbaatar", via="istanbul" }
DefineRoute { "london", "hongkong", via="istanbul"  }
DefineRoute { "london", "sulawesi", via="istanbul"  }
DefineRoute { "london", "sydney", via="istanbul" }

DefineRoute { "accra", "colombo", via="mahajanga" }
--DefineRoute { "accra", "ulaanbaatar", via="mahajanga" }
DefineRoute { "accra", "hongkong", via="mahajanga" }
DefineRoute { "accra", "sulawesi", via="mahajanga" }
DefineRoute { "accra", "sydney", via="mahajanga" }

--DefineRoute { "zurich", "colombo", via="istanbul" }
--DefineRoute { "zurich", "ulaanbaatar", via="istanbul" }
--DefineRoute { "zurich", "hongkong", via="istanbul" }
--DefineRoute { "zurich", "sulawesi", via="istanbul" }
--DefineRoute { "zurich", "sydney", via="istanbul" }

DefineRoute { "istanbul", "colombo", time=2, vehicle="train", waypoints = { {458,131},{486,149},{529,162},{550,183},{559,199} }, price = 476 }
--DefineRoute { "istanbul", "ulaanbaatar", time=2, vehicle="train", waypoints = { {458,131},{484,140},{525,123},{538,130},{551,137},{560,129}, {575,146},{599,161},{615,172} } }
--DefineRoute { "istanbul", "hongkong", via="ulaanbaatar" }
DefineRoute { "istanbul", "hongkong", time=3, vehicle="train", waypoints = { {458,131},{484,140},{525,123},{538,130},{551,137},{560,129} } }
DefineRoute { "istanbul", "sulawesi", via="colombo" }
DefineRoute { "istanbul", "sydney", via="colombo" }

DefineRoute { "mahajanga", "colombo", waypoints={ {485,270},{518,229} }, price = 299 }
--DefineRoute { "mahajanga", "ulaanbaatar", via="colombo" }
DefineRoute { "mahajanga", "hongkong", via="colombo" }
DefineRoute { "mahajanga", "sulawesi", time = 2, waypoints={ {486,275},{556,255},{616,266},{632,262},{652,256},{662,251} }, price = 506 }
DefineRoute { "mahajanga", "sydney", time=2, waypoints={ {472,312},{475,333},{552,338},{582,331},{646,360},{699,369},{728,371} }, price = 549 }

-- Asia/Pacific ---------------------------------------------------------------
-- West to East-ish: Colombo, Ulaanbaatar, Hong Kong, Sulawesi, Sydney

--DefineRoute { "colombo", "ulaanbaatar", vehicle="train", waypoints={ {559,187},{569,165},{578,158},{577,144} } }
DefineRoute { "colombo", "hongkong", waypoints={ {574,231},{601,220},{614,225},{630,241},{648,223},{648,187} }, price = 325 }
DefineRoute { "colombo", "sulawesi", waypoints={ {574,231},{601,220},{614,225},{630,241},{651,256},{662,251} }, price = 317 }
DefineRoute { "colombo", "sydney", via = "sulawesi" }

--DefineRoute { "ulaanbaatar", "hongkong", vehicle="train", waypoints={ {575,146},{599,161},{615,172} } }
--DefineRoute { "ulaanbaatar", "sulawesi", via="hongkong" }
--DefineRoute { "ulaanbaatar", "sydney", via="colombo" }

DefineRoute { "hongkong", "sulawesi", waypoints={ {644,183},{668,226} }, price = 204 }
DefineRoute { "hongkong", "sydney", via = "sulawesi" }

DefineRoute { "sulawesi", "sydney", waypoints={ {661,258},{694,263},{729,274},{747,298},{758,327},{749,349} }, price = 288 }

-- North Pole ---------------------------------------------------------------
--[[
DefineRoute { "sanfrancisco", "northpole", via = "newyork" }
DefineRoute { "merida", "northpole", via = "trinidad" }
DefineRoute { "quito", "northpole", via = "trinidad" }
DefineRoute { "newyork", "northpole", time=2, waypoints = { {278,119},{349,71} } }
DefineRoute { "trinidad", "northpole", time = 2, waypoints = { {346,72} } }
DefineRoute { "riodejaneiro", "northpole", time = 3, waypoints={ {304,323},{299,130},{359,62} } }

DefineRoute { "london", "northpole", waypoints = { {333,111},{329,83},{370,51} } }
DefineRoute { "accra", "northpole", via="london" }
DefineRoute { "zurich", "northpole", via="london" }
DefineRoute { "istanbul", "northpole", via="london" }
DefineRoute { "mahajanga", "northpole", via="accra" }

DefineRoute { "colombo", "northpole", via="hongkong" }
DefineRoute { "ulaanbaatar", "northpole", via="hongkong" }
DefineRoute { "hongkong", "northpole", via="sanfrancisco"}
DefineRoute { "sulawesi", "northpole", via="hongkong" }
DefineRoute { "sydney", "northpole", via="sanfrancisco" }
]]--