--[[---------------------------------------------------------------------------
	Chocolatier Port Data: Rio de Janeiro
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "rioshopkeep", appearance="rioshopkeep" }

DefineCharacter { name = "riomarketkeep", appearance="riomarketkeep" , haggleFactor=.96}

DefineCharacter { name = "riofactorykeep", appearance="riofactorykeep" }

DefineCharacter { name = "rioforester", appearance="rioforester", action = Speak { "rioforester01"}}

DefineCharacter { name = "riocopakeep", appearance="riocopakeep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "riodejaneiro",
	available = false,
	mapx = 263, mapy = 307, labelpos = kHAlignLeft,

	availability =
	{
		sugar = true,
		milk = true,
		coffee = true,
		almonds = true,
	},
	
	-- NOTES: OPTIMIZED
	layout =
	{
		Animation { random=true,  image="ports/rio_clouds", xtile=800,flip=false, path={time=175000,loop=true,{-400,52},{400,52}} },
		BitmapLayer { image = "ports/rio_cloudmask1",x=107,y=79},
		BitmapLayer { image = "ports/rio_cloudmask2",x=449,y=0},
	
		Building { name="rioforest", character="rioforester", x=188,y=97, image="rio_rainforest", },
		BitmapLayer { image = "ports/rio_forestover",x=98,y=94,},
		
		Animation { name = "trainpasscar1", image="ports/steamtrain_passengercar", scale=0.35, animx=-48, animy=-85,path={time=45000,loop=true,{130,268},{1100,268}} },
		Animation { name = "trainpasscar2", image="ports/steamtrain_passengercar", scale=0.35, animx=-90, animy=-85,path={time=45000,loop=true,{130,268},{1100,268}} },
		Animation { name = "train", animy=-88, anim="ports/steamtrain_engine_anim.xml", scale=0.35, fps=24,path={time=45000,loop=true,{130,268},{1100,268}} },

		Factory { name="riofactory", character="riofactorykeep", price=29750, scale=.42, x=25, y=90, image="factory", },
		PlayerLogo { name="logo", building="riofactory", x=40,y=18,w=85 },
		BitmapLayer { image = "ports/rio_factover",x=18,y=188},
		
		Animation { random=true,  anim="ports/wave.xml", scale= 0.8, fps = 8, animx=40,animy=240},
		Animation { random=true,  animx=-142*.2,animy=-60*.2, anim="ports/steamship.xml", scale=.35, fps=24, path={time=80000,loop=true,{-300,225},{0,225},{155,231},{0,245},{-300,245}} },

		Building { name="riocopa", character="riocopakeep", x=24,y=192,image="rio_beach", },

		Animation { random=true,  anim="ports/wave.xml", scale= 1.0, fps = 9, animx=50,animy=328 },
		Animation { random=true,  anim="ports/wave.xml", scale= 1.2, fps = 7, animx=180,animy=295 },
		Animation { random=true,  anim="ports/boat_schooner.xml", fps=24, scale=.4, animy=-73*.4, path={time=60000,loop=true,{-600,335},{275,270},{-100,275} } },

		BitmapLayer { image = "ports/rio_beachover",x=24+135,y=195,},
		Shop { name="rioshop", character="rioshopkeep", x=528,y=199, image="rio_shop", },
		BitmapLayer { image="ports/rio_shopover", x=527+59,y=199+91, },
		Market { name="riomarket", character="riomarketkeep", x=358,y=199, image="rio_market", },
		
		BitmapLayer { image = "ports/rio_treewallover",x=79,y=145,},

		Animation { random=true,  anim="ports/wave.xml", scale= 1.0, fps = 7, animx=195,animy=400 },
		Animation { random=true,  anim="ports/wave.xml", scale= 1.3, fps = 8, animx=350,animy=410 },
		Animation { random=true,  anim="ports/wave.xml", scale= 1.0, fps = 9, animx=450,animy=400 },
		Animation { random=true,  anim="ports/wave.xml", scale= 1.0, fps = 10, animx=755,animy=390},
		
		Animation { anim="ports/boat_schooner.xml", fps=24, scale=.9, animy=-73*.9, path={time=75000,loop=true,{-100,415},{676,394},{800,370},{1500,370} } },
	}	
}
