--[[---------------------------------------------------------------------------
	Chocolatier Port Data: Quito
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "qshopkeep", appearance="qshopkeep" }

DefineCharacter { name = "qmarketkeep", appearance="qmarketkeep" , haggleFactor=.92}

DefineCharacter { name = "qfarmer", appearance="qfarmer",
	action = SellItem("farm_sale", "quito_cacao"),
}

DefineCharacter { name = "qgalaguide", appearance="qgalaguide", action = Speak { "qgalaguide01"} }

DefineCharacter { name = "qsalooner", appearance="qsalooner" }



-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "quito",
	available = false,
	mapx = 183, mapy = 231, labelpos = kHAlignRight,

	availability =
	{
		sugar = true,
		milk = true,
		cacao = true,
		mint = true,
-- 		truffle_powder should be added later (close to when truffles recipes are learned?) if possible
--		truffle_powder = true,
-- ONLY IN FARM		quito_cacao = true,
	},
	
	layout =
	{
		Animation { random=true,  anim="ports/wave.xml", scale= 0.8, fps = 7, x=61,y=85 },
		Building { name = "galapagos",character = "qgalaguide", image="q_islands",x=67,y=56 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.8, fps = 8, x=183,y=98 },

		Building { name = "qfarm",character = "qfarmer", ambient=kFarmAmbient, image="q_farm",x=648,y=68 },
		Shop { name = "qshop",character = "qshopkeep",x=230,y=64,image="q_shop" },
		Building { name = "qsaloon", character = { "qsalooner", "talker", "quester"}, ambient=kSaloonAmbient, image="q_saloon",x=673,y=122 },

		Animation { random=true,  anim="ports/horsebuggywalk.xml", scale=1.0, animy=-20, loop=true,fps=32,path={time=50000,loop=true,{-50,318},{214,310},{528,320},{796,348},{1200,358}} },
		Animation { random=true,  anim="ports/horsebuggywalk.xml", scale=1.0, animy=-20, loop=true,fps=30,path={time=60000,loop=true,{1200,379},{407,335},{205,335},{-400,379}} },

		Market { name = "qmarket",character = "qmarketkeep",x=250,y=305,image="q_market" },
	}
}
