--[[---------------------------------------------------------------------------
	Chocolatier Quest Data
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.

	A Quest is a goal for the player to accomplish, with a set of rewards.
	
	See external documentation.
--]]---------------------------------------------------------------------------

DefineQuest
{
	name = "tutor00",
	silent = true,
	offeronce = true,
	starter = "sftutor",
	accept = "yesplease",
	reward = { IncrementQuestVar("tutorme"), SetQuestFlag("tutorprice")},
	denial = { OfferQuest("nototutor")},
	forceComplete = true,
	followup = "tutor01",
}

DefineQuest
{
	name = "tutor01",
	requirements = { QuestVarEqualTo("tutorme",1)},
	starter = "sftutor",
	ender = "sfshopkeep",
	gift = { item = {maha_cherry_infusion = 1}, IncrementQuestVar("tutorme")},
	goals = {item = {maha_cherry_infusion = 1}},
	forceAccept = true,
	followup = "tutor02",
}


DefineQuest
{
	name = "tutor02",
	requirements = {QuestVarEqualTo("tutorme",2) },
	starter = "sfshopkeep",
	goals = { money = 100 },
	gift = {IncrementQuestVar("tutorme")},
	forceAccept = true,
	followup = "tutor03",
}

DefineQuest
{
	name = "tutor03",
	requirements = { QuestVarEqualTo("tutorme",3) },
	starter = "sfshopkeep",
	ender = "sftutor",
	forceAccept = true,
	followup = "tutor05",
}

DefineQuest
{
	name = "tutor05",
	requirements = { QuestVarEqualTo("tutorme",3)  },
	starter = "sftutor",
	reward = { CharacterDialog("tutor_extra05")},
	forceAccept = true,
	followup = "tutor06",
}

DefineQuest
{
	name = "tutor06",
	requirements = { QuestVarEqualTo("tutorme",3) },
	starter = "sftutor",
	ender = "sfsalooner",
	forceAccept = true,
	followup = "tutor06a",
}

DefineQuest
{
	name = "tutor06a",
	requirements = { QuestVarEqualTo("tutorme",3)  },
	starter = "sfsalooner",
	gift = { recipe = "basebars", ShowRecipes() },
	ender = "sftutor",
	forceAccept = true,
	followup = "tutor07",
}

DefineQuest
{
	name = "tutor07",
	requirements = { QuestVarEqualTo("tutorme",3)  },
	starter = "sftutor",
	ender = "sfmarketkeep",
	forceAccept = true,
	followup = "tutor08",
}

DefineQuest
{
	name = "tutor08",
	requirements = { QuestVarEqualTo("tutorme",3)  },
	starter = "sfmarketkeep",
	goals = {item = {sugar = 50}},
	ender = "sfmarketkeep",
	forceAccept = true,
	gift = {IncrementQuestVar("tutorme")},
	followup = "tutor09",
}

DefineQuest
{
	name = "tutor09",
	requirements = { QuestVarEqualTo("tutorme",3), item = {sugar = 40}, },
	starter = "sfmarketkeep",
	ender = "sftutor",
	goals = {item = {sugar = 50}},
	reward = {SetLedger("inventory"), IncrementQuestVar("tutorme")},
	forceAccept = true,
	followup = "tutor09b",
}

DefineQuest
{
	name = "tutor09b",
	requirements = { QuestVarEqualTo("tutorme",3), item = {sugar = 40} },
	gift = {item = {cacao = 75}},
	starter = "sftutor",
	forceAccept = true,
	followup = "tutor10",
}

DefineQuest
{
	name = "tutor10",
	requirements = { QuestVarEqualTo("tutorme",5)},
	starter = "sftutor",
	ender = "sffactorykeep",
	gift = { IncrementQuestVar("tutorme"), SetLedger("messages")},
	forceAccept = true,
	followup = "tutor11",
}

DefineQuest
{
	name = "tutor11",
	requirements = { QuestVarEqualTo("tutorme",6)  },
	starter = "sffactorykeep",
	gift = {IncrementQuestVar("tutorme")},
	forceAccept = true,
	goals = { item={basebars = 6} },
	followup = "tutor12",
}

DefineQuest
{
	name = "tutor12",
	requirements = { QuestVarEqualTo("tutorme",6) },
	starter = "sffactorykeep",
	ender = "sftutor",
	reward = {SetLedger("inventory")},
	forceAccept = true,
	followup = "tutor14",
}


DefineQuest
{
	name = "tutor14",
	requirements = { QuestVarEqualTo("tutorme",7) },
	starter = "sftutor",
	ender = "mermarketkeep",
	forceAccept = true,
	gift = { SetLedger("messages"), money = 1500, port ={"merida",},IncrementQuestVar("tutorme"),CharacterDialog("qiextra_tutor14") },
	followup = "tutor15",
}

DefineQuest
{
	name = "tutor15",
	requirements = { QuestVarEqualTo("tutorme",8)  },
	starter = "mermarketkeep",
	forceAccept = true,
	goals = { item={cacao = 100}},
	reward = { IncrementQuestVar("tutorme"), ClearQuestFlag("tutorprice")},
	followup = "tutor16",
}

DefineQuest
{
	name = "tutor16",
	requirements = { QuestVarEqualTo("tutorme",9) },
	starter = "mermarketkeep",
	ender = "merplazakeep",
	forceAccept = true,
	followup = "tutor17",
	reward = {IncrementQuestVar("tutorme")},
}

DefineQuest
{
	name = "tutor17",
	requirements = { QuestVarEqualTo("tutorme",10) },
	starter = "merplazakeep",
	gift = {recipe = "darkbars", ShowRecipes()},
	ender = "sftutor",
	forceAccept = true,
	followup = "tutor18",
}

DefineQuest
{
	name = "tutor18",
	requirements = { QuestVarEqualTo("tutorme",10), recipe = "darkbars"},
	starter = "sftutor",
	ender = "sftutor",
	forceAccept = true,
	goals = { item ={darkbars=8} },
	reward = {IncrementQuestVar("tutorme")},
	followup = "tutor19",
}

DefineQuest
{
	name = "tutor19",
	init =  {SetLedger("factories")},
	requirements = { QuestVarEqualTo("tutorme",11)  },
	starter = "sftutor",
	forceAccept = true,
	followup = "tutor20",
}

DefineQuest
{
	name = "tutor20",
	requirements = { QuestVarEqualTo("tutorme",11)  },
	starter = "sftutor",
	ender = "nysalooner",
	forceAccept = true,
	gift = {SetLedger("messages"), money = 300, port = {"newyork",} },
	goals = { item = {darkbars = 8} },
	reward = { item = {darkbars = -8}, money = 2000 },
	followup = "tutor21",
}

DefineQuest
{
	name = "tutor21",
	requirements = { QuestVarEqualTo("tutorme",11)  },
	starter = "nysalooner",
	ender = "sftutor",
	forceAccept = true,
	followup = "tutorend",
}


DefineQuest
{
	name = "novicetutor",
	requirements = { maxrank = 3 },
	silent = true,
	starter = "sftutor",
	forceAccept = true,
	forceComplete = true,
	repeatable = true,

}

DefineQuest
{
	name = "tutorsfsalooner",
	silent = true,
	requirements = {maxrank=0 },
	starter = "sfsalooner",
	forceAccept = true,
	repeatable = true,
}

DefineQuest
{
	name = "tutorend",
	requirements = { QuestVarEqualTo("tutorme",11), money = 2000},
	silent = true,
	starter = "sftutor",
	ender = "sftutor",
	forceAccept = true,
	reward = {SetQuestVar("HaggleBonus", 3), CharacterDialog("tutor_extra_end"), port =  {"quito", "riodejaneiro", "trinidad",}, rank = 1, money = 1000, DesignCompanyLogo,},
}


DefineQuest
{
	name = "nototutor",
	silent = true,
	requirements = { QuestVarEqualTo("nototutor",1)  },
	starter = "sftutor",
	forceAccept = true,
	forceComplete = true,
	gift = {SetQuestVar("HaggleBonus", 2), port =  {"quito", "riodejaneiro", "trinidad", "merida", "newyork",}, recipe = {"basebars", "darkbars" }, rank = 1, money = 3500, TutorialTimeWarp, DesignCompanyLogo, ShowRecipes(), },
}

DefineQuest
{
	name = "changesign",
	requirements = { rank = 1, QuestFlagOn("changesignflag")},
	starter = "announcer",
	forceAccept = true,
   	reward = {ClearQuestFlag("changesignflag"), DelayQuest("changesign", 52)},
}

DefineQuest
{
	name = "nyfactoryowned",
	requirements = { rank = 1, IsOwned("nyfactory")},
	starter = "quester6",
	forceAccept = true,
	forceComplete = true,
   	reward = { SetQuestFlag("changesignflag")},
}

DefineQuest
{
	name = "freetrip",
	requirements = { rank = 1, maxrank = 2, time = 30, QuestVarLessThan("OwnAirship",1)},
	starter = "lender",
	accept = "takeit",
	repeatable = true,
   	reward = {DelayQuest("freetrip", 45), money = -200, SetQuestVar("FreeTrip", 1), LedgerMessage("onefreetrip")},
}

DefineQuest
{
	name = "nomoney",
	requirements = {LessMoneyThan(250), rank = 1 },
	starter = "lender",
	ender = "lender",
	forceOffer = true,
	gift = { money = 1000 },
	goals = { time = 4 , money = 1200},
	reward ={ money = -1200, IncrementQuestVar("nomoney"), },

}

DefineQuest
{
	name = "nomoney2",
	requirements = {LessMoneyThan(250), QuestVarEqualTo("nomoney",1) },
	starter = "lender",
	ender = "lender",
	gift = { money = 1000 },
	goals = { time = 4 , money = 1500},
	reward ={ money = -1500, IncrementQuestVar("nomoney"), },

}
DefineQuest
{
	name = "nomoney3",
	requirements = {LessMoneyThan(250), QuestVarEqualTo("nomoney",2) },
	starter = "lender",
	ender = "lender",
	gift = { money = 1000 },
	goals = { time = 4 , money = 1500},
	reward ={ money = -1500, IncrementQuestVar("nomoney"), },

}

DefineQuest
{
	name = "nomoney4",
	requirements = {LessMoneyThan(250), QuestVarMoreThan("nomoney",3) },
	repeatable = true,
	starter = "lender",
	ender = "lender",
	gift = { money = 1000 },
	goals = { time = 4 , money = 2000},
	reward ={ money = -2000, IncrementQuestVar("nomoney"), },

}

DefineQuest
{
	name = "evil01",
	requirements = { rank = 1 },
	starter = "villain",
	forceAccept = true,
	forceComplete = true,
	silent = true,
	reward = { IncrementQuestVar("evilencounter"), DelayQuest("evil02", 30) },

}

DefineQuest
{
	name = "evil02",
	requirements = { QuestVarEqualTo("evilencounter",1)  },
	starter = "villain",
	forceAccept = true,
	forceComplete = true,
	silent = true,
	reward = { IncrementQuestVar("evilencounter"),DelayQuest("evil03", 25) },

}


DefineQuest
{
	name = "evil03",
	requirements = { QuestVarEqualTo("evilencounter",2), rank = 2  },
	starter = "villain",
	forceAccept = true,
	forceComplete = true,
	silent = true,
	reward = { IncrementQuestVar("evilencounter") },

}

DefineQuest
{
	name = "novicenudge",
	requirements = { rank = 1, QuestVarLessThan("QuestCounter",1)},
	starter = "quester4",
	forceOffer=true,
	forceAccept = true,
	forceComplete = true,

}

DefineQuest
{
	name = "novice_first",
	requirements = {rank = 1},
	starter = "quester",
	accept = "iagree",
	ender = "quester",
	forceOffer=true,
	gift = { recipe = "cashewbars", ShowRecipes() },
	goals = { item= {cashewbars = 18}, time = 8 },
	reward ={ item= {cashewbars = -18}, money = 3000, IncrementQuestVar("QuestCounter")},

}

DefineQuest
{
	name = "novice01",
	requirements = { rank = 1, time = 28},
	starter = "hench2",
	accept = "sure",
	reject = "never",
	ender = "merplazakeep",
	offeronce = true,
	reward = { IncrementQuestVar("QuestCounter") },

}

DefineQuest
{
	name = "novice02",
	requirements = { rank = 1 },
	starter = "sftutor",
	ender = "trinparkkeep",
	forceOffer=true,
	reward = { IncrementQuestVar("QuestCounter") },
 	followup = "novice03",
}


DefineQuest
{
	name = "novice03",
	requirements = { quest = "novice02" },
	starter = "trinparkkeep",
	ender = "trinparkkeep",
	gift = { recipe = "lemonbars", ShowRecipes()},
	goals = { item={lemonbars = 12} },
	reward ={ item={lemonbars = -12}, money = 4500, IncrementQuestVar("QuestCounter")},
}

 
DefineQuest
{
	name = "novice04",
	requirements = { rank = 1, money = 1500 },
	starter = "sftutor",
	ender = "rioforester",
	reward = { IncrementQuestVar("QuestCounter"), },
	followup = "novice05",
}


DefineQuest
{
	name = "novice05",
	requirements = { quest = "novice04", money = 500 },
	starter = "rioforester",
	ender = "rioforester",
	accept = "yesplease",
	reward = { money = -1000, recipe = "coffeebars", IncrementQuestVar("QuestCounter"), ShowRecipes(), },
}


DefineQuest
{
	name = "novice06",
	requirements = { rank = 1 },
	starter = "qsalooner",
	ender = "merruinskeep",
	accept = "iwill",
	gift = { item={basebars = 50}, },
	goals = { item={basebars = 50}},
	reward = { item={basebars = -50}, money = 1500, IncrementQuestVar("QuestCounter")},
}


DefineQuest
{
	name = "novice07",
	requirements = { rank = 1 },
	starter = "trinsaloonkeep",
	ender = "quester3",
	goals = {time = 2},
	reward = { IncrementQuestVar("QuestCounter"), },
	followup = "novice08",
}

DefineQuest
{
	name = "novice08",
	requirements = { quest = "novice07" },
	starter = "quester3",
	ender = "trinsaloonkeep",
	reward = { IncrementQuestVar("nylibrary"), IncrementQuestVar("QuestCounter"), LedgerMessage("novice08_hint")},
}


DefineQuest
{
	name = "novice09",
	requirements = { rank = 1, recipe = "quitodarkbars"},
	accept = "absolutely",
	starter = "merruinskeep",
	offeronce = true,
	goals = { item={quitodarkbars = 24} },
	reward = { item={quitodarkbars = -24}, money = 10000, IncrementQuestVar("QuestCounter"), },
}


DefineQuest
{
	name = "novice10",
	requirements = { rank = 1 },
	accept = "iwill",
	starter = "mersalooner",
	goals = { item={darkbars = 35} },
	reward = { item={darkbars = -35}, money = 3000, recipe = "quitodarkbars", IncrementQuestVar("QuestCounter"), ShowRecipes(), },
}

DefineQuest
{
	name = "novice11",
	requirements = { rank = 1, money = 1600},
	starter = "merplazakeep",
	accept = "takeit",
	reward = { money = -1100, recipe = "milkbars", IncrementQuestVar("QuestCounter"), ShowRecipes(),  },
}

DefineQuest
{
	name = "novice12",
	requirements = { recipe = "coffeebars" },
	starter = "tipster",
	ender = "tipster",
	goals = { item= {coffeebars = 20}, time = 7 },
	reward ={ item={coffeebars = -20}, recipe = "mintbars",  IncrementQuestVar("QuestCounter"),ShowRecipes(),},
}


DefineQuest
{
	name = "novice13",
	requirements = { money = 10000 },
	starter = "trinfarmer",
	ender = "trinfarmer",
	reward ={ money = -1000, recipe = "trindarkbars",  IncrementQuestVar("QuestCounter"),ShowRecipes(),},
}

DefineQuest
{
	name = "novice14",
	requirements = { recipe = "lemonbars" },
	starter = "sftutor",
	goals = {item={lemonbars = 15}},
	ender = "qgalaguide",
	reward ={ item= {lemonbars = -15}, recipe = "almondbars", IncrementQuestVar("QuestCounter"),ShowRecipes(), },
}

DefineQuest
{
	name = "novice15",
	requirements = { rank = 1, recipe = "milkbars", quest = "n_story09"},
	starter = "nysalooner",
	accept = "certainly",
	goals = {item= {milkbars = 28}},
	reward = { item= {milkbars = -28}, money = 7500, IncrementQuestVar("QuestCounter"),},
}

DefineQuest
{
	name = "novice16",
	requirements = { rank = 1, recipe = "darkbars"},
	starter = "riocopakeep",
	ender = "qsalooner",
	accept = "absolutely",
	goals = {item= {darkbars = 25}},
	reward = { item= {darkbars = -25}, money = 5000, recipe = "whitebars",  IncrementQuestVar("QuestCounter"),ShowRecipes(),},
}

DefineQuest
{
	name = "novice17",
	requirements = { rank = 1, recipe = "cashewbars" },
	offeronce = true,
	accept = "iwill",
	starter = "qgalaguide",
	goals = { item= {cashewbars = 10} },
	reward = { item= {cashewbars = -10}, money = 5000, IncrementQuestVar("QuestCounter"), },
}

DefineQuest
{
	name = "novice18",
	requirements = { rank = 1, quest = "tutor20"},
	offeronce = true,
	accept = "youcan",
	starter = "nysalooner",
	goals = { item= {darkbars = 30} },
	reward = { item= {darkbars = -30}, money = 8500, IncrementQuestVar("QuestCounter")},
}


DefineQuest
{
	name = "novice20_hint",
	requirements = { rank = 1, time = 15, MoreMoneyThan(15000), HasProduct(), QuestVarLessThan("mershopbuy",4)},
	silent = true,
	starter = "quester2",
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	reward = {LedgerMessage("message_novice20_hint"), DelayQuest("novice20_hint", 29)},
}

DefineQuest
{
	name = "novice20",
	requirements = { rank = 1, time = 15, HasProduct()},
	silent = true,
	starter = "mershopkeep",
	forceAccept = true,
	forceComplete = true,
	reward = { DelayQuest("novice20b", 4), DelayQuest("novice20_hint", 24), IncrementQuestVar("mershopbuy"), IncrementQuestVar("QuestCounter"),},
}

DefineQuest
{
	name = "novice20b",
	requirements = {HasProduct(), quest = "novice20" },
	silent = true,
	starter = "mershopkeep",
	gift = {IncrementQuestVar("mershopbuy")},
	forceAccept = true,
	forceComplete = true,
	followup = "novice21",
}

DefineQuest
{
	name = "novice21",
	requirements = { QuestVarEqualTo("mershopbuy",2)},
	starter = "mershopkeep",
	ender = "nylibrarian",
	gift = { item={basebars = 25} },
	goals = { item={basebars = 25} },
	reward = { IncrementQuestVar("mershopbuy"), item = {basebars = -25}, IncrementQuestVar("QuestCounter")},
	followup = "novice21b",
}

DefineQuest
{
	name = "novice21b",
	requirements = { QuestVarEqualTo("mershopbuy",2)},
	starter = "nylibrarian",
	ender = "mershopkeep",
	reward = {OfferQuest("novice22")},
}

DefineQuest
{
	name = "novice22",
	requirements = {HasProduct(), QuestVarEqualTo("mershopbuy",3) },
	starter = "mershopkeep",
	silent = true,
	forceAccept = true,
	forceComplete = true,
	reward ={IncrementQuestVar("novice23hint"), IncrementQuestVar("mershopbuy"), recipe = "xdarkbars",  IncrementQuestVar("QuestCounter"), ShowRecipes(), LedgerMessage("message_novice22") },
}

DefineQuest
{
	name = "novice23_nudge",
	requirements = {QuestVarEqualTo("novice23hint",1), QuestVarEqualTo("mershopbuy",4)},
	starter = "tipster2",
	accept = "iwill",
	ender = "merruinskeep",
	repeatable = true,
	reward = {DelayQuest("novice23_nudge", 25)},
	goals =  { item={xdarkbars = 1}},
}

DefineQuest
{
	name = "novice23",
	requirements = { item = {xdarkbars = 1}, QuestVarEqualTo("mershopbuy",4)  },
	accept = "iwill",
	starter = "mershopkeep",
	ender = "riocopakeep",
	goals =  { item={xdarkbars = 40} },
	reward = {SetQuestVar("novice23hint", 0), IncrementQuestVar("mershopbuy"), IncrementQuestVar("QuestCounter"), CharacterDialog("quextra_novice23"), item = {xdarkbars = -40}, money =  5000,},
}

DefineQuest
{
	name = "novice24_nudge",
	requirements = { MoreMoneyThan(12000), QuestVarEqualTo("mershopbuy",5)  },
	starter = "tipster2",
	silent = true,
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	reward = {DelayQuest("novice24_nudge", 23)},
}

DefineQuest
{
	name = "novice24",
	requirements = { MoreMoneyThan(10000), QuestVarEqualTo("mershopbuy",5)  },
	starter = "mershopkeep",
	accept = "iwill",
	ender = "mershopkeep",
	reward = { money = -7500, LedgerMessage ("message_novice24"), IncrementQuestVar("mershopbuy"), OwnBuilding("mershop"), recipe = {"almond_darkbars"}, IncrementQuestVar("QuestCounter"), ShowRecipes(), },

}

DefineQuest
{
	name = "novice25",
	requirements = { IsOwned("mershop"), QuestVarLessThan("mershopmessage",3)},
	starter = "mershopkeep",
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	reward = {IncrementQuestVar("mershopmessage")},
}

DefineQuest
{
	name = "dicepowder",
	requirements = { MoreMoneyThan(10000), rank = 1, quest = "e_story02" },
	starter = "hench2",
	offeronce = true,
	reward = {money = -2000, IncrementQuestVar("QuestCounter"),},

}

DefineQuest
{
	name = "hagglecharm",
	requirements = { MoreMoneyThan(10000), rank = 1  },
	starter = "charmer",
	reward = {money = -500, SetQuestVar("HaggleBonus", 3), LedgerMessage("threehaggles") },
}

DefineQuest
{
	name = "n_story01",
	requirements = { rank = 1  },
	starter = "sfsalooner",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story01b",
	requirements = { rank = 1  },
	starter = "sfsalooner",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story02",
	requirements = { rank = 1  },
	starter = "mermarketkeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story03",
	requirements = { rank = 1, quest = "novice10"},
	starter = "mersalooner",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story04",
	requirements = { rank = 1, },
	starter = "qshopkeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story05",
	requirements = { rank = 1, },
	starter = "qmarketkeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story06",
	requirements = { rank = 1, },
	starter = "qfarmer",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story07",
	requirements = { rank = 1, quest = "novice14", },
	starter = "qgalaguide",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story08",
	requirements = { rank = 1,},
	starter = "qsalooner",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story09",
	requirements = { rank = 1,},
	starter = "nysalooner",
	reward = {DelayQuest("novice15", 3)},
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story10",
	requirements = { rank = 1,},
	starter = "quester",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story11",
	requirements = { rank = 1, time = 22},
	starter = "quester",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story12",
	requirements = { rank = 3,},
	starter = "quester",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story13",
	requirements = { rank = 2},
	starter = "quester6",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "n_story14",
	requirements = { rank = 1, quest = "novice10"},
	starter = "riocopakeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
	repeatable = true,
	reward = {DelayQuest("n_story14", 27)},
}

DefineQuest
{
	name = "port_hint01",
	requirements = {rank = 1, maxrank = 1 },
	silent = true,
	starter = "quester2",
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	reward = {DelayQuest("port_hint01", 20)},
}

DefineQuest
{
	name = "port_hint02",
	requirements = {rank = 2, maxrank = 2 },
	silent = true,
	starter = "quester3",
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	reward = {DelayQuest("port_hint02", 36)},
}

DefineQuest
{
	name = "noviceend",
	requirements = { money = 7000, time = 46, QuestVarMoreThan("QuestCounter",4), RecipesKnown("bar",5)},
	starter = "announcer",
	ender = "sftutor",
	forceOffer = true,
	forceAccept = true,
	reward = {IncrementQuestVar("QuestCounter"), QuestFlagOn("changesignflag"), CharacterDialog("qextra_noviceend"), port =  {"london", "accra", "mahajanga" }, recipe =  {"xdark_sq", "cashew_dark_sq", "hazelnut_squares"}, ShowRecipes(), rank = 2},
}

DefineQuest
{
	name = "noviceend_hint",
	requirements = {money = 8500, time = 81, rank = 1, maxrank = 1 },
	starter = "announcer",
	forceOffer = true,
	forceAccept = true,
	repeatable = true,
	forceComplete = true,
	reward = {DelayQuest("noviceend_hint", 24)},
}


DefineQuest
{
	name = "nylibrary01_hint",
	requirements = {quest = "novice08", QuestVarEqualTo("nomorenylibrary01",0), QuestVarEqualTo("nylibrary",1)},
	starter = "talker",
	forceOffer = true,
	forceAccept = true,
	repeatable = true,
	forceComplete = true,
	reward = {DelayQuest("nylibrary01_hint", 34)},
}


DefineQuest
{
	name = "nylibrary01",
	requirements = {QuestVarEqualTo("nylibrary",1), quest = "novice08" },
	starter = "nylibrarian",
	forceAccept = true,
	reward = {recipe = "coffee_darkbars",  IncrementQuestVar("nylibrary"), IncrementQuestVar("nomorenylibrary01"), IncrementQuestVar("QuestCounter"), ShowRecipes(), },
}

DefineQuest
{
	name = "istvisa_leadina",
	requirements = { money = 120000, rank = 2,  QuestVarLessThan("nomoreistvisa_leadin",1)},
	starter = "tipster",
	ender = "quester5",
	gift = {IncrementQuestVar("nomoreistvisa_leadin")},
	goals = {time = 2},
	forceAccept = true,
	repeatable = true,
	followup = "openistanbul",
}

DefineQuest
{
	name = "istvisa_leadinb",
	requirements = { money = 120000, rank = 2,  QuestVarLessThan("nomoreistvisa_leadin",1)},
	starter = "announcer",
	ender = "quester5",
	gift = {IncrementQuestVar("nomoreistvisa_leadin")},
	goals = {time = 2},
	forceAccept = true,
	repeatable = true,
	followup = "openistanbul",
}

DefineQuest
{
	name = "istvisa_leadinc",
	requirements = { money = 120000, rank = 2,  QuestVarLessThan("nomoreistvisa_leadin",1)},
	starter = "quester6",
	ender = "quester5",
	gift = {IncrementQuestVar("nomoreistvisa_leadin")},
	goals = {time = 2},
	forceAccept = true,
	repeatable = true,
	followup = "openistanbul",
}

DefineQuest
{
	name = "istvisa_leadind",
	requirements = { money = 120000, rank = 2,  QuestVarLessThan("nomoreistvisa_leadin",1)},
	starter = "talker2",
	ender = "quester5",
	gift = {IncrementQuestVar("nomoreistvisa_leadin")},
	goals = {time = 2},
	forceAccept = true,
	repeatable = true,
	followup = "openistanbul",
}

DefineQuest
{
	name = "istvisa_leadine",
	requirements = { money = 120000, rank = 2 , QuestVarLessThan("nomoreistvisa_leadin",1)},
	starter = "talker",
	ender = "quester5",
	gift = {IncrementQuestVar("nomoreistvisa_leadin")},
	goals = {time = 2},
	forceAccept = true,
	repeatable = true,
	followup = "openistanbul",
}

DefineQuest
{
	name = "istvisa_leadinf",
	requirements = { money = 120000, rank = 2,  QuestVarLessThan("nomoreistvisa_leadin",1)},
	starter = "tipster2",
	ender = "quester5",
	gift = {IncrementQuestVar("nomoreistvisa_leadin")},
	goals = {time = 2},
	forceAccept = true,
	repeatable = true,
	followup = "openistanbul",
}


DefineQuest
{
	name = "openistanbul",
	requirements = { money = 110000, rank = 2 },
	starter = "quester5",
	reward = {SetQuestVar("istopened", 1), money = -5000, port = "istanbul", IncrementQuestVar("QuestCounter"), IncrementQuestVar("nomoreistvisa_leadin"), IncrementQuestVar("IstTowerRef")},
	denial = {SetQuestVar("nomoreistvisa_leadin", 0)},
}


DefineQuest
{
	name = "isttower01",
	requirements = { QuestVarEqualTo("IstTowerRef",1), money = 25000},
	starter = "isttowerkeep",
	reward = {money = -9500, recipe = {"mahadarkbars", "hazelnut_van_squares", "cinnamon_van_squares"}, IncrementQuestVar("QuestCounter"), IncrementQuestVar("IstTowerRef"), ShowRecipes(), },
}

	
DefineQuest
{
	name = "entrep01",
	requirements = { rank = 2, money = 5000, },
	starter = "tipster",
	ender = "ukpubkeep",
	goals = {money = 1000},
	reward ={ money = -1000, recipe = "caramel_squares", IncrementQuestVar("QuestCounter"),ShowRecipes(),},
}

DefineQuest
{
	name = "entrep02",
	requirements = { rank = 2},
	starter = "quester6",
	accept = "yesplease",
	reward = { recipe = "hazelnut_milk_sq", IncrementQuestVar("QuestCounter"),ShowRecipes(),},
}

DefineQuest
{
	name = "entrep03",
	requirements = { rank = 2,},
	accept = "ofcourse",
	starter = "mahashopkeep",
	ender = "sftutor",
	gift = {recipe = {"cinnamon_squares", "milk_van_squares"}, ShowRecipes(),},
	goals = { item= {cinnamon_squares = 30, milk_van_squares= 30}},
	reward = {item = {cinnamon_squares = -30, milk_van_squares = -30}, money = 30000, IncrementQuestVar("mahatutor"), IncrementQuestVar("QuestCounter"),},
	followup = "entrep04",
}

DefineQuest
{
	name = "entrep04",
	requirements = { rank = 2, QuestVarEqualTo("mahatutor",1) },
	accept = "iwill",
	starter = "sftutor",
	ender = "trinparkkeep",
	goals =  {item = {cinnamon_squares = 1}},
	reward ={ item = {cinnamon_squares = -1}, recipe = {"coffee_squares", "mint_squares", "almond_squares"}, IncrementQuestVar("QuestCounter"),ShowRecipes(),},
}


DefineQuest
{
	name = "entrep05",
	requirements = { rank = 2, QuestVarMoreThan("QuestCounter",20), recipe = "coffee_squares", },
	starter = "quester2",
	ender = "riocopakeep",
	goals =  { item={coffee_squares = 40} },
	reward = {IncrementQuestVar("QuestCounter"), item= {coffee_squares = -40} , money = 10000, recipe = "almond_van_squares", ShowRecipes(), },
}

DefineQuest
{
	name = "entrep06_nudge",
	requirements = { rank = 2, quest ="e_story11", QuestVarLessThan("entrep06done",1)},
	starter = "quester4",
	forceAccept = true,
	repeatable = true,
	reward = {DelayQuest("entrep06_nudge",27),IncrementQuestVar("QuestCounter"), item = {cherry_van_squares = -85}, money = 100000},
}

DefineQuest
{
	name = "entrep06",
	requirements = { rank = 2, quest ="e_story11"},
	starter = "ukpalacekeep",
	ender = "ukpalacekeep",
	forceOffer= true,
	gift = {recipe = {"cherry_van_squares"}, ShowRecipes(),},
	goals =  { item = {cherry_van_squares = 85}},
	reward = {IncrementQuestVar("entrep06done"), IncrementQuestVar("QuestCounter"), item = {cherry_van_squares = -85}, money = 100000},
}

DefineQuest
{
	name = "entrep20_hint",
	requirements = { rank = 2, time = 35, money = 75000, QuestVarLessThan("qshopbuy",1)},
	silent = true,
	starter = "quester2",
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	reward = {LedgerMessage("message_entrep20_hint"), DelayQuest("entrep20_hint", 45)},
}
	
	
DefineQuest
{
	name = "entrep20",
	requirements = { rank = 2, time = 35 },
	starter = "accramarketkeep",
	goals = {item = {hazelnut_squares = 25}},
	ender = "trinsaloonkeep",
	reward = {item= {hazelnut_squares = -25} , money = 8500, IncrementQuestVar("qshopbuy"), IncrementQuestVar("QuestCounter"), },
	followup = "entrep21",
}



DefineQuest
{
	name = "entrep21",
	requirements = { QuestVarEqualTo("qshopbuy",1)  },
	starter = "trinsaloonkeep",
	ender = "nyfactorykeep",
	reward = { IncrementQuestVar("qshopbuy"), IncrementQuestVar("QuestCounter"),},
	forceAccept = true,
	followup = "entrep22",
}

DefineQuest
{
	name = "entrep22",
	requirements = { QuestVarEqualTo("qshopbuy",2) },
	starter = "nyfactorykeep",
	goals = {item = {cashew_dark_sq = 12}},
	ender = "qsalooner",
	reward ={ item = {cashew_dark_sq = -12}, IncrementQuestVar("qshopbuy"), LedgerMessage("message_entrep22"), recipe = "almond_dark_sq", IncrementQuestVar("QuestCounter"),ShowRecipes(), },
}


DefineQuest
{
	name = "entrep23",
	requirements = { money = 25000, QuestVarEqualTo("qshopbuy",3)  },
	accept = "iwill",
	starter = "qshopkeep",
	goals =  { money = 25000},
	reward = {money = -25000, IncrementQuestVar("qshopbuy"), recipe = {"colodarkbars"}, IncrementQuestVar("QuestCounter"), OwnBuilding("qshop"),CharacterDialog("qextra_entrep23"), ShowRecipes(),  },
}

DefineQuest
{
	name = "entrep24",
	requirements = { rank = 2 },
	accept = "youbet",
	starter = "talker",
	gift = { recipe = "cherry_squares", ShowRecipes()},
	goals = { item= {cherry_squares = 20}, time = 13 },
	reward ={ item= {cherry_squares = -20}, IncrementQuestVar("QuestCounter")},
}


DefineQuest
{
	name = "e_story01",
	requirements = { rank = 2  },
	starter = "ukshopkeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "e_story02",
	requirements = { rank = 2  },
	starter = "ukpubkeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "e_story03",
	requirements = { rank = 2, quest = "novice10",  },
	starter = "ukfactorykeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "e_story04",
	requirements = { rank = 2, },
	starter = "accralighthousekeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "e_story05",
	requirements = { rank = 2, },
	starter = "accracastlekeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "e_story06",
	requirements = { rank = 2, },
	starter = "accrashopkeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "e_story07",
	requirements = { rank = 2, quest = "novice14", },
	starter = "mahabwalkkeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "e_story08",
	requirements = { rank = 2,},
	starter = "mahamarketkeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "e_story09",
	requirements = { rank = 2, HasProduct()},
	starter = "istshopkeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "e_story10",
	requirements = { rank = 2,},
	starter = "istshopkeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "e_story11",
	requirements = { rank = 2},
	starter = "talker",
	forceComplete = true,
	forceAccept = true,
	silent=true,
	reward = {LedgerMessage("message_e_story11")},
}

DefineQuest
{
	name = "e_story12",
	requirements = { rank = 2},
	starter = "ukpubkeep",
	forceAccept = true,
	forecComplete = true,
	silent=true,
	repeatable = true,
	reward = {DelayQuest("e_story12", 21)},
}

DefineQuest
{
	name = "e_story13",
	requirements = {rank = 2},
	starter = "ukpalacekeep",
	forceAccept = true,
	forecComplete = true,
	silent=true,
	repeatable = true,
}

DefineQuest
{
	name = "entrep_rank_end",
	requirements = { money = 225000, rank = 2, QuestVarEqualTo("istopened",1), QuestVarMoreThan("QuestCounter",18), RecipesKnown("square",12) },
	starter = "announcer",
	ender = "sftutor",
	forceOffer=true,
	forceAccept = true,
	reward = {IncrementQuestVar("QuestCounter"), SetQuestFlag("changesignflag"), recipe = "milk_choc_infusion", port =  {"sulawesi", "hongkong", "colombo"}, rank = 3, DelayQuest("nylibrary02_nudge",15), LedgerMessage("unleash_hint"), ShowRecipes() },
}


DefineQuest
{
	name = "nylibrary02_nudge",
	requirements = { rank = 3, QuestVarLessThan("nylibrary02done",1)},
	starter = "quester6",
	ender = "nylibrarian",
	reward = {OfferQuest("nylibrary02")},
}

DefineQuest
{
	name = "nylibrary02",
	requirements = { rank = 3 },
	starter = "nylibrarian",
	forceAccept = true,
	reward = {recipe = {"lemon_infusion"}, IncrementQuestVar("nylibrary"), IncrementQuestVar("QuestCounter"), IncrementQuestVar("nylibrary02done"), ShowRecipes(), },	

}

DefineQuest
{
	name = "choco01",
	requirements = { rank = 3 },
	starter = "quester5",
	ender = "quester5",
	goals = {money = 2750, time = 4 },
	reward ={ money = -2750, recipe = "coffee_infusion", IncrementQuestVar("QuestCounter"),ShowRecipes(), },
}

DefineQuest
{
	name = "choco02",
	requirements = {rank = 3},
	starter = "colmosqueer",
	accept = "youbet",
	gift = {recipe = {"coconut_infusion", "cherry_infusion"}, ShowRecipes() },
	goals = { item = {coconut_infusion = 1, cherry_infusion = 1 }},
	reward = { item = {coconut_infusion = -1, cherry_infusion = -1 }, recipe = "maha_cherry_infusion", IncrementQuestVar("QuestCounter"), LedgerMessage("choco03_logmsg"), ShowRecipes(),},
	followup = "choco03",
}

DefineQuest
{
	name = "choco03",
	requirements = { rank = 3, quest = "choco02"},
	starter = "colmosqueer",
	ender = "colsalooner",
	goals = { item = {maha_cherry_infusion = 10}, },
	reward = { item = {maha_cherry_infusion = -10 }, recipe = {"cinnamon_infusion"}, IncrementQuestVar("QuestCounter"),ShowRecipes(), },
}

DefineQuest
{
	name = "choco04",
	requirements = { rank = 3, recipe = "colodarkbars"},
	starter = "hksaloonkeep",
	ender = "accralighthousekeep",
	accept = "ofcourse",
	goals = { item = {colodarkbars = 24}},
	reward = { item = {colodarkbars = -24 }, money = 5000, recipe = {"maha_mint_raspberry_infusion"}, IncrementQuestVar("QuestCounter"),ShowRecipes(),  },
}


DefineQuest
{
	name = "choco05",
	requirements = { rank = 3},
	starter = "isttowerkeep",
	ender = "merruinskeep",
	goals = { item = {milk_choc_infusion = 40}},
	reward = {item = {milk_choc_infusion = -40 }, recipe = {"sula_macadamia_infusion"}, LedgerMessage("message_qe_choco05"), DelayQuest("choco41", 1), IncrementQuestVar("QuestCounter"),ShowRecipes(),  },
}



DefineQuest
{
	name = "choco06",
	requirements = { rank = 3},
	starter = "sulalandskeep",
	goals = { item = {darkbars = 12}},
	reward = { item = {darkbars = -12 }, IncrementQuestVar("QuestCounter"), OfferQuest("choco06b")},
}

DefineQuest
{
	name = "choco06b",
	requirements = { rank = 3, quest = "choco06"},
	starter = "sulalandskeep",
	ender = "sulafarmkeep",
	forceAccept = true,
	followup = "choco07",
}

DefineQuest
{
	name = "choco07",
	requirements = { rank = 3,  quest = "choco06" },
	starter = "sulafarmkeep",
	ender = "sulalandskeep",
	gift = {recipe = "mint_infusion", ShowRecipes(), },
	goals = { item = {mint_infusion = 5}},
	reward = { item = {mint_infusion = -5}, IncrementQuestVar("QuestCounter"),},
}

DefineQuest
{
	name = "choco08",
	requirements = { rank = 3 },
	starter = "istshopkeep",
	ender = "nylibrarian",
	reward = { recipe = "colo_coffee_almond_infusion", IncrementQuestVar("QuestCounter"), IncrementQuestVar("nylibraryb"),ShowRecipes(),  },
}

DefineQuest
{
	name = "choco09_leadina",
	requirements = { rank = 3, money = 655000,  IsOwned("hkfactory"), QuestVarLessThan("nomore09leadin",1)},
	starter = "tipster",
	ender = "quester6",
	goals = {time = 2},
	gift = {IncrementQuestVar("nomore09leadin")},
	forceAccept = true,
	followup = "choco09",
}

DefineQuest
{
	name = "choco09_leadinb",
	requirements = { rank = 3, money = 655000,  IsOwned("hkfactory"), QuestVarLessThan("nomore09leadin",1)},
	starter = "talker",
	ender = "quester6",
	goals = {time = 2},
	gift = {IncrementQuestVar("nomore09leadin")},
	forceAccept = true,
	followup = "choco09",
}

DefineQuest
{
	name = "choco09_leadinc",
	requirements = { rank = 3, money = 655000,  IsOwned("hkfactory"), QuestVarLessThan("nomore09leadin",1)},
	starter = "talker2",
	ender = "quester6",
	goals = {time = 2},
	gift = {IncrementQuestVar("nomore09leadin")},
	forceAccept = true,
	followup = "choco09",
}

DefineQuest
{
	name = "choco09_leadind",
	requirements = { rank = 3, money = 655000,  IsOwned("hkfactory"), QuestVarLessThan("nomore09leadin",1)},
	starter = "quester2",
	ender = "quester6",
	goals = {time = 2},
	gift = {IncrementQuestVar("nomore09leadin")},
	forceAccept = true,
	followup = "choco09",
}

DefineQuest
{
	name = "choco09_leadinf",
	requirements = { rank = 3, money = 655000,  IsOwned("hkfactory"), QuestVarLessThan("nomore09leadin",1)},
	starter = "quester5",
	ender = "quester6",
	goals = {time = 2},
	gift = {IncrementQuestVar("nomore09leadin")},
	forceAccept = true,
	followup = "choco09",
}

DefineQuest
{
	name = "choco09",
	requirements = { rank = 3, money = 650000,  IsOwned("hkfactory")},
	starter = "quester6",
	ender = "istshopkeep",
	gift = {recipe = "dark_truffles", ShowRecipes(),},
	goals = { item = {dark_truffles = 5}},
	reward = { IncrementQuestVar("QuestCounter"), IncrementQuestVar("nomore09leadin")},
	denial = {SetQuestVar("nomore09leadin",0)},
	followup = "choco10",
}

DefineQuest
{
	name = "choco10",
	requirements = { rank = 3, quest = "choco09", },
	starter = "istshopkeep",
	ender = "quester",
	goals = { time = 7 },
	reward = { IncrementQuestVar("QuestCounter"), IncrementQuestVar("IstShopBuy")},
	followup = "choco11",
}

DefineQuest
{
	name = "choco11",
	requirements = { rank = 3, quest = "choco10", },
	starter = "quester",
	ender = "trinparkkeep",
	gift = {recipe = {"milk_truffles", "caramel_truffles", "mint_choco_truffles"}, ShowRecipes(), }, 
	goals = { item = {milk_truffles = 36, caramel_truffles = 36, mint_choco_truffles = 36 }},
	reward = { OwnBuilding("istshop"), item = {milk_truffles = -36, caramel_truffles = -36, mint_choco_truffles = -36 }, IncrementQuestVar("QuestCounter"), IncrementQuestVar("GrimOut")},
}

DefineQuest
{
	name = "choco12",
	requirements = { rank = 3, IsOwned("istshop")},
	starter = "quester2",
	ender = "quester2",
	accept = "iwill",
	gift = {recipe = "coconut_lemon_truffles", ShowRecipes(), }, 
	goals = {time = 16, item = {coconut_lemon_truffles = 50}},
	reward = {DelayQuest("choco13_nudge",15),  {item = {coconut_lemon_truffles = -50}}, money = 20000, IncrementQuestVar("QuestCounter"), IncrementQuestVar("GrimOut"), CharacterDialog("qextra_choco12"), LedgerMessage("message_choco13_hint"), },
}


DefineQuest
{
	name = "choco13_nudge",
	requirements = { rank = 3, quest = "choco12", QuestVarLessThan("choco13",1)},
	starter = "quester2",
	ender = "sfsalooner",
	accept = "iwill",
	goals = {item = {coconut_lemon_truffles = 1}},
	reward = { OfferQuest("choco13")},
}


DefineQuest
{
	name = "choco13",
	requirements = { rank = 3, IsOwned("istshop"), item = {coconut_lemon_truffles = 1},},
	starter = "sfsalooner",
	forceAccept = true, 
	reward = { item = {coconut_lemon_truffles = -1}, IncrementQuestVar("choco13"), IncrementQuestVar("QuestCounter"), IncrementQuestVar("GrimOut")},
}

DefineQuest
{
	name = "choco14",
	requirements = { rank = 3, IsOwned("istshop"), recipe = {"coconut_lemon_truffles"}},
	starter = "quester3",
	ender = "mahashopkeep", 
	reward = { recipe = {"almond_choco_truffles"}, IncrementQuestVar("QuestCounter"), IncrementQuestVar("GrimOut"), ShowRecipes(),  },
	followup = "choco15",
}

DefineQuest
{
	name = "choco15",
	requirements = {quest = "choco14"},
	starter = "mahashopkeep",
	ender = "trinparkkeep", 
	reward = { IncrementQuestVar("QuestCounter"), IncrementQuestVar("GrimOut")},
}


DefineQuest
{
	name = "choco16_nudge",
	requirements = {rank = 3, IsOwned("istshop"), QuestVarLessThan("nonudge_choco16",1)},
	starter = "quester",
	silent = true,
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	reward = {LedgerMessage("message_choco16_nudge"), DelayQuest("choco16_nudge", 38)},
}

DefineQuest
{
	name = "choco16",
	requirements = { rank = 3, IsOwned("istshop") },
	starter = "istshopkeep",
	reward = {IncrementQuestVar("nonudge_choco16")},
	followup = "choco17",
	forceAccept = true,
}

DefineQuest
{
	name = "choco17",
	requirements = {quest = "choco16"},
	starter = "istshopkeep",
	ender = "hkpeakkeep",
	gift = {recipe = "trin_almond_vanilla_truffles", ShowRecipes(), }, 
	goals = { item = {trin_almond_vanilla_truffles = 12}},
	reward = { {item = {trin_almond_vanilla_truffles = -12}},  IncrementQuestVar("QuestCounter"), IncrementQuestVar("JandE")},
}	


DefineQuest
{
	name = "choco18",
	requirements = {quest = "choco17"},
	starter = "quester5",
	ender = "quester5",
	goals = {time = 11, item = {trin_almond_vanilla_truffles = 48}},
	reward = {recipe = {"sula_lemon_macadamia_truffles" }, item = {trin_almond_vanilla_truffles = -48},  IncrementQuestVar("QuestCounter"), IncrementQuestVar("JandE"), ShowRecipes(),  },
}


DefineQuest
{
	name = "choco19_nudge",
	requirements = {quest = "choco18", QuestVarLessThan("nonudge_choco19",1)},
	starter = "quester2",
	silent = true,
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	reward = {LedgerMessage("message_choco19_nudge"), DelayQuest("choco19_nudge", 22)},
}

DefineQuest
{
	name = "choco19",
	requirements = {quest = "choco18"},
	starter = "hkpeakkeep",
	ender = "sftutor",
	gift = {recipe = "coffee_cinnamon_truffles", ShowRecipes(), }, 
	goals = { item = {coffee_cinnamon_truffles = 12}},
	reward = {IncrementQuestVar("nonudge_choco19"), item = {coffee_cinnamon_truffles = -12},  IncrementQuestVar("QuestCounter"), IncrementQuestVar("JandE")},
}

DefineQuest
{
	name = "eandj",
	requirements = {quest = "choco19"},
	starter = "hkpeakkeep",
	silent = true,
	repeatable = true,
	forceAccept = true,
	forceComplete = true,
}

DefineQuest
{
	name = "choco20_hint",
	requirements = { rank = 3, money = 780000, IsOwned("mershop"), QuestVarLessThan("colshopbuy",1) },
	starter = "quester2",
	silent = true,
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	reward = {DelayQuest("choco20_hint", 54), LedgerMessage("message_choco20_hint")},
}

DefineQuest
{
	name = "choco20",
	requirements = { rank = 3, money = 750000, IsOwned("mershop")},
	starter = "colshopkeep",
	reward = { IncrementQuestVar("colshopbuy")},
	followup = "choco21",
}

DefineQuest
{
	name = "choco21",
	requirements = {QuestVarEqualTo("colshopbuy",1)},
	starter = "colshopkeep",
	ender = "colshopkeep",
	gift = {recipe = "colo_raspberry_infusion", ShowRecipes(), },
	goals = { item = {colo_raspberry_infusion = 25}},
	reward = {DelayQuest("choco22", 3), IncrementQuestVar("QuestCounter"),  item = {colo_raspberry_infusion = -25, colombo_cacao = 500}, IncrementQuestVar("colshopbuy")},
}


DefineQuest
{
	name = "choco21story",
	requirements = {QuestVarEqualTo("colshopbuy",1), recipe = "colo_raspberry_infusion"},
	starter = "colfarmer",
}


DefineQuest
{
	name = "choco22_nudge",
	requirements = {QuestVarEqualTo("colshopbuy",2), QuestVarEqualTo("nochoco22nudge",0)},
	starter = "charmer",
	silent = true,
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	reward = {DelayQuest("choco22_nudge", 21)},
}

DefineQuest
{
	name = "choco22",
	requirements = {QuestVarEqualTo("colshopbuy",2)},
	starter = "colshopkeep",
	ender = "sftutor",
	goals = { item = {colo_raspberry_infusion = 25}},
	reward = {IncrementQuestVar("nochoco22nudge"), IncrementQuestVar("QuestCounter"), LedgerMessage("message_choco22"), item = {colo_raspberry_infusion = -25}, IncrementQuestVar("colshopbuy")},
}

DefineQuest
{
	name = "choco23_nudge",
	requirements = {QuestVarEqualTo("colshopbuy",3), QuestVarEqualTo("nochoco23nudge",0)},
	starter = "talker",
	silent = true,
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	reward = {DelayQuest("choco23_nudge", 21)},
}

DefineQuest
{
	name = "choco23",
	requirements = {QuestVarEqualTo("colshopbuy",3)},
	starter = "colshopkeep",
	ender = "quester6",
	goals = { time=6},
	reward = {IncrementQuestVar("nochoco23nudge"), IncrementQuestVar("QuestCounter"), IncrementQuestVar("colshopbuy")},
}

DefineQuest
{
	name = "choco24",
	requirements = {QuestVarEqualTo("colshopbuy",4)},
	starter = "colshopkeep",
	ender = "qgalaguide",
	reward = {IncrementQuestVar("QuestCounter"), IncrementQuestVar("colshopbuy")},
	followup = "choco25",
}

DefineQuest
{
	name = "choco25",
	requirements = {QuestVarEqualTo("colshopbuy",5) },
	starter = "qgalaguide",
	ender = "quester",
	gift = {recipe = "quito_coffee_infusion", ShowRecipes(), },
	goals = {time = 13, item = {quito_coffee_infusion = 100}},
	reward = {IncrementQuestVar("QuestCounter"), LedgerMessage("message_choco25"), item = {quito_coffee_infusion = -100}, recipe = {"cacao_blend_infusion"}, IncrementQuestVar("colshopbuy"), ShowRecipes(), },
}

DefineQuest
{
	name = "choco26_nudge",
	requirements = {QuestVarEqualTo("colshopbuy",6), QuestVarEqualTo("nochoco26nudge",0)},
	starter = "tipster2",
	silent = true,
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	reward = {DelayQuest("choco26_nudge", 30)},
}

DefineQuest
{
	name = "choco26",
	requirements = {QuestVarEqualTo("colshopbuy",6) },
	starter = "colshopkeep",
	reward = {IncrementQuestVar("nochoco26nudge"), IncrementQuestVar("QuestCounter"), IncrementQuestVar("colshopbuy"), OwnBuilding("colshop")},
	forceAccept = true,
}

DefineQuest
{
	name = "choco31",
	requirements = { rank = 3, quest = "choco04"},
	starter = "hksaloonkeep",
	ender = "hksaloonkeep",
	goals = {item = {maha_mint_raspberry_infusion = 28}},
	reward = { item = {maha_mint_raspberry_infusion = -28 }, recipe = "raspberry_infusion", IncrementQuestVar("QuestCounter"),ShowRecipes(),  },
}

DefineQuest
{
	name = "choco41",
	requirements = { rank = 3, quest = "choco05"},
	starter = "merruinskeep",
	ender = "merruinskeep",
	goals = {item = {sula_macadamia_infusion = 1}},
	reward = { item = {sula_macadamia_infusion = -1 }, recipe = "vanilla_almond_infusion", IncrementQuestVar("QuestCounter"),ShowRecipes(),  },
}

DefineQuest
{
	name = "choco42",
	requirements = { rank = 3, QuestVarEqualTo("nylibraryb",1)},
	starter = "nylibrarian",
	ender = "nylibrarian",
	goals = {item = {colo_coffee_almond_infusion = 45}},
	reward = { item = {colo_coffee_almond_infusion = -45 }, recipe = "maha_cinnamon_cherry_truffles", IncrementQuestVar("QuestCounter"),ShowRecipes(),  },
}

DefineQuest
{
	name = "choco50",
--	requirements = { rank = 3, IsOwned("mershop"), IsOwned("istshop"), IsOwned("colshop"), IsOwned("qshop"), QuestVarMoreThan("JandE",2), QuestVarMoreThan("GrimOut",4)},
	requirements = { rank = 3, AllMedalsForMCPath, QuestVarMoreThan("JandE",2), QuestVarMoreThan("GrimOut",4)},
	starter = "quester2",
	ender = "sftutor",
	followup = "choco51",
}

DefineQuest
{
	name = "choco51",
	requirements = { quest = "choco50"},
	starter = "sftutor",
	ender = "sydshopkeep",
	gift = {port =  {"sydney"}, recipe = {"hazelnut_milk_truffles"}, ShowRecipes(), },
	goals = {item = {hazelnut_milk_truffles = 1}},
	reward = {IncrementQuestVar("QuestCounter"), IncrementQuestVar("EndStory"), CharacterDialog("qextra_choco51"), item = {hazelnut_milk_truffles = -1 }, },
	followup = "choco52",
}


DefineQuest
{
	name = "choco52",
	requirements = { quest = "choco51"},
	starter = "sydshopkeep",
	ender = "sydmintkeep",
	gift = { recipe = {"colo_coffee_caramel_truffles"}, ShowRecipes(), },
	goals = {item = {colo_coffee_caramel_truffles = 12}},
	reward = {IncrementQuestVar("QuestCounter"), item = {colo_coffee_caramel_truffles = -12}, IncrementQuestVar("EndStory")},
	followup = "choco53",

}

DefineQuest
{
	name = "choco53",
	requirements = { quest = "choco52"},
	starter = "sydmintkeep",
	ender = "istshopkeep",
	gift = {recipe = {"milk_blend_truffles"}, ShowRecipes(), },
	goals = {item = {milk_blend_truffles = 50}},
	reward = {IncrementQuestVar("QuestCounter"), item = {milk_blend_truffles = -50}, IncrementQuestVar("EndStory")},
	followup = "choco54",
}

DefineQuest
{
	name = "choco54",
	requirements = {quest = "choco53"},
	starter = "istshopkeep",
	ender = "accramarketkeep",
	forceAccept = true,
	followup = "choco55",
}

DefineQuest
{
	name = "choco55",
	requirements = {quest = "choco54"},
	starter = "accramarketkeep",
	ender = "trinparkkeep",
	gift = {recipe = {"blend_mint_coffee_truffles"}, ShowRecipes(), },
	goals = {item = {blend_mint_coffee_truffles = 50}},
	reward = {IncrementQuestVar("QuestCounter"), item = {blend_mint_coffee_truffles = -50}, IncrementQuestVar("EndStory")},
	followup = "choco55b",
}

DefineQuest
{
	name = "choco55b",
	requirements = {quest = "choco55"},
	starter = "trinparkkeep",
	ender = "nysalooner",
	followup = "choco56",
}

DefineQuest
{
	name = "choco56",
	requirements = {quest = "choco55"},
	starter = "nysalooner",
	ender = "hkpeakkeep",
	gift = {recipe = {"blend_raspberry_coconut_truffles"}, ShowRecipes(), },
	goals = {item = {blend_raspberry_coconut_truffles = 50}},
	reward = {IncrementQuestVar("QuestCounter"), item = {blend_raspberry_coconut_truffles = -50}, LedgerMessage("choco56_hint"), IncrementQuestVar("EndStory")},
}

DefineQuest
{
	name = "choco57",
	requirements = {quest = "choco56"},
	starter = "sydshopkeep",
	gift = { OwnBuilding("sydshop")},
	ender = "sydquaykeep",
	reward = {IncrementQuestVar("QuestCounter"), IncrementQuestVar("EndStory")},
	followup ="choco58",
}

DefineQuest
{
	name = "choco58",
	requirements = {quest = "choco57"},
	starter = "sydquaykeep",
	ender = "sftutor",
	gift = {recipe = {"exdark_blend_truffles"}, ShowRecipes(), },
	goals = {item = {exdark_blend_truffles = 100}},
	reward = {IncrementQuestVar("QuestCounter"), IncrementQuestVar("EndStory"), CharacterDialog("qextra_choco58"), item = {exdark_blend_truffles = -100}, rank =4, MCFanfare},
}

DefineQuest
{
	name = "mastermessage",
	requirements = {quest = "choco58", rank =4},
	starter = "sftutor",
	silent = true,
	repeatable = true,
	forceAccept = true,
	forceComplete = true,
}

DefineQuest
{
	name = "c_story01",
	requirements = { rank = 3  },
	starter = "colshopkeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "c_story02",
	requirements = { rank = 3  },
	starter = "sulafarmkeep",
	forceAccept = true,
	forceComplete = true,
	silent=true,
}

DefineQuest
{
	name = "evil_out",
	requirements = { rank = 3, QuestVarEqualTo("GrimOut",5)  },
	starter = "villain",
	forceAccept = true,
	forceComplete = true,
	reward = {IncrementQuestVar("GrimOut")},
	silent=true,
}

DefineQuest
{
	name = "evil_over",
	requirements = { rank = 3, QuestVarEqualTo("GrimOut",6)},
	starter = "villain",
	forceAccept = true,
	forceComplete = true,
	repeatable = true,
	silent=true,
}

DefineQuest
{
	name = "airship",
	requirements = { money = 1000000, QuestVarLessThan("OwnAirship",1) },
	starter = "announcer",
	forceOffer = true,
	denial = {DelayQuest("airship",52)},
	reward = {IncrementQuestVar("QuestCounter"), money = -250000, SetQuestFlag("airship"), IncrementQuestVar("OwnAirship"), LedgerMessage("message_airship")},
}
