--[[---------------------------------------------------------------------------
	Chocolatier Port Data: New York
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "nyshopkeep", appearance = "nyshopkeep" }
	
DefineCharacter { name = "nymarketkeep", appearance = "nymarketkeep", haggleFactor=.92}
	
DefineCharacter { name = "nyfactorykeep", appearance = "nyfactorykeep" }
	
DefineCharacter { name = "nysalooner", appearance = "nysalooner" }

DefineCharacter { name = "nylibrarian", appearance="nylibrarian", action = Speak { "librarian1"}, }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "newyork",
	available = false,
	mapx = 207, mapy = 118, labelpos = kHAlignRight,
	
	availability =
	{
		sugar = true,
		milk = true,
		mint = true,
	},
	
	layout =
	{
--[[	
		Animation { name="cloudsfar", image="ports/clouds_far", animx=0, animy=-72, xtile=800,flip=false, path={time=170000,loop=true,{-400,120},{400,120}} },
		BitmapLayer { name = "nyhorizon",x=0,y=29,image = "ports/ny_horizon", },
		Animation { name="cloudsclose", image="ports/sf_clouds", animx=0, animy=12, xtile=800, flip=false, path={time=95000,loop=true,{-400,0},{400,0}} },
		Building { name = "nylibrary",character = "nylibrarian",x=181,y=76,image = "ny_library", },
		Animation { name="horsebuggy_far", anim="ports/horsebuggywalk.xml", scale=0.3, animx=-125, animy=-60,fps=30, path={time=180000,loop=true,{-100,200},{450,200},{-100,200}} },
		Shop { name = "nyshop",character = "nyshopkeep",x=370,y=106,image = "ny_shop", },
		BitmapLayer { name = "nybridgeback",x=504,y=0,image = "ports/ny_bridgeback", },
		Building { name = "nysaloon",character = "nysalooner",x=82,y=139,image = "ny_saloon", },
		Animation { name = "trainpasscar1", image="ports/steamtrain_passengercar", scale=0.4, animx=57, animy=-85,path={time=45000,loop=true,{900,305},{-400,305}} },
		Animation { name = "trainpasscar2", image="ports/steamtrain_passengercar", scale=0.4, animx=103, animy=-85,path={time=45000,loop=true,{900,305},{-400,305}} },
		Animation { name = "trainpasscar3", image="ports/steamtrain_passengercar", scale=0.4, animx=148, animy=-85,path={time=45000,loop=true,{900,305},{-400,305}} },
		Animation { name = "train", animy=-88, anim="ports/steamtrain_engine_anim.xml", scale=0.4, fps=12,path={time=45000,loop=true,{900,305},{-400,305}} },
		BitmapLayer { name = "nydepot",x=226,y=157,image = "ports/ny_depot", },
		Market { name = "nymarket",character = "nymarketkeep",x=0,y=130,image = "ny_market", area={{10,3,106,125},{0,126,233,151}}, },
		Animation { name = "steamship_1", animy=-34, anim="ports/steamship.xml", scale=0.4, fps=24,path={time=125000,loop=true,{1300,290},{-450,320}} },
		Animation { name = "steamship_2", animy=-34, anim="ports/steamship.xml", scale=0.5, fps=24,path={time=100000,loop=true,{-300,360},{900,310}} },
		Factory { name = "nyfactory",price=16500,character = "nyfactorykeep",scale=0.9, x=333,y=186,image = "factory", area={{92,0,302,112},{0,115,392,198}} },
		BitmapLayer { name = "nybridgefront",x=686,y=0,image = "ports/ny_bridgefront", },
		Animation { name="horsebuggy_close", anim="ports/horsebuggywalk.xml", scale=0.7, animx=-125, animy=-24, fps=30, path={time=50000,loop=true,{400,400},{1000,420},{400,400}} },
		PlayerLogo { name = "logo", building="nyfactory", x=92,y=23,w=170 },
--]]

		Animation { random=true,  animy=3, anim="ports/airship_fly.xml", fps=24, scale=0.1, path={time=90000,loop=true,{200,45},{-100,45},{1200,45},{200,45}} },
		Animation { random=true,  image="ports/ny_clouds", xtile=800,flip=false, path={time=150000,loop=true,{-400,34},{400,34}} },
		BitmapLayer { image = "ports/ny_cloudmask",x=0,y=0 },
		
		Building { name = "nylibrary",character = "nylibrarian", x=144,y=80,image="ny_library" },
		Animation { random=true,  anim="ports/carriage.xml", scale=0.3, fps=15,loop=true,path={time=45000,loop=true,{45,146},{260,146},{45,146}} },
		Animation { random=true,  anim="ports/carriage.xml", scale=0.32, fps=13,loop=true,path={time=38000,loop=true,{45,148},{260,148},{45,148}} },

		BitmapLayer { image = "ports/ny_libover",x=146,y=111 },
		Shop { name = "nyshop",character = "nyshopkeep", x=435,y=83,image="ny_shop" },
		BitmapLayer { image = "ports/ny_shopover",x=433,y=65 },
		Building { name = "nysaloon",character = "nysalooner", x=13,y=134,image = "ny_pub", },
		
		Animation { name = "trainpasscar1", image="ports/steamtrain_passengercar", scale=0.4, animx=57, animy=-85,path={time=45000,loop=true,{900,303},{-400,303}} },
		Animation { name = "trainpasscar2", image="ports/steamtrain_passengercar", scale=0.4, animx=103, animy=-85,path={time=45000,loop=true,{900,303},{-400,303}} },
		Animation { name = "trainpasscar3", image="ports/steamtrain_passengercar", scale=0.4, animx=148, animy=-85,path={time=45000,loop=true,{900,303},{-400,303}} },
		Animation { name = "train", animy=-88, anim="ports/steamtrain_engine_anim.xml", scale=0.4, fps=12,path={time=45000,loop=true,{900,303},{-400,303}} },
		
		Animation { name = "trainpasscar1", image="ports/steamtrain_passengercar", scale=0.45, animx=-65, animy=-85,path={time=85000,loop=true,{-400,310},{900,310}} },
		Animation { name = "trainpasscar2", image="ports/steamtrain_passengercar", scale=0.45, animx=-118, animy=-85,path={time=85000,loop=true,{-400,310},{900,310}} },
		Animation { name = "trainpasscar3", image="ports/steamtrain_passengercar", scale=0.45, animx=-169, animy=-85,path={time=85000,loop=true,{-400,310},{900,310}} },
		Animation { name = "train", animy=-88, anim="ports/steamtrain_engine_anim.xml", scale=0.45, fps=8,path={time=85000,loop=true,{-400,310},{900,310}} },
		
		BitmapLayer { name = "nytrainmask",x=222,y=204,image = "ports/ny_trainmask", },
		
		
		Market { name = "nymarket",character = "nymarketkeep", x=0,y=219,image = "ny_pier" },
		
		Animation { random=true,  anim="ports/wave.xml", scale= 0.5, fps = 14, animx=365,animy=253 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.7, fps = 12, animx=501,animy=260 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.3, fps = 16, animx=16,animy=393 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.5, fps = 12, animx=118,animy=343 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.7, fps = 11, animx=277,animy=336 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.8, fps = 13, animx=633,animy=275 } ,
		
		Animation { random=true,  anim="ports/boat_schooner.xml", fps=24, scale=.5, animy=-73*.5, path={time=110000,loop=true,{-100,320},{175,312 },{380,309},{479,280},{910,280},{600,280},{479,315},{-300,321},{-100,320} } },
		BitmapLayer { name = "nytrainmask2",x=691,y=182,image = "ports/ny_trainmask2", },
		
		--Factory { name = "nyfactory",price=17500,character = "nyfactorykeep",scale= 0.9, x=343,y=125,image="factory" },
		Factory { name = "nyfactory",price=17500,character = "nyfactorykeep",scale= 0.9, x=343,y=125,image="factory", area={{0,160,394,285},{47,7,86,164},{274,7,313,164}} },
		PlayerLogo { name="logo", building="nyfactory", x=85,y=44,w=185},
		Animation { random=true,  anim="ports/horsebuggywalk.xml", scale=1.0*.5, animy=-20*.5, loop=true,fps=18,path={time=70000,loop=true,{460,385},{744,398},{1200,385},{744,398},{460,385}} },
		Animation { random=true,  anim="ports/horsebuggywalk.xml", scale=1.0*.5, animy=-20*.5, loop=true,fps=15,path={time=80000,loop=true,{1000,416},{700,412},{615,389},{341,385},{660,394},{749,416},{1000,416}} },
	},
}
