--[[---------------------------------------------------------------------------
	Chocolatier Port Data: Merida
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "mershopkeep", appearance="mershopkeep" }

DefineCharacter { name = "mermarketkeep", appearance = "mermarketkeep", haggleFactor=1.5 }

DefineCharacter { name = "mersalooner", appearance = "mersalooner" }

DefineCharacter { name = "merplazakeep", appearance="merplazakeep", action = Speak { "merplazakeep1"} }

DefineCharacter { name = "merruinskeep", appearance="merruinskeep", action = Speak { "merruinskeep1"} }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "merida",
	available = false,
	mapx = 165, mapy = 171, labelpos = kHAlignLeft,

	availability =
	{
		sugar = true,
		milk = true,
		cacao = true,
-- 		truffle_powder should be added later (close to when truffles recipes are learned?) if possible
--		truffle_powder = true,
		cashews = true,
	},
	
	-- NOTES: OPTIMIZED
	layout =
	{
		Animation { random=true,  image="ports/mer_clouds_far", xtile=800,flip=false, path={time=400000,loop=true,{-400,37+39},{400,37+39}} },
		Animation { random=true,  image="ports/mer_clouds", xtile=800,flip=false, path={time=175000,loop=true,{-400,44},{400,44}} },
		BitmapLayer { image = "ports/mer_cloudmask",x=0,y=95},
	
		Building { name = "merruins",character = "merruinskeep",x=450,y=47,image = "mer_chichenitza",},
		BitmapLayer { image="ports/mer_treeline",x=450,y=47+56 },
		Building { name = "merplaza",character = "merplazakeep",x=26,y=0,image = "mer_plaza",},			-- mer_plaza (32,260)
		BitmapLayer { image="ports/mer_plazaover",x=26,y=118 },
		Market { name = "mermarket",character = "mermarketkeep",x=246,y=131,image = "mer_market",},		-- mer_market (263,129)
		BitmapLayer { image="ports/mer_marketover",x=246,y=131 },

		Animation { random=true,  anim="ports/horsebuggywalk.xml", scale=1.0, animy=-20.8, scale=.8, loop=true,fps=15,path={time=60000,loop=true,{-100,290},{136,327},{320,304},{136,327},{-200,290}} },
		Animation { random=true,  anim="ports/horsebuggywalk.xml", scale=1.0, animy=-20*.8, scale=.8, loop=true,fps=15,path={time=80000,loop=true,{430,271},{1000,271},{233,271},{430,271}} },
		BitmapLayer { image="ports/mer_toproadmask", x=191,y=229, },
		BitmapLayer { image="ports/mer_leftroadmask", x=0,y=248, },
 		
		Shop { name = "mershop",character = "mershopkeep",x=238,y=265,image = "mer_shop",},		-- mer_shop(246,261)
		BitmapLayer { image="ports/mer_shopover",x=238,y=265 },
		Building { name = "mersaloon",character = "mersalooner", ambient=kSaloonAmbient,x=492,y=231,image = "mer_cantina",},	-- mer_cantina(508,230)
		BitmapLayer { image="ports/mer_cantover",x=492,y=231+35 },

		Animation { random=true,  anim="ports/horsebuggywalk.xml", scale=1.0, animy=-20.8, scale=.8, loop=true,fps=15,path={time=80000,loop=true,{1000,385},{290,385},{1000,385}} },
		BitmapLayer { image="ports/mer_bottomroadmask", x=244,y=354, },
	},
}
