--[[---------------------------------------------------------------------------
	Chocolatier Port Data: Mahajanga
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "mahashopkeep", appearance="mahashopkeep" }

DefineCharacter { name = "mahamarketkeep", appearance="mahamarketkeep" }

DefineCharacter { name = "mahafactorykeep", appearance="mahafactorykeep" }

DefineCharacter { name = "mahabwalkkeep", appearance="mahabwalkkeep" }

DefineCharacter { name = "mahafarmer", appearance="extra7",
	action = SellItem("farm_sale", "mahajanga_cacao"),
}

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "mahajanga",
	available = false,
	mapx = 487, mapy = 293, labelpos = kHAlignRight,

	availability =
	{
		sugar = true,
		milk = true,
		cacao = true,
--		truffle_powder = true,
		vanilla = true,
		almonds = true,
		cashews = true,
	},
	
	layout =
	{
		Animation { random=true,  image="ports/maha_clouds_far", xtile=800,flip=false, path={time=400000,loop=true,{-400,75+41},{400,75+41}} },
		Animation { random=true,  image="ports/maha_clouds", xtile=800,flip=false, path={time=175000,loop=true,{-400,46},{400,46}} },
		BitmapLayer { image = "ports/maha_cloudmask1",x=547,y=83},
		BitmapLayer { image = "ports/maha_cloudmask2",x=0,y=31 },
		
		Building { name = "mahafarm",character = "mahafarmer", ambient=kFarmAmbient, x=552,y=83,image="maha_farm"},
		Factory { name = "mahafactory",price=52250,character = "mahafactorykeep",scale=0.4,x=220,y=66,image="factory", },
		PlayerLogo { name="logo", building="mahafactory", x=36,y=13,w=85 },
		BitmapLayer { image = "ports/maha_factover",x=223,y=169,},
		Shop { name = "mahashop",character = "mahashopkeep",x=458,y=122,image="maha_shop", },
		Building { name = "mahabwalk",character = "mahabwalkkeep", x=332,y=344,image="maha_bwalk", },
		
		Animation { random=true,  anim="ports/horsebuggywalk.xml", scale=1.0, animy=-20, loop=true,fps=18,path={time=100000,loop=true,{850,265},{634,270},{300,265},{-350,260},{308,265},{634,270},{800,265}} },
		
		BitmapLayer { image = "ports/maha_roadmask",x=300,y=232,},
		Market { name = "mahamarket",character = "mahamarketkeep", x=0,y=198,image="maha_market", },

		Animation { random=true,  anim="ports/wave.xml", scale= 1.3, fps = 8, animx=30,animy=430 },
		Animation { random=true,  anim="ports/wave.xml", scale= 1.3, fps = 8, animx=165,animy=430 },
		Animation { random=true,  anim="ports/wave.xml", scale= 1.3, fps = 8, animx=420,animy=415 },
		Animation { random=true,  anim="ports/wave.xml", scale= 1.3, fps = 7, animx=750,animy=420 },
	},
}
