--[[---------------------------------------------------------------------------
	Chocolatier Port Data: London
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "ukmarketkeep", appearance="ukmarketkeep", haggleFactor=1.06 }

DefineCharacter { name = "ukshopkeep", appearance="ukshopkeep" }

DefineCharacter { name = "ukpalacekeep", appearance="ukpalacekeep"}

DefineCharacter { name = "ukpubkeep", appearance="ukpubkeep"}

-- *** REAL CHARACTER DRAWING PENDING - FOLLOWING IS PLACEHOLDER
DefineCharacter { name = "ukfactorykeep", appearance="extra4" }


-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "london",
	available = false,
	mapx = 364, mapy = 87, labelpos = kHAlignLeft,

	availability =
	{
		sugar = true,
		milk = true,
		caramel = true,
		almonds = true,
		cherry = true,
		mint = true,
	},
	
	-- NOTES: OPTIMIZED
	layout =
	{
		Animation { random=true, image="ports/lon_clouds", xtile=800,flip=false, path={time=200000,loop=true,{-400,20},{400,20}} },
		
		Animation { name = "trainpasscar1", image="ports/steamtrain_passengercar", scale=0.25, animx=-35, animy=-85,path={time=55000,loop=true,{-400,165},{1100,165}} },
		Animation { name = "trainpasscar2", image="ports/steamtrain_passengercar", scale=0.25, animx=-65, animy=-85,path={time=55000,loop=true,{-400,165},{1100,165}} },
		Animation { name = "trainpasscar3", image="ports/steamtrain_passengercar", scale=0.25, animx=-95, animy=-85,path={time=55000,loop=true,{-400,165},{1100,165}} },
		Animation { name = "train", animy=-88, anim="ports/steamtrain_engine_anim.xml", scale=0.25, fps=18,path={time=55000,loop=true,{-400,167},{1100,167}} },
		
		Building { name = "ukpalace",character = "ukpalacekeep", image="lon_palace",x=267,y=90, area={{0,0,311,42},{118,42,215,96},{0,42,118,56}} },
		Animation { random=true, name="carriage_far1", anim="ports/carriage.xml", scale=0.3, animy=0, animx=0, fps=18,path={time=40000,loop=true,{300,184},{488,184},{300,184}} },
		Animation { random=true, name="carriage_far2", anim="ports/carriage.xml", scale=0.32, animy=0, animx=0, fps=16,path={time=45000,loop=true,{488,187},{300,187}} },
		BitmapLayer { image="ports/lon_palover",x=451,y=110 },
		Building { name = "ukpub",character = "ukpubkeep", ambient=kSaloonAmbient, x=539,y=100,image="lon_pub" },
		
		Shop { name = "ukshop",character = "ukshopkeep", x=257,y=116,image="lon_shop" },
		
		

		Factory { name = "ukfactory", price=71000, character = "ukfactorykeep",scale=0.4,x=44,y=45,image="factory", },
		PlayerLogo { name="logo", building="ukfactory", x=37,y=14,w=85 },
		BitmapLayer { image="ports/lon_factover",x=0,y=0 },
		
		Animation { random=true, name="carriage_close1", anim="ports/carriage.xml", scale=0.61, animy=0, animx=0, fps=17,path={time=120000,loop=true,{-100,248},{200,240},{800,240},{200,240},{-100,248}} },
		Animation { random=true, name="carriage_close2", anim="ports/carriage.xml", scale=0.62, animy=0, animx=0, fps=14,path={time=119000,loop=true,{-100,250},{200,241},{800,248}} },
		Animation { random=true, name="carriage_close3", anim="ports/carriage.xml", scale=0.65, animy=0, animx=0, fps=19,path={time=115000,loop=true,{800,250},{200,244},{-100,252}} },

		Market { name = "ukmarket",character = "ukmarketkeep", image="lon_market",x=615,y=101, area={{141,2,188,48},{74,48,188,85},{47,85,188,135},{0,135,188,217}} },
		BitmapLayer { image="ports/lon_markover",x=612,y=280 },
		
		BitmapLayer { image="ports/lon_shopover",x=0,y=181 },

		Animation { random=true,  anim="ports/wave.xml", scale= 0.3, fps = 9, animx=327,animy=319 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.4, fps = 8, animx=375,animy=322 },
		Animation { random=true,  anim="ports/wave.xml", scale= 0.6, fps = 10, animx=403,animy=310},
		Animation { random=true,  anim="ports/wave.xml", scale= 0.7, fps = 9, animx=302,animy=314},
		Animation { random=true,  anim="ports/wave.xml", scale= 0.5, fps = 10, animx=50,animy=400},

		Animation { random=true, anim="ports/boat_schooner.xml", fps=24, scale=.4, path={time=5000,loop=true,{490,282},{490.1,279},{490.2,282}} },

		Animation { random=true,  anim="ports/boat_schooner.xml", fps=24, scale=.5, animy=-73*.4, path={time=60000,loop=true,{-600,323},{0,323},{202,370},{448,330},{-200,321}} },
		Animation { random=true, animy=-20 , anim="ports/steamship.xml", scale=.7, fps=24,path={time=40000,loop=true,{-1000,386},{230,386},{650,475}} },

		BitmapLayer { image="ports/lon_frontleft", x=0,y=326 },
	},
}
