--[[---------------------------------------------------------------------------
	Chocolatier Ingredient/Product Data
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
	See external documentation.
--]]---------------------------------------------------------------------------

-- PRODUCT TYPES --------------------------------------------------------------
-- Usable Factory parameters:
--   trayCount = X			(default 7, maximum 8) number of trays on the wheel
--   ingredientRate = X		(default 350) rate at which ingredients enter conveyor

DefineProductType
{
	name = "bar",
	price = 1,
	markup = 3,
}

-- squares are more difficult than bars, require at least 4 ingredients

DefineProductType
{
	name = "square",
	price = 25000,
	trayCount = 8,
	markup = 3.55,
	startspeed = .9,
	speedup = 1.07,
	maxspeed = 8,
}


-- infusions are more difficult than squares, require at least 5 ingredients

DefineProductType
{
	name = "infusion",
	price = 45000,
	trayCount = 7,
	markup = 3.95,
	startspeed = .8,
	speedup = 1.1,
	maxspeed = 8,
}


-- truffles are the most difficult - 5 ingredients + cacao powder

DefineProductType
{
	name = "truffle",
	price = 75000,
	trayCount = 6,
	markup = 4.55,
	startspeed = .9,
	speedup = 1.09,
	maxspeed = 8,
}


-- BASIC INGREDIENTS ----------------------------------------------------------
DefineItem { "sugar", low = 2, high = 6 }
DefineItem { "milk", low = 4, high = 11 }
DefineItem { "cacao", low = 8, high = 28 }
DefineItem { "caramel", low = 15, high = 35 }

-- NUTS -----------------------------------------------------------------------
DefineItem { "almonds", low = 19, high = 34 }
DefineItem { "cashews", low = 21, high = 30 }
DefineItem { "hazelnuts", low = 33, high = 68 }
DefineItem { "macadamias", low = 42, high = 105 }

-- FRUITS  --------------------------------------------------------------------
DefineItem { "coconut", low = 21, high = 39 }
DefineItem { "raspberry", low = 65, high = 101 }
DefineItem { "cherry", low = 42, high = 176 }
DefineItem { "lemon", low = 12, high = 25 }

-- FLAVORS --------------------------------------------------------------------
DefineItem { "vanilla", low = 83, high = 125 }
DefineItem { "coffee", low = 50, high = 90 }
DefineItem { "mint", low = 24, high = 39 }
DefineItem { "cinnamon", low = 28, high = 46 }

-- SPECIALTY ------------------------------------------------------------------
DefineItem { "mahajanga_cacao", low=39, high = 62 }
DefineItem { "quito_cacao", low= 35, high= 53 }
DefineItem { "sulawesi_cacao", low= 80 , high= 120 }
DefineItem { "trinidad_cacao", low= 45 , high= 82 }
DefineItem { "colombo_cacao", low= 74 , high= 91 }


-- POWDER FOR TRUFFLES   --------------------------------------------------------
DefineItem { "truffle_powder", low= 175 , high= 289 }




--  2-INGREDIENT  BARS -------------------------------------------

DefineItem { "basebars", low = 11, high = 15, type = "bar", free=true,
				recipe = { sugar = 1, cacao = 1 } }
				
				
--  3-INGREDIENT  BARS -------------------------------------------			
				
DefineItem { "darkbars", type = "bar", free=true,
				recipe = { sugar = 1, cacao = 2 } }
DefineItem { "milkbars", type = "bar", free=true,
				recipe = { sugar = 1, cacao = 1, milk = 1 } }				
DefineItem { "almondbars", type = "bar", free=true,
				recipe = { sugar = 1, cacao = 1, almonds = 1 } }				
DefineItem { "cashewbars", type = "bar", free=true,
				recipe = { sugar = 1, cacao = 1, cashews = 1 } }				
DefineItem { "coffeebars", type = "bar", free=true,
				recipe = { sugar = 1, cacao = 1, coffee = 1 } }				
DefineItem { "lemonbars", type = "bar", free=true,
				recipe = { sugar = 1, cacao = 1, lemon = 1 } }				
DefineItem { "mintbars",  type = "bar", free=true,
				recipe = { sugar = 1, cacao = 1, mint = 1 } }
DefineItem { "quitodarkbars", type = "bar", free=true,
				recipe = { sugar = 1, quito_cacao = 2 } }
DefineItem { "trindarkbars", type = "bar", free=true,
				recipe = { sugar = 1, trinidad_cacao = 2 } }
				
-- The following are PHASE II bars (ingredients available only in Phase 2 ports).

DefineItem { "mahadarkbars", type = "bar", free=true,
				recipe = { sugar = 1, mahajanga_cacao = 2 } }
DefineItem { "colodarkbars", type = "bar", free=true,
				recipe = { sugar = 1, colombo_cacao = 2 } }
--DefineItem { "suladarkbars", type = "bar", free=true,
--				recipe = { sugar = 1, sulawesi_cacao = 2 } }
				
				
--  4-INGREDIENT  BARS -------------------------------------------
--  These should only be used in Phase 2 Quests and beyond - 
--  Squares should be the 1st 4-ingredient products encountered	
				
DefineItem { "xdarkbars", type = "bar", free=true,
				recipe = { sugar = 1, cacao = 3 } }				
DefineItem { "whitebars", type = "bar", free=true,
				recipe = { sugar = 2, cacao = 1, milk = 1 } }
DefineItem { "almond_darkbars", type = "bar", free=true,
				recipe = { sugar = 1, cacao = 2, almonds = 1 } }
DefineItem { "coffee_darkbars", type = "bar", free=true,
				recipe = { sugar = 1, cacao = 2, coffee = 1 } }
				

-- 4-INGREDIENT SQUARES -------------------------------------------------------------------
-- Phase I ingredient squares -------------------------------------------

DefineItem { "xdark_sq", type = "square", free=true,
				recipe = { sugar = 1, cacao = 3} }
DefineItem { "cashew_dark_sq", type = "square", free=true,
				recipe = { sugar = 1, cacao = 2, cashews = 1} }				
DefineItem { "almond_dark_sq", type = "square", free=true,
				recipe = { sugar = 1, cacao = 2, almonds = 1} }
DefineItem { "hazelnut_squares", type = "square", free=true,
				recipe = { sugar = 1, cacao = 2, hazelnuts = 1} }
-- Phase II ingredient squares -------------------------------------------

DefineItem { "cherry_squares", type = "square", free=true,
				recipe = { sugar = 1, cacao = 2, cherry = 1} }
DefineItem { "cinnamon_squares", type = "square", free=true,
				recipe = { sugar = 1, cacao = 2, cinnamon = 1} }
DefineItem { "caramel_squares", type = "square", free=true,
				recipe = { sugar = 1, cacao = 2, caramel = 1} }
DefineItem { "hazelnut_milk_sq", type = "square", free=true,
				recipe = { sugar = 1, cacao = 1, milk = 1, hazelnuts = 1 } }
DefineItem { "coffee_squares", type = "square", free=true,
				recipe = { sugar = 1, cacao = 2, coffee = 1,} }
DefineItem { "mint_squares", type = "square", free=true,
				recipe = { sugar = 1, cacao = 2, mint = 1,} }
DefineItem { "almond_squares", type = "square", free=true,
				recipe = { sugar = 1, cacao = 1, almonds = 2,} }
DefineItem { "cherry_van_squares", type = "square", free=true,
				recipe = { sugar = 1, cacao = 1, cherry = 1, vanilla = 1,} }
DefineItem { "cinnamon_van_squares", type = "square", free=true,
				recipe = { sugar = 1, cacao = 1, cinnamon = 1, vanilla = 1,} }
DefineItem { "milk_van_squares", type = "square", free=true,
				recipe = { sugar = 1, cacao = 1, milk = 1, vanilla = 1,} }
DefineItem { "hazelnut_van_squares", type = "square", free=true,
				recipe = { sugar = 1, cacao = 1, hazelnuts = 1, vanilla = 1,} }
DefineItem { "almond_van_squares", type = "square", free=true,
				recipe = { sugar = 1, cacao = 1, almonds = 1, vanilla = 1,} }


		
-- 5-ITEM INFUSIONS -------------------------------------------------------------------

DefineItem { "milk_choc_infusion", type = "infusion", free=true,
				recipe = { sugar = 2, milk =2, cacao = 1} }
DefineItem { "coconut_infusion", type = "infusion", free=true,
				recipe = { sugar = 1, milk =1, cacao = 2, coconut = 1} }
DefineItem { "cherry_infusion", type = "infusion", free=true,
				recipe = { sugar = 1, milk=1, cacao = 2, cherry = 1} }
DefineItem { "coffee_infusion", type = "infusion", free=true,
				recipe = { sugar = 1, milk =1, cacao = 2, coffee = 1} }
DefineItem { "raspberry_infusion", type = "infusion", free=true,
				recipe = { sugar = 1, milk = 1, cacao = 2, raspberry = 1} }
DefineItem { "vanilla_almond_infusion", type = "infusion", free=true,
				recipe = { sugar = 1, cacao = 2, vanilla = 1, almonds = 1} }
DefineItem { "lemon_infusion", type = "infusion", free=true,
				recipe = { sugar = 1, milk=1, cacao = 2, lemon = 1} }
DefineItem { "cinnamon_infusion", type = "infusion", free=true,
				recipe = { sugar = 1, milk =1, cacao = 2, cinnamon = 1} }
DefineItem { "mint_infusion", type = "infusion", free=true,
				recipe = { sugar = 1, milk =1, cacao = 2, mint = 1} }
				
DefineItem { "maha_cherry_infusion", type = "infusion", free=true,
				recipe = { sugar = 2, mahajanga_cacao = 2, cherry = 1} }
DefineItem { "quito_coffee_infusion", type = "infusion", free=true,
				recipe = { sugar = 2, quito_cacao = 2, coffee = 1} }
DefineItem { "colo_raspberry_infusion", type = "infusion", free=true,
				recipe = { sugar = 2, colombo_cacao = 2, raspberry = 1} }				

				
DefineItem { "maha_mint_raspberry_infusion", type = "infusion", free=true,
				recipe = { sugar = 1, mahajanga_cacao = 2, raspberry = 1, mint = 1} }	
DefineItem { "colo_coffee_almond_infusion", type = "infusion", free=true,
				recipe = { sugar = 1, colombo_cacao = 2, coffee = 1, almonds = 1} }
DefineItem { "sula_macadamia_infusion", type = "infusion", free=true,
				recipe = { sugar = 1, sulawesi_cacao = 2, vanilla = 1, macadamias = 1} }
				
DefineItem { "cacao_blend_infusion", type = "infusion", free=true,
				recipe = { sugar = 1, sulawesi_cacao = 1, mahajanga_cacao = 1, trinidad_cacao = 1, vanilla = 1} }				
	
							
-- 6-ITEM TRUFFLES -------------------------------------------------------------------
DefineItem { "dark_truffles", type = "truffle", free=false,
				recipe = { sugar = 2, cacao = 3, truffle_powder = 1 } }
DefineItem { "milk_truffles", type = "truffle", free=false,
				recipe = { sugar = 2, cacao = 2, milk = 1, truffle_powder = 1 } }
DefineItem { "mint_choco_truffles", type = "truffle", free=false,
				recipe = { sugar = 2, cacao = 2, mint = 1, truffle_powder = 1 } }
DefineItem { "almond_choco_truffles", type = "truffle", free=false,
				recipe = { sugar = 2, cacao = 2, almonds = 1, truffle_powder = 1 } }
				
DefineItem { "caramel_truffles", type = "truffle", free=false,
				recipe = { sugar = 1, cacao = 2, caramel = 2, truffle_powder = 1 } }
DefineItem { "hazelnut_milk_truffles", type = "truffle", free=false,
				recipe = { sugar = 1, cacao = 2, milk = 1, hazelnuts = 1, truffle_powder = 1 } }
DefineItem { "coconut_lemon_truffles", type = "truffle", free=false,
				recipe = { sugar = 1, cacao = 2, coconut = 1, lemon = 1, truffle_powder = 1 } }
DefineItem { "coffee_cinnamon_truffles", type = "truffle", free=false,
				recipe = { sugar = 1, cacao = 2, cinnamon = 1, coffee = 1, truffle_powder = 1 } }
				
DefineItem { "maha_cinnamon_cherry_truffles", type = "truffle", free=false,
				recipe = { sugar = 1, mahajanga_cacao = 2, cinnamon = 1, cherry = 1, truffle_powder = 1 } }
DefineItem { "sula_lemon_macadamia_truffles", type = "truffle", free=false,
				recipe = { sugar = 1, sulawesi_cacao = 2, lemon = 1, macadamias = 1, truffle_powder = 1 } }
DefineItem { "colo_coffee_caramel_truffles", type = "truffle", free=false,
				recipe = { sugar = 1, colombo_cacao = 2, coffee = 1, caramel = 1, truffle_powder = 1 } }
DefineItem { "trin_almond_vanilla_truffles", type = "truffle", free=false,
				recipe = { sugar = 1, trinidad_cacao = 2, almonds = 1, vanilla = 1, truffle_powder = 1 } }


DefineItem { "blend_mint_coffee_truffles", type = "truffle", free=false,
				recipe = { sugar = 1, trinidad_cacao = 1, colombo_cacao = 1, mint = 1, coffee = 1, truffle_powder = 1 } }
DefineItem { "blend_raspberry_coconut_truffles", type = "truffle", free=false,
				recipe = { sugar = 1, sulawesi_cacao = 1, mahajanga_cacao = 1, raspberry = 1, coconut = 1, truffle_powder = 1 } }
DefineItem { "milk_blend_truffles", type = "truffle", free=false,
				recipe = { sugar = 1, sulawesi_cacao = 1, quito_cacao = 1, colombo_cacao = 1, milk = 1, truffle_powder = 1 } }
DefineItem { "exdark_blend_truffles", type = "truffle", free=false,
				recipe = { sugar = 1, sulawesi_cacao = 1, mahajanga_cacao = 1, colombo_cacao = 1, trinidad_cacao = 1, truffle_powder = 1 } }
