--[[---------------------------------------------------------------------------
	Chocolatier Port Data: Istanbul
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "istshopkeep", appearance = "istshopkeep" }

DefineCharacter { name = "istmarketkeep", appearance = "istmarketkeep", haggleFactor=1.11 }

DefineCharacter { name = "isthippokeep", appearance = "isthippokeep" }

DefineCharacter { name = "isttowerkeep", appearance = "isttowerkeep",
	action = Speak { "isttowerkeep1"},
	}
-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "istanbul",
	available = false,
	mapx = 436, mapy = 116, labelpos = kHAlignRight,

	availability =
	{
		sugar = true,
		milk = true,
		hazelnuts = true,
		mint = true,
		cherry = true,
		coffee = true,
	},
	
	-- NOTES: OPTIMIZED
	layout =
	{
		Animation { random=true,  anim="ports/wave.xml", scale= .3, fps = 10, animx=30,animy=140},
		Animation { random=true,  anim="ports/wave.xml", scale= .2, fps = 8, animx=100,animy=160},
		Animation { random=true,  anim="ports/wave.xml", scale= .3, fps = 9, animx=165,animy=143},
		Animation { random=true,  anim="ports/wave.xml", scale= .3, fps = 8, animx=250,animy=140},

		Animation { random=true, anim="ports/boat_schooner.xml", fps=24, scale=.08, animy=-73*.08, path={time=190000,loop=true,{-100,137},{296,135},{468,137},{0,140},{-100,137}} },
		Animation { random=true, anim="ports/boat_schooner.xml", fps=24, scale=.15, animy=-73*.15, path={time=170000,loop=true,{-100,151},{296,151},{365,145},{0,145},{-100,151}} },
		Animation { random=true, anim="ports/airship_fly.xml", fps=24, animy=-62*.4,scale=0.4, path={time=90000,loop=true,{-600,75},{0,75},{479,44},{709,0},{800,-100}} },

		BitmapLayer { image="ports/ist_skyline",x=145,y=40 },
		Market { name="istmarket",character="istmarketkeep", x=565,y=179,image="ist_bazaar", },
		Shop { name="istshop",character="istshopkeep", x=423,y=188,image="ist_shop", },
		
		Animation { random=true,  anim="ports/wave.xml", scale= 1.2, fps = 8, animx=276,animy=290},
		Animation { random=true,  anim="ports/wave.xml", scale= .9, fps = 6, animx=30,animy=300},
		Animation { random=true,  anim="ports/wave.xml", scale= 1, fps = 7, animx=90,animy=348},

		Animation { random=true,  anim="ports/wave.xml", scale= 1.2, fps = 8, animx=276+480,animy=290+37},
		Animation { random=true,  anim="ports/wave.xml", scale= .9, fps = 6, animx=30+582,animy=300+63},

		Animation { random=true, animy=-15 , anim="ports/steamship.xml", scale=.4, fps=24,path={time=50000,loop=true,{-100,283},{244,283},{316,290},{125,295},{-500,295}} },
		
		Building { name="istkikulesi",character="isttowerkeep", x=20,y=183,image = "ist_kiz", },
		Building { name="istbridge",character="isthippokeep", x=112,y=250,image="ist_bridge", area={{60,57,379,164},{232,31,435,56},{340,14,456,31}} },

		Animation { random=true, anim="ports/boat_schooner.xml", fps=24, scale=.4, animy=-73*.4, path={time=60000,loop=true,{1200,360},{800,360},{625,345},{800,330},{900,330}} },

		BitmapLayer { image="ports/ist_forepole",x=328,y=236 },
		BitmapLayer { image="ports/ist_bridgeover",x=111,y=341 },
	},
}
