--[[---------------------------------------------------------------------------
	Chocolatier Port Data: Hong Kong
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "hkshopkeep",  appearance="hkshopkeep" }

DefineCharacter { name = "hkmarketkeep", appearance="hkmarketkeep", haggleFactor=1.3 }

DefineCharacter { name = "hkpeakkeep", appearance="hkpeakkeep" , action = Speak { "hkpeakkeepspeak1"}}

DefineCharacter { name = "hksaloonkeep", appearance="hksaloonkeep" }

DefineCharacter { name = "hkfactorykeep", appearance="extra2" }
--need to change this to hkfactorykeep - missing character sketch

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "hongkong",
	available = false,
	mapx = 634, mapy = 161, labelpos = kHAlignRight,

	availability =
	{
		sugar = true,
		milk = true,
		raspberry = true,
		almonds = true,
		coffee = true,
		cinnamon = true,
	},
	
	-- NOTES: OPTIMIZED
	layout =
	{
		Animation { random=true, image="ports/hk_clouds_far", xtile=800,flip=false, path={time=350000,loop=true,{-400,150},{400,150}} },
		
		Animation { random=true, image="ports/hk_clouds", xtile=800,flip=false, path={time=175000,loop=true,{-400,70},{400,70}} },
		Animation { random=true, anim="ports/airship_fly.xml", fps=24, animy=-62*.2,scale=0.2, path={time=90000,loop=true,{-300,22},{0,22},{324,54},{800,95},{1000,95}} },
		BitmapLayer { image = "ports/hk_cloudmask",x=209,y=20 },
		BitmapLayer { image = "ports/hk_cloudmask1",x=0,y=49 },
		BitmapLayer { image = "ports/hk_cloudmask2",x=600,y=122 },

		Building { name = "hkpeak", character = "hkpeakkeep", x=431,y=90, image = "hk_peakmansion",},

		--Animation { random=true, anim="ports/horsebuggywalk.xml", scale=.4, animy=-20*.4, loop=true,fps=16,path={time=60000,loop=true,{220,326},{420,326},{220,326}} },

		Factory { name = "hkfactory", price=115000,character = "hkfactorykeep", scale= 0.5, x=300,y=195,image="factory" },
		PlayerLogo { name="logo", building="hkfactory", x=48,y=10,w=105 },
		Market { name = "hkmarket",character = "hkmarketkeep",x=0,y=218,image = "hk_market", },

		Building { name = "hktemple", character = "hksaloonkeep", x=175,y=244, image = "hk_temple", ambient=kSaloonAmbient},

		Animation { random=true, anim="ports/horsebuggywalk.xml", scale=.5, animy=-20*.5, loop=true,fps=16,path={time=120000,loop=true,{-100,354},{364,354},{400,340},{530,340},{400,340},{364,354},{0,354},{-300,354}} },
		
		Shop { name = "hkshop",character = "hkshopkeep",x=461,y=224,image="hk_shop", },
		--BitmapLayer { image = "ports/hk_foreground",x=493+88,y=222+95,},

		Animation { random=true, anim="ports/airship_fly.xml", fps=24, animy=-62*.6,scale=0.6, path={time=70000,loop=true,{1100,75},{800,75},{0,132},{-400,132}} },
	},
}
