--[[---------------------------------------------------------------------------
	Chocolatier Port Data: Colombo
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "colshopkeep", appearance="colshopkeep" }
	
DefineCharacter { name = "colmarketkeep", appearance="colmarketkeep", haggleFactor=.94 }

DefineCharacter { name = "colfarmer", appearance="colfarmer", action = SellItem("farm_sale", "colombo_cacao"),}

DefineCharacter { name = "colsalooner", appearance="colsalooner" }

DefineCharacter { name = "colmosqueer", appearance="colmosqueer" }


-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "colombo",
	available = false,
	mapx = 571, mapy = 213, labelpos = kHAlignRight,

	availability =
	{
		sugar = true,
		milk = true,
		coconut = true,
		cacao = true,
		almonds = true,
		truffle_powder = true,
	},
	
	-- NOTES: OPTIMIZED
	layout =
	{
		Building { name = "colfarm",character = "colfarmer", x=269,y=34, image = "col_farm", ambient=kFarmAmbient},
		Animation { random=true, name="horsebuggy", anim="ports/horsebuggywalk.xml", scale=0.4, animy=0, animx=0, fps=25,path={time=50000,loop=true,{300,115},{376,105},{445,101},{630,99},{785,99}} },
		BitmapLayer { image = "ports/col_farmover",x=268,y=34,},
		
		Animation { random=true,  anim="ports/waterfall.xml", scale= 0.8, fps = 15, animx=0,animy=0, path={time=5000,loop=true,{83,143},{83.1,143},{83.2,143}}},
		Animation { random=true,  anim="ports/waterfall.xml", scale= 0.9, fps = 17, animx=0,animy=0, path={time=5000,loop=true,{72,149},{72.1,149},{72.2,149}}},
		Animation { random=true,  anim="ports/elephant.xml", scale= 1.0, fps = 8, animx=200,animy=150,},

		Animation { random=true, image="ports/col_mist", xtile=800,flip=false, path={time=61000,loop=true,{-400,100},{400,100}} },
		BitmapLayer { image = "ports/col_lakeover",x=0,y=130,},
		
--		Building { name = "colmosque", character = "colmosqueer", x=430,y=76, image = "col_mosque",},
		Building { name = "colmosque", character = "colmosqueer", x=430,y=76, image = "col_mosque",},
		Shop { name = "colshop",character = "colshopkeep",x=469,y=202,image = "col_shop",},
		Building { name = "colsaloon", character = "colsalooner", x=546,y=105, image = "col_hotel", ambient=kSaloonAmbient},
		BitmapLayer { image = "ports/col_fgright",x=430+19,y=76+117,},
--		Market { name = "colmarket",character = "colmarketkeep",x=0,y=195,image = "col_market", area={{2,2,210,99},{210,13,90,57}} },
		Market { name = "colmarket",character = "colmarketkeep",x=0,y=188,image = "col_market", area={{2,2,210,99},{210,13,90,57}} },
		BitmapLayer { image = "ports/col_fgleft",x=0,y=238,},
		
		

		Animation { random=true,  anim="ports/wave.xml", scale= 1.3, fps = 8, animx=30,animy=430 },
		Animation { random=true,  anim="ports/wave.xml", scale= 1.3, fps = 8, animx=165,animy=430 },
		Animation { random=true,  anim="ports/wave.xml", scale= 1.3, fps = 7, animx=760,animy=480 },
	},
}


