--[[---------------------------------------------------------------------------
	Chocolatier Port Data: Accra
	Copyright (c) 2006 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "accrashopkeep", appearance = "accrashopkeep"}
	
DefineCharacter { name = "accramarketkeep", appearance = "accramarketkeep" , haggleFactor=1.43}

DefineCharacter { name = "accracastlekeep", appearance = "accracastlekeep"}

DefineCharacter { name = "accralighthousekeep", appearance = "accralighthousekeep"}

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "accra",
	available = false,
	mapx = 378, mapy = 213, labelpos = kHAlignRight,
	
	availability =
	{
		sugar = true,
		milk = true,
		cacao = true,
		cinnamon = true,
		hazelnuts = true,
		mint = true,
		coffee = true,
	},
	
	-- NOTES: OPTIMIZED
	layout =
	{
		Building { name = "accracastle",character = "accracastlekeep",x=553,y=63,image="acc_castle",},  
		BitmapLayer { image="ports/acc_castleover",x=553,y=63+34 },
		Market { name = "accramarket",character = "accramarketkeep",x=324,y=128,image = "acc_market",},
		Shop { name = "accrashop",character = "accrashopkeep",x=0,y=21,image = "acc_shop", },

		Animation { random=true,  anim="ports/wave.xml", scale= 1.0, fps = 9, animx=530,animy=359},

		Animation { random=true,  anim="ports/horsebuggywalk.xml", scale=1.0*.8, animy=-20*.8, loop=true,fps=18,path={time=60000,loop=true,{0,269},{440,229},{-400,269}} },
		Animation { random=true,  anim="ports/horsebuggywalk.xml", scale=1.0*.8, animy=-20*.8, loop=true,fps=18,path={time=60000,loop=true,{328,206},{220,210},{26,235},{-400,242},{0,235},{257,200},{328,206}} },

		Building { name = "accralighthouse",character = "accralighthousekeep",x=0,y=139,image = "acc_jamesfort", area={{0,0,59,253},{59,47,166,253},{166,0,220,253},{220,120,272,253},{272,187,678,253}} },
		BitmapLayer { image="ports/acc_fortover",x=0,y=139+34 },

		Animation { random=true,  anim="ports/wave.xml", scale=.8, fps = 7, animx=750,animy=256},
	},
}
