/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.ColorString;
import game.Country;
import game.Game;
import game.Global;
import game.TechAdvance;
import game.hex.Hex;
import game.unit.Unit;
import gui.BackgroundPanel;
import gui.BeginTurnDialog;
import gui.ButtonPanel2;
import gui.ChatDialog;
import gui.CombatPanel;
import gui.ForcePoolDeploy;
import gui.HexInfoPanel;
import gui.InfoDialog;
import gui.MapCanvas;
import gui.MiniMap;
import gui.MyJPanel;
import gui.OkDialog;
import gui.OkDialogLarge;
import gui.OptionsDialog2;
import gui.PPPanel;
import gui.ProductionPanel;
import gui.ProductionPanel2;
import gui.PurchasePanel2;
import gui.ResearchPanel2;
import gui.StatisticsPanel;
import gui.TheScreen;
import gui.TimeLeftPanel;
import gui.UnitPanel2;
import gui.WarWindow_this_componentAdapter;
import gui.WarWindow_this_focusAdapter;
import gui.WarWindow_this_keyAdapter;
import gui.WarWindow_this_mouseAdapter;
import gui.WarWindow_this_mouseMotionAdapter;
import gui.WarWindow_this_mouseWheelAdapter;
import gui.YesNoDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Vector;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarWindow
extends MyJPanel {
    private static final long serialVersionUID = 64L;
    int mode = -1;
    TheScreen theScreen;
    Game game;
    MapCanvas mapCanvas;
    PurchasePanel2 purchasePanel2;
    ForcePoolDeploy forcePoolPanel;
    ResearchPanel2 researchPanel;
    StatisticsPanel statisticsPanel;
    ChatDialog chatDialog;
    OptionsDialog2 optionsDialog;
    YesNoDialog yesNoDialog;
    OkDialog okDialog;
    OkDialogLarge okDialogLarge;
    InfoDialog infoDialog;
    BeginTurnDialog beginTurnDialog;
    boolean showingDialog = false;
    int msgInChatArea = 0;
    HexInfoPanel hexInfoPanel;
    UnitPanel2 leftUnitPanel;
    UnitPanel2 rightUnitPanel;
    ButtonPanel2 buttonPanel2;
    CombatPanel combatPanel;
    ProductionPanel productionPanel;
    ProductionPanel2 productionPanel2;
    PPPanel pPanel;
    TimeLeftPanel timeLeftPanel;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel6 = new MyJPanel();
    JPanel jPanel8 = new MyJPanel();
    JPanel jPanel80 = new MyJPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JPanel southAndWestPanel = new MyJPanel();
    BorderLayout borderLayout14 = new BorderLayout();
    JPanel northPanel = new MyJPanel();
    JPanel southPanel = new MyJPanel();
    JPanel centerPanel = new MyJPanel();
    JPanel southAndEastPanel = new MyJPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout15 = new BorderLayout();
    JPanel mapPanel = new MyJPanel();
    JPanel jPanel3 = new MyJPanel();
    GridLayout gridLayout1 = new GridLayout();
    BorderLayout borderLayout17 = new BorderLayout();
    BorderLayout borderLayout18 = new BorderLayout();
    BorderLayout borderLayout19 = new BorderLayout();
    MiniMap minimapPanel;
    BorderLayout borderLayout11 = new BorderLayout();
    Cursor deployCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "cursor_deploy.png"), new Point(0, 0), "circle");
    Cursor repairCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "cursor_repair.png"), new Point(0, 0), "circle");
    Cursor upgradeCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "cursor_upgrade.png"), new Point(0, 0), "circle");
    Cursor busyCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "cursor_busy.png"), new Point(0, 0), "circle");
    Cursor regularCursor = Cursor.getDefaultCursor();
    JPanel southAndCenterPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    BackgroundPanel jPanel100;
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JPanel jPanel222 = new JPanel();
    JPanel jPanel223 = new JPanel();
    JPanel jPanel224 = new JPanel();
    JPanel jPanel225 = new JPanel();

    public WarWindow(TheScreen theScr, Game theGame) {
        this.hexInfoPanel = new HexInfoPanel(theGame, Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "unit_axis" + ".png"), false);
        this.leftUnitPanel = new UnitPanel2(theGame, Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "unit_axis" + ".png"), false);
        this.rightUnitPanel = new UnitPanel2(theGame, Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "unit_axis" + ".png"), true);
        this.setIgnoreRepaint(true);
        this.theScreen = theScr;
        this.game = theGame;
        this.game.setWarWindow(this);
        this.jPanel100 = new BackgroundPanel(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "panel_top_axis" + ".png"));
        this.buttonPanel2 = new ButtonPanel2(theGame, Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "button_panel_axis.png"));
        this.pPanel = new PPPanel(theGame);
        this.timeLeftPanel = new TimeLeftPanel(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "timer_bg" + ".png"));
        this.statisticsPanel = new StatisticsPanel(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "fe_background.png"), this.game);
        this.forcePoolPanel = new ForcePoolDeploy(theGame, Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "forcepool_axis" + ".png"));
        this.researchPanel = new ResearchPanel2(theGame);
        this.chatDialog = new ChatDialog(this.theScreen, this);
        this.optionsDialog = new OptionsDialog2(this.theScreen, this.game);
        this.yesNoDialog = new YesNoDialog(this.theScreen, this.game);
        this.okDialog = new OkDialog(this.theScreen, this.game);
        this.okDialogLarge = new OkDialogLarge((Frame)this.theScreen, this.game);
        this.infoDialog = new InfoDialog(this.theScreen, this.game);
        this.beginTurnDialog = new BeginTurnDialog((Frame)this.theScreen, this.game);
        this.minimapPanel = new MiniMap(this);
        this.mapCanvas = new MapCanvas(this.game);
        this.purchasePanel2 = new PurchasePanel2(theGame);
        this.combatPanel = new CombatPanel(theGame, Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "combat_axis" + ".png"));
        this.productionPanel = new ProductionPanel(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "production_axis" + ".png"));
        this.productionPanel2 = new ProductionPanel2(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "production2" + ".png"));
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setMaximumSize(new Dimension(1024, 768));
        this.setMinimumSize(new Dimension(1024, 768));
        this.setPreferredSize(new Dimension(1024, 768));
        this.addMouseWheelListener(new WarWindow_this_mouseWheelAdapter(this));
        this.addFocusListener(new WarWindow_this_focusAdapter(this));
        this.addComponentListener(new WarWindow_this_componentAdapter(this));
        this.addMouseMotionListener(new WarWindow_this_mouseMotionAdapter(this));
        this.addMouseListener(new WarWindow_this_mouseAdapter(this));
        this.addKeyListener(new WarWindow_this_keyAdapter(this));
        this.jPanel6.setDebugGraphicsOptions(0);
        this.jPanel6.setMinimumSize(new Dimension(280, 105));
        this.jPanel6.setPreferredSize(new Dimension(280, 10));
        this.jPanel6.setLayout(this.gridBagLayout1);
        this.jPanel8.setMinimumSize(new Dimension(280, 77));
        this.jPanel8.setPreferredSize(new Dimension(280, 10));
        this.jPanel8.setLayout(this.gridBagLayout3);
        this.mapCanvas.setMinimumSize(new Dimension(5175, 2880));
        this.southAndWestPanel.setLayout(this.borderLayout14);
        this.southAndWestPanel.setPreferredSize(new Dimension(520, 120));
        this.northPanel.setOpaque(false);
        this.northPanel.setPreferredSize(new Dimension(10, 36));
        this.northPanel.setLayout(this.borderLayout17);
        this.southPanel.setMaximumSize(new Dimension(1024, Integer.MAX_VALUE));
        this.southPanel.setMinimumSize(new Dimension(342, 128));
        this.southPanel.setOpaque(false);
        this.southPanel.setPreferredSize(new Dimension(1024, 176));
        this.southPanel.setLayout(this.borderLayout18);
        this.southAndEastPanel.setLayout(this.borderLayout4);
        this.mapPanel.setBackground(Color.pink);
        this.mapPanel.setLayout(this.gridLayout1);
        this.jPanel3.setBackground(Color.black);
        this.jPanel3.setPreferredSize(new Dimension(861, 10));
        this.jPanel3.setRequestFocusEnabled(false);
        this.jPanel3.setLayout(this.borderLayout15);
        this.centerPanel.setLayout(this.borderLayout19);
        this.southAndEastPanel.setMinimumSize(new Dimension(370, 109));
        this.southAndEastPanel.setOpaque(false);
        this.southAndEastPanel.setPreferredSize(new Dimension(250, 22));
        this.minimapPanel.setMinimumSize(new Dimension(209, 10));
        this.minimapPanel.setPreferredSize(new Dimension(209, 10));
        this.centerPanel.setMaximumSize(new Dimension(1024, Integer.MAX_VALUE));
        this.centerPanel.setOpaque(true);
        this.jPanel80.setLayout(this.borderLayout11);
        this.jPanel80.setOpaque(false);
        this.jPanel100.setLayout(this.borderLayout3);
        this.jPanel100.setOpaque(false);
        this.jPanel100.setPreferredSize(new Dimension(10, 36));
        this.jPanel5.setOpaque(false);
        this.jPanel5.setPreferredSize(new Dimension(12, 10));
        this.jPanel7.setOpaque(false);
        this.jPanel7.setPreferredSize(new Dimension(8, 10));
        this.jPanel1.setOpaque(false);
        this.jPanel222.setOpaque(false);
        this.jPanel222.setPreferredSize(new Dimension(10, 18));
        this.jPanel223.setOpaque(false);
        this.jPanel223.setPreferredSize(new Dimension(10, 18));
        this.jPanel224.setOpaque(false);
        this.jPanel224.setPreferredSize(new Dimension(18, 10));
        this.jPanel225.setOpaque(false);
        this.jPanel225.setPreferredSize(new Dimension(18, 10));
        this.jPanel100.setMaximumSize(new Dimension(1024, Integer.MAX_VALUE));
        this.add((Component)this.jPanel100, "North");
        this.add((Component)this.southPanel, "South");
        this.add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.mapCanvas, "Center");
        this.northPanel.add((Component)this.productionPanel2, "West");
        this.northPanel.add((Component)this.timeLeftPanel, "East");
        this.northPanel.add((Component)this.jPanel1, "Center");
        this.jPanel100.add((Component)this.jPanel5, "West");
        this.jPanel100.add((Component)this.jPanel7, "East");
        this.jPanel100.add((Component)this.northPanel, "Center");
        this.showBelowPanels(0, null, null, null, false);
        this.setCursor(99);
    }

    public void selectTab(int tab) {
        this.buttonPanel2.selectTab(tab);
    }

    public UnitPanel2 getLeftUnitPanel() {
        return this.leftUnitPanel;
    }

    public void selectButton(int button) {
        this.buttonPanel2.selectButton(button);
    }

    public void setCursor(int index) {
        if (index == 2) {
            this.setCursor(this.deployCursor);
        } else if (index == 7) {
            this.setCursor(this.repairCursor);
        } else if (index == 8) {
            this.setCursor(this.upgradeCursor);
        } else if (index == 10) {
            this.setCursor(this.busyCursor);
        } else {
            this.setCursor(this.regularCursor);
        }
    }

    public void repaintDialogs() {
        if (this.optionsDialog == null) {
            return;
        }
        this.optionsDialog.requestRepaint();
        this.okDialogLarge.repaint();
        this.beginTurnDialog.repaint();
        this.yesNoDialog.repaint();
        this.okDialog.repaint();
        this.infoDialog.repaint();
    }

    public boolean isShowingDialog() {
        return this.showingDialog;
    }

    public PurchasePanel2 getpurchasePanel() {
        return this.purchasePanel2;
    }

    public ResearchPanel2 getResearchPanel() {
        return this.researchPanel;
    }

    public HexInfoPanel getHexInfoPanel() {
        return this.hexInfoPanel;
    }

    public StatisticsPanel getStatisticsPanel() {
        return this.statisticsPanel;
    }

    public void showYesNoDialog(String text) {
        this.showingDialog = true;
        this.yesNoDialog.show(text);
        this.showingDialog = false;
    }

    public void showOkDialog(String text) {
        this.showingDialog = true;
        this.okDialog.showDialog(text);
        this.showingDialog = false;
    }

    public void showOkDialogLarge(String title, String text) {
        this.showingDialog = true;
        this.okDialogLarge.showDialog(title, text);
        this.showingDialog = false;
    }

    public void showChatDialog() {
        this.showingDialog = true;
        this.chatDialog.showDialog(Global.getMessage(802));
        this.showingDialog = false;
        this.createChatMessage(this.chatDialog.getText(), true);
        this.game.setChatDialogRequested(false);
        this.game.setBusy(false);
    }

    public void showOptionsDialog() {
        this.showingDialog = true;
        this.optionsDialog.showDialog();
        this.showingDialog = false;
    }

    public void showInfoDialog(String text) {
        if (this.isShowing()) {
            this.showingDialog = true;
            this.infoDialog.showDialog(text);
            this.showingDialog = false;
        }
    }

    public void closeInfoDialog() {
        this.infoDialog.setVisible(false);
        this.showingDialog = false;
    }

    public CombatPanel getCombatPanel() {
        return this.combatPanel;
    }

    public Vector<TechAdvance> getTechAdvancesVector() {
        return this.beginTurnDialog.getTechAdvancesVector();
    }

    public void reset() {
        this.northPanel.removeAll();
        this.northPanel.add((Component)this.productionPanel2, "West");
        if (!this.game.getTimeSystem().getNoTimeLimit()) {
            this.northPanel.add((Component)this.timeLeftPanel, "East");
        }
        this.northPanel.add((Component)this.jPanel1, "Center");
        this.buttonPanel2.reset();
        this.statisticsPanel.reset();
        this.showWarMap();
        this.beginTurnDialog.reset();
        this.mapCanvas.reset();
    }

    public void quitToMainMenu() {
        this.game.reset();
        this.theScreen.showPanel(this.theScreen.mainMenu);
    }

    public void showBeginTurnDialog() {
        if (this.getGame().getGameMode() == 3000) {
            this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        }
        this.beginTurnDialog.updateLabels(this.game.whosTurn());
        this.game.setBusy(true);
        this.showingDialog = true;
        this.beginTurnDialog.setVisible(true);
        this.showingDialog = false;
        Game.delay(200L);
    }

    public void closeEndTurnDialog() {
        this.beginTurnDialog.setVisible(false);
    }

    public OptionsDialog2 getOptionsDialog() {
        return this.optionsDialog;
    }

    public void showPP(boolean updatebg) {
        this.productionPanel.updateAll(this.game, updatebg);
        this.productionPanel2.updateValues();
    }

    public ProductionPanel2 getProductionPanel2() {
        return this.productionPanel2;
    }

    public void updateProductionPanel2(Country c) {
        Country[] countries = this.game.getCountries();
        if (c.getCountryIndex() == 5) {
            this.productionPanel2.updateFactions(countries[5], null, null);
        } else if (c.getSide() == 200) {
            this.productionPanel2.updateFactions(countries[2], countries[3], countries[4]);
        } else if (c.getSide() == 100) {
            this.productionPanel2.updateFactions(countries[0], countries[1], null);
        }
    }

    public void endTurn() {
        Country second;
        Country first;
        if (this.game.getGameMode() != 4000) {
            this.showPP(false);
        }
        this.forcePoolPanel.updateAll(true);
        this.researchPanel.updateAll(true);
        this.purchasePanel2.updateAll(true);
        this.showWarMap();
        this.southAndWestPanel.removeAll();
        this.showBelowPanels(0, null, null, null, false);
        this.southAndWestPanel.updateUI();
        this.mapCanvas.updateUI();
        this.disableButtons();
        this.showWhosTurn(this.game.whosTurn());
        this.showDate(this.game.getCalendar().get(2), this.game.getCalendar().get(5), this.game.getCalendar().get(1));
        Country third = null;
        if (this.game.whosTurn() == 100) {
            first = this.game.getCountry(0);
            second = this.game.getCountry(1);
        } else {
            first = this.game.getCountry(2);
            second = this.game.getCountry(3);
            third = this.game.getCountry(4);
        }
        this.productionPanel2.updateFactions(first, second, third);
        if (this.game.playerSide() != this.game.whosTurn()) {
            this.setCursor(10);
        } else {
            this.setCursor(-1);
        }
    }

    public void showTimeLeft(String axisTimeLeft, String alliesTimeLeft) {
        if (this.hasFocus()) {
            if (this.game.whosTurn() == 100) {
                this.timeLeftPanel.showTime(axisTimeLeft);
            } else {
                this.timeLeftPanel.showTime(alliesTimeLeft);
            }
        }
    }

    public void oneImmediateFrame() {
        this.mapCanvas.paintImmediately(0, 0, this.mapCanvas.getWidth(), this.mapCanvas.getHeight());
    }

    public void oneSlowFrame() {
        this.mapCanvas.repaint();
    }

    public void showBelowPanels(int newMode, Unit left, Unit right, Hex hex, boolean switchTab) {
        if (hex != null) {
            this.hexInfoPanel.showHex(hex);
        }
        if (left != null) {
            this.leftUnitPanel.showUnit(left, true);
        }
        if (right != null) {
            this.rightUnitPanel.showUnit(right, false);
        }
        if (newMode != this.mode || switchTab) {
            this.southPanel.removeAll();
            BackgroundPanel west = this.leftUnitPanel;
            BackgroundPanel east = this.buttonPanel2;
            MyJPanel center = this.rightUnitPanel;
            switch (newMode) {
                case 0: {
                    west = this.productionPanel;
                    this.showPP(false);
                    east = this.buttonPanel2;
                    center = this.minimapPanel;
                    break;
                }
                case 1: {
                    west = hex != null ? this.hexInfoPanel : this.leftUnitPanel;
                    east = this.buttonPanel2;
                    center = this.minimapPanel;
                    break;
                }
                case 2: {
                    west = this.leftUnitPanel;
                    east = hex != null ? this.hexInfoPanel : this.rightUnitPanel;
                    center = this.combatPanel;
                    this.game.setTutorialMessage(15);
                    break;
                }
                case 3: {
                    west = this.forcePoolPanel;
                    east = this.buttonPanel2;
                    center = this.minimapPanel;
                }
            }
            this.southPanel.add((Component)west, "West");
            this.southPanel.add((Component)east, "East");
            this.southPanel.add((Component)center, "Center");
            this.leftUnitPanel.updateUI();
            this.rightUnitPanel.updateUI();
            this.hexInfoPanel.updateUI();
            this.buttonPanel2.updateUI();
            this.combatPanel.updateUI();
            this.productionPanel.updateUI();
            this.mapCanvas.updateUI();
            this.minimapPanel.updateUI();
            this.mode = newMode;
        }
    }

    public void ssshowUnitToLeft(Unit u) {
        this.leftUnitPanel.showUnit(u, true);
        this.southAndWestPanel.removeAll();
        this.southAndWestPanel.add((Component)this.leftUnitPanel, "West");
        this.southAndWestPanel.updateUI();
        this.mapCanvas.updateUI();
    }

    public Unit getLeftUnit() {
        return this.leftUnitPanel.currentUnit;
    }

    public void clearLeft() {
        this.leftUnitPanel.reset();
    }

    public void clearRight() {
        this.rightUnitPanel.reset();
    }

    public void showWhosTurn(int side) {
    }

    public void disableButtons() {
        this.buttonPanel2.reset();
        this.buttonPanel2.updateAll(false, false);
        this.minimapPanel.updateAll(false, false);
    }

    public void updateAll(boolean updatebg) {
        boolean playersTurn = false;
        if (this.game.whosTurn() == this.game.playerSide()) {
            playersTurn = true;
        }
        if (this.game.getGameState().getGameOver()) {
            playersTurn = false;
        }
        if (this.game.whosTurn() == 100) {
            this.jPanel100.setbgImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "panel_top_axis.png"));
        } else {
            this.jPanel100.setbgImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "panel_top_allies.png"));
        }
        this.jPanel100.updateUI();
        this.leftUnitPanel.updateAll(true, updatebg);
        this.rightUnitPanel.updateAll(false, updatebg);
        this.showPP(updatebg);
        this.buttonPanel2.reset();
        this.buttonPanel2.updateAll(playersTurn, updatebg);
        this.minimapPanel.updateAll(playersTurn, updatebg);
        this.updateUI();
    }

    public void showDate(int month, int day, int year) {
    }

    public void ssshowUnitToRight(Unit u) {
        this.rightUnitPanel.showUnit(u, false);
        this.southAndWestPanel.removeAll();
        this.southAndWestPanel.add((Component)this.leftUnitPanel, "West");
        this.southAndWestPanel.add((Component)this.rightUnitPanel, "Center");
        this.southAndWestPanel.updateUI();
        this.mapCanvas.updateUI();
    }

    public void cccloseInfoPanel() {
        this.southAndWestPanel.removeAll();
        this.southAndWestPanel.add((Component)this.leftUnitPanel, "West");
        this.southAndWestPanel.add((Component)this.rightUnitPanel, "Center");
        this.southAndWestPanel.updateUI();
    }

    public MiniMap getMiniMap() {
        return this.minimapPanel;
    }

    public ForcePoolDeploy getForcePoolPanel() {
        return this.forcePoolPanel;
    }

    public MapCanvas getMapCanvas() {
        return this.mapCanvas;
    }

    public Game getGame() {
        return this.game;
    }

    public void createChatMessage(String text, boolean thisPlayerWroteMessage) {
        Color c;
        if (thisPlayerWroteMessage && this.game.getGameMode() == 3000) {
            this.game.sendChatToOpponent("c " + text);
        }
        String s = "";
        if (thisPlayerWroteMessage && this.game.playerSide() == 100) {
            s = String.valueOf(s) + "AXIS: ";
            c = Color.white;
        } else if (!thisPlayerWroteMessage && this.game.playerSide() == 200) {
            s = String.valueOf(s) + "AXIS: ";
            c = Color.white;
        } else {
            s = String.valueOf(s) + "ALLIES: ";
            c = Color.red;
        }
        s = String.valueOf(s) + text;
        this.game.getChatMessages().insertMessage(new ColorString(c, s));
        this.oneSlowFrame();
        if (this.game.getSoundEffect()) {
            this.game.playAudioFileAndWait(String.valueOf(Global.getSoundPath()) + "chat_message.wav");
        }
    }

    public YesNoDialog getYesNoDialog() {
        return this.yesNoDialog;
    }

    void jButton1_actionPerformed(ActionEvent e) {
    }

    void jButton6_actionPerformed(ActionEvent e) {
    }

    public ChatDialog getChatDialog() {
        return this.chatDialog;
    }

    void this_mouseMoved(MouseEvent e) {
        if (e.getX() < 10) {
            this.game.setMouseScroll(1);
        } else if (e.getY() < 10) {
            this.game.setMouseScroll(2);
        } else if (e.getX() > 1013) {
            this.game.setMouseScroll(3);
        } else if (e.getY() > 757) {
            this.game.setMouseScroll(4);
        } else {
            this.game.setMouseScroll(0);
        }
    }

    void jToggleButton_actionPerformed(ActionEvent e) {
    }

    void this_keyPressed(KeyEvent e) {
        char c = e.getKeyChar();
        switch (c) {
            case '+': {
                this.game.changeZoom(true, false, false);
                break;
            }
            case '-': {
                this.game.changeZoom(false, false, false);
                break;
            }
            case 's': {
                this.game.sentryUnit();
            }
        }
        int id = e.getKeyCode();
        switch (id) {
            case 39: {
                this.game.setRightPressed(true);
                this.game.setScrollingRight(1);
                this.game.setScrollingUp(0);
                break;
            }
            case 37: {
                this.game.setLeftPressed(true);
                this.game.setScrollingRight(-1);
                this.game.setScrollingUp(0);
                break;
            }
            case 38: {
                this.game.setUpPressed(true);
                this.game.setScrollingUp(1);
                this.game.setScrollingRight(0);
                break;
            }
            case 40: {
                this.game.setDownPressed(true);
                this.game.setScrollingUp(-1);
                this.game.setScrollingRight(0);
                break;
            }
            case 33: {
                this.game.nextReadyUnit(true);
                break;
            }
            case 34: {
                this.game.nextReadyUnit(false);
                break;
            }
            case 10: {
                if (this.game.getGameMode() != 3000) break;
                this.game.setChatDialogRequested(true);
            }
        }
    }

    void jScrollPane_mouseReleased(MouseEvent e) {
        this.mapCanvas.setPaintFullCanvas(true);
        this.mapCanvas.repaint();
    }

    void this_keyReleased(KeyEvent e) {
        int id = e.getKeyCode();
        switch (id) {
            case 39: {
                this.game.setRightPressed(false);
                if (this.game.getLeftPressed()) {
                    this.game.setScrollingRight(-1);
                    break;
                }
                this.game.setScrollingRight(0);
                if (this.game.getUpPressed()) {
                    this.game.setScrollingUp(1);
                    break;
                }
                if (!this.game.getDownPressed()) break;
                this.game.setScrollingUp(-1);
                break;
            }
            case 37: {
                this.game.setLeftPressed(false);
                if (this.game.getRightPressed()) {
                    this.game.setScrollingRight(1);
                    break;
                }
                this.game.setScrollingRight(0);
                if (this.game.getUpPressed()) {
                    this.game.setScrollingUp(1);
                    break;
                }
                if (!this.game.getDownPressed()) break;
                this.game.setScrollingUp(-1);
                break;
            }
            case 38: {
                this.game.setUpPressed(false);
                if (this.game.getDownPressed()) {
                    this.game.setScrollingUp(-1);
                    break;
                }
                this.game.setScrollingUp(0);
                if (this.game.getRightPressed()) {
                    this.game.setScrollingRight(1);
                    break;
                }
                if (!this.game.getLeftPressed()) break;
                this.game.setScrollingRight(-1);
                break;
            }
            case 40: {
                this.game.setDownPressed(false);
                if (this.game.getUpPressed()) {
                    this.game.setScrollingUp(1);
                    break;
                }
                this.game.setScrollingUp(0);
                if (this.game.getRightPressed()) {
                    this.game.setScrollingRight(1);
                    break;
                }
                if (!this.game.getLeftPressed()) break;
                this.game.setScrollingRight(-1);
            }
        }
    }

    public boolean showingWarMap() {
        boolean ret = true;
        if (this.game.getNowShowing() != 0) {
            ret = false;
        } else if (this.chatDialog.isActive()) {
            ret = false;
        } else if (this.optionsDialog.isActive()) {
            ret = false;
        }
        return ret;
    }

    public void showForcePoolPanel() {
        this.game.resetMapDependancy();
        this.showBelowPanels(3, null, null, null, false);
        this.forcePoolPanel.updateAll(true);
        this.game.setNowShowing(2);
        if (!this.forcePoolPanel.forcePoolEmpty()) {
            this.game.highlightDeployHexes(this.forcePoolPanel.getSelectedCountry(), this.forcePoolPanel.getDeployUnit());
        }
        this.game.centerOnCapital(this.forcePoolPanel.getDeployUnit().getCountry());
    }

    public void showUnitPanels() {
        this.clearLeft();
        this.clearRight();
        this.southAndWestPanel.removeAll();
        this.southAndWestPanel.add((Component)this.leftUnitPanel, "West");
        this.southAndWestPanel.add((Component)this.rightUnitPanel, "Center");
        this.southAndWestPanel.updateUI();
        this.mapCanvas.updateUI();
    }

    public void showPurchasePanel() {
        this.purchasePanel2.setSelectedCountryIndex(this.researchPanel.getSelectedCountryIndex());
        this.showBelowPanels(0, null, null, null, false);
        this.mapCanvas.removeAll();
        this.mapCanvas.add((Component)this.jPanel222, "North");
        this.mapCanvas.add((Component)this.jPanel223, "South");
        this.mapCanvas.add((Component)this.jPanel224, "West");
        this.mapCanvas.add((Component)this.jPanel225, "East");
        this.mapCanvas.add((Component)this.purchasePanel2, "Center");
        this.purchasePanel2.updateAll(false);
        this.southAndWestPanel.removeAll();
        this.southAndWestPanel.updateUI();
        this.mapCanvas.updateUI();
    }

    public void showResearchPanel() {
        this.researchPanel.setSelectedCountryIndex(this.purchasePanel2.getSelectedCountryIndex());
        this.showBelowPanels(0, null, null, null, true);
        this.researchPanel.selectTab(0);
        this.researchPanel.updateAll(false);
        this.mapCanvas.removeAll();
        this.mapCanvas.add((Component)this.jPanel222, "North");
        this.mapCanvas.add((Component)this.jPanel223, "South");
        this.mapCanvas.add((Component)this.jPanel224, "West");
        this.mapCanvas.add((Component)this.jPanel225, "East");
        this.mapCanvas.add((Component)this.researchPanel, "Center");
        this.southAndWestPanel.removeAll();
        this.southAndWestPanel.updateUI();
        this.mapCanvas.updateUI();
    }

    public void showStatisticsPanel(boolean endGame, int tab) {
        this.statisticsPanel.updateAll(endGame, tab);
        this.theScreen.showPanel(this.statisticsPanel);
    }

    public void showReportPanel2() {
        this.showBelowPanels(0, null, null, null, false);
        this.mapCanvas.removeAll();
        this.mapCanvas.add((Component)this.jPanel222, "North");
        this.mapCanvas.add((Component)this.jPanel223, "South");
        this.mapCanvas.add((Component)this.jPanel224, "West");
        this.mapCanvas.add((Component)this.jPanel225, "East");
        this.southAndWestPanel.removeAll();
        this.southAndWestPanel.updateUI();
        this.mapCanvas.updateUI();
    }

    public int getZoom() {
        return this.game.getZoom();
    }

    public void closeForcePool() {
        this.game.resetMapDependancy();
        this.showBelowPanels(0, null, null, null, false);
        this.game.setNowShowing(0);
        this.buttonPanel2.selectButton(99);
        this.setCursor(99);
        this.oneSlowFrame();
    }

    public ButtonPanel2 getButtonPanel2() {
        return this.buttonPanel2;
    }

    public void closePurchasePanel() {
        this.showBelowPanels(0, null, null, null, false);
        this.game.setNowShowing(0);
        this.showWarMap();
    }

    public void closeResearchPanel() {
        this.showBelowPanels(0, null, null, null, false);
        this.game.setNowShowing(0);
        this.showWarMap();
    }

    public void closeReportPanel() {
        this.showBelowPanels(0, null, null, null, false);
        this.game.setNowShowing(0);
        this.showWarMap();
    }

    public void showWarMap() {
        this.mapCanvas.removeAll();
        this.requestFocus();
        this.game.resetMapDependancy();
        this.game.setBusy(false);
    }

    void this_mousePressed(MouseEvent e) {
        if (this.game.allowInput()) {
            int miniMapX = e.getX() - 465;
            int miniMapY = e.getY() - 621;
            if (miniMapX >= 0 && miniMapY >= 0 && miniMapX < this.minimapPanel.getWidth() && miniMapY < this.minimapPanel.getHeight()) {
                int xpos = (int)(8.52 * (double)this.getZoom() * (double)(miniMapX - 62 / this.getZoom()));
                int ypos = (int)(8.52 * (double)this.getZoom() * (double)(miniMapY - 34 / this.getZoom()));
                this.mapCanvas.setMapViewPosition(xpos, ypos, false);
            }
        }
    }

    void this_mouseDragged(MouseEvent e) {
        if (this.game.allowInput()) {
            int miniMapX = e.getX() - 465;
            int miniMapY = e.getY() - 621;
            if (miniMapX >= 0 && miniMapY >= 0 && miniMapX < this.minimapPanel.getWidth() && miniMapY < this.minimapPanel.getHeight()) {
                int xpos = (int)(8.52 * (double)this.getZoom() * (double)(miniMapX - 62 / this.getZoom()));
                int ypos = (int)(8.52 * (double)this.getZoom() * (double)(miniMapY - 34 / this.getZoom()));
                this.mapCanvas.setMapViewPosition(xpos, ypos, false);
            }
        }
    }

    void this_focusLost(FocusEvent e) {
    }

    void this_focusGained(FocusEvent e) {
    }

    void this_mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() > 0) {
            this.game.changeZoom(false, false, false);
        } else {
            this.game.changeZoom(true, false, false);
        }
    }

    void this_mouseExited(MouseEvent e) {
        this.game.resetScrolling();
    }

    void this_componentResized(ComponentEvent e) {
    }
}

