/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class TileImage
implements Serializable {
    private static final long serialVersionUID = 54L;
    transient Image srcImage = null;
    String basePath;
    String imageName;
    int tileWide = 256;
    int tileHigh = 256;
    int numTilesWide = 0;
    int numTilesHigh = 0;

    public static TileImage load(String inPath) {
        TileImage img = new TileImage(inPath);
        try {
            String dataPath = String.valueOf(img.basePath) + img.imageName + ".dat";
            System.out.println("trying image data " + dataPath);
            FileInputStream f_in = new FileInputStream(dataPath);
            ObjectInputStream obj_in = new ObjectInputStream(f_in);
            TileImage newImg = (TileImage)obj_in.readObject();
            System.out.println("able to load image");
            System.out.println("Tile size: (" + newImg.tileWide + ", " + newImg.tileHigh + ")");
            System.out.println("Tile count: (" + newImg.numTilesWide + ", " + newImg.numTilesHigh + ")");
            newImg.basePath = img.basePath;
            img = newImg;
        }
        catch (Exception e) {
            img.srcImage = Toolkit.getDefaultToolkit().getImage(inPath);
        }
        return img;
    }

    protected TileImage(String inPath) {
        int pos = inPath.lastIndexOf(47);
        if (pos >= 0) {
            this.imageName = new String(inPath.substring(pos + 1));
            this.basePath = new String(inPath.substring(0, pos + 1));
        } else {
            this.basePath = "";
            this.imageName = inPath;
        }
        pos = this.imageName.lastIndexOf(46);
        if (pos >= 0) {
            this.imageName = new String(this.imageName.substring(0, pos));
        }
        System.out.println("image " + this.imageName + "<>" + this.basePath);
    }

    public void drawAt(int x, int y, Graphics g, Component c) {
        if (this.numTilesWide == 0) {
            this.prepareForRender(g);
        }
        if (this.srcImage != null) {
            g.drawImage(this.srcImage, x, y, null);
            return;
        }
        int yTile = 0;
        while (yTile < this.numTilesHigh) {
            int xTile = 0;
            while (xTile < this.numTilesWide) {
                if (g.hitClip(x + xTile * this.tileWide, y + yTile * this.tileHigh, this.tileWide, this.tileHigh)) {
                    Image image = Toolkit.getDefaultToolkit().getImage(this.fName(xTile, yTile));
                    MediaTracker tracker = new MediaTracker(c);
                    try {
                        tracker.addImage(image, 0);
                        tracker.waitForAll();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    g.drawImage(image, x + xTile * this.tileWide, y + yTile * this.tileHigh, null);
                }
                ++xTile;
            }
            ++yTile;
        }
    }

    public void prepareForRender(Graphics g) {
        if (this.srcImage == null) {
            return;
        }
        if (g == null) {
            System.out.println("null graphics passed to prepareForRender");
            return;
        }
        if (this.numTilesWide != 0) {
            return;
        }
        try {
            this.numTilesWide = this.srcImage.getWidth(null);
            if (this.numTilesWide < 0) {
                this.srcImage = new ImageIcon(this.srcImage).getImage();
                this.numTilesWide = this.srcImage.getWidth(null);
            }
            this.numTilesHigh = this.srcImage.getHeight(null);
            System.out.println("Image size: (" + this.numTilesWide + ", " + this.numTilesHigh + ")");
            this.numTilesWide = (this.numTilesWide + this.tileWide - 1) / this.tileWide;
            this.numTilesHigh = (this.numTilesHigh + this.tileHigh - 1) / this.tileHigh;
            System.out.println("Tile count: (" + this.numTilesWide + ", " + this.numTilesHigh + ")");
            int yTile = 0;
            while (yTile < this.numTilesHigh) {
                int xTile = 0;
                while (xTile < this.numTilesWide) {
                    BufferedImage image = ((Graphics2D)g).getDeviceConfiguration().createCompatibleImage(this.tileWide, this.tileHigh, 1);
                    Graphics2D g2d = image.createGraphics();
                    g2d.drawImage(this.srcImage, -xTile * this.tileWide, -yTile * this.tileHigh, null);
                    File outputFile = new File(this.fName(xTile, yTile));
                    ImageIO.write((RenderedImage)image, "png", outputFile);
                    ++xTile;
                }
                ++yTile;
            }
            FileOutputStream f_out = new FileOutputStream(String.valueOf(this.basePath) + this.imageName + ".dat");
            ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
            obj_out.writeObject(this);
            this.srcImage = null;
        }
        catch (Exception e) {
            this.numTilesWide = -1;
        }
    }

    protected int index(int x, int y) {
        return x + y * this.numTilesWide;
    }

    protected String fName(int x, int y) {
        return String.valueOf(this.basePath) + this.imageName + this.index(x, y) + ".png";
    }
}

