/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.Game;
import game.Global;
import game.OggPlayer;
import gui.BlackScreen;
import gui.LoadingScreen;
import gui.MainMenu;
import gui.TheScreen_this_windowAdapter;
import gui.TheScreen_this_windowStateAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class TheScreen
extends JFrame {
    private static final long serialVersionUID = 53L;
    MainMenu mainMenu;
    LoadingScreen loadingScreen;
    Dimension size = new Dimension(1024, 768);
    JDesktopPane jPanel1 = new JDesktopPane();
    JPanel currentPanel;
    JInternalFrame firstFrame = new JInternalFrame();
    JComponent jPanel2 = null;
    BorderLayout borderLayout2 = new BorderLayout();

    public TheScreen() {
        this.readImages();
        this.loadingScreen = new LoadingScreen();
        this.loadingScreen.setActive(true);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        OggPlayer op = new OggPlayer(1, false);
        op.start();
        this.setResizable(false);
        if (Global.SETTINGS_DATA.getVal("WINDOWED_MODE") == 0) {
            this.setSize(this.size);
            this.setUndecorated(true);
        } else {
            this.setSize(this.size.width, this.size.height + 20);
            this.setLocationRelativeTo(null);
        }
        this.addWindowStateListener(new TheScreen_this_windowStateAdapter(this));
        this.addWindowListener(new TheScreen_this_windowAdapter(this));
        this.jPanel1.setMinimumSize(this.size);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(this.size);
        this.firstFrame.setBorder(BorderFactory.createEmptyBorder());
        this.firstFrame.setSize(this.size);
        this.firstFrame.setVisible(true);
        this.jPanel1.add(this.firstFrame);
        this.jPanel2 = (JComponent)this.firstFrame.getContentPane();
        this.jPanel2.setLayout(this.borderLayout2);
        this.setContentPane(this.jPanel1);
        op.addSound(new File(String.valueOf(Global.getSoundPath()) + "intro_music.ogg"));
        this.showPanel(new BlackScreen());
        if (Global.SETTINGS_DATA.getVal("WINDOWED_MODE") == 0) {
            Global.setFullScreen(this, true);
        } else {
            this.setVisible(true);
        }
        this.showPanel(this.loadingScreen);
        this.mainMenu = new MainMenu(this, Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "main_menu.png"));
    }

    public LoadingScreen getLoadingScreen() {
        return this.loadingScreen;
    }

    public void add(JInternalFrame f) {
        f.setBorder(BorderFactory.createEmptyBorder());
        f.setVisible(true);
        this.jPanel1.add((Component)f, JLayeredPane.MODAL_LAYER);
    }

    public void showPanel(JPanel jf) {
        this.jPanel2.removeAll();
        this.jPanel2.add((Component)jf, "Center");
        this.jPanel2.updateUI();
        jf.requestFocus();
        this.currentPanel = jf;
    }

    public JPanel getCurrentPanel() {
        return this.currentPanel;
    }

    public void showCurrentPanel() {
        this.jPanel2.removeAll();
        this.jPanel2.add((Component)this.currentPanel, "Center");
        this.jPanel2.updateUI();
        this.currentPanel.requestFocus();
    }

    public Game getGame() {
        return this.mainMenu.getGame();
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public void readImages() {
        MediaTracker tracker = new MediaTracker(this);
        int k = Global.SETTINGS_DATA.getVal("SPLASHES_EXTRA_PAGES");
        int i = 0;
        while (i < 3 + k) {
            tracker.addImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "splash" + (i + 1) + ".png"), 0);
            ++i;
        }
        tracker.addImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "titlescreen.png"), 0);
        tracker.addImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "main_menu.png"), 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void this_windowActivated(WindowEvent e) {
    }

    void this_windowDeactivated(WindowEvent e) {
    }

    void this_windowStateChanged(WindowEvent e) {
    }
}

