/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.Country;
import game.Game;
import game.Global;
import game.hex.Hex;
import game.hex.LandHex;
import game.p_resource.Fortress;
import game.p_resource.PResource;
import game.p_resource.SeaPort;
import game.unit.Convoy;
import game.unit.Unit;
import gui.MiniMap_jToggleButton1_actionAdapter;
import gui.MiniMap_jToggleButton2_actionAdapter;
import gui.MiniMap_jToggleButton3_actionAdapter;
import gui.MiniMap_jToggleButton4_actionAdapter;
import gui.MiniMap_jToggleButton5_actionAdapter;
import gui.MiniMap_jToggleButton6_actionAdapter;
import gui.MyJPanel;
import gui.WarWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class MiniMap
extends MyJPanel {
    private static final long serialVersionUID = 26L;
    int textSize = 14;
    int largeTextSize = 14;
    Color normalColor = new Color(0, 0, 0, 153);
    Color selectedColor = new Color(0, 0, 0, 153);
    int filter = 0;
    int[] pixels;
    WarWindow warWindow;
    Image image;
    int xOffset = 6;
    int yOffset = 33;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JToggleButton jToggleButton1 = new JToggleButton();
    JToggleButton jToggleButton2 = new JToggleButton();
    JToggleButton jToggleButton3 = new JToggleButton();
    JToggleButton jToggleButton4 = new JToggleButton();
    JToggleButton jToggleButton5 = new JToggleButton();
    JToggleButton jToggleButton6 = new JToggleButton();

    public MiniMap(WarWindow ww) {
        this.warWindow = ww;
        this.image = Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "minimap_axis" + ".png");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPixels(int[] b) {
        this.pixels = b;
    }

    public void paintDot(Graphics g, Color c, int hex, int width) {
        g.setColor(c);
        Game game = this.warWindow.getGame();
        Point p = game.centreOfHex(hex);
        int xpos = (int)((double)p.x / (8.52 * (double)this.getZoom()) + (double)this.xOffset);
        int ypos = (int)((double)p.y / (8.52 * (double)this.getZoom()) + (double)this.yOffset);
        g.fillOval(xpos - width / 2, ypos - width / 2, width, width);
    }

    public void render(Graphics g) {
        super.paintComponent(g);
        Game game = this.warWindow.getGame();
        g.drawImage(this.image, 0, 0, this);
        g.setColor(new Color(255, 255, 255, 204));
        g.setFont(new Font("Dialog", 1, 14));
        GregorianCalendar c = game.getCalendar();
        String calendar = String.valueOf(game.getMonthName(c.get(2))) + " " + c.get(5) + " " + c.get(1);
        g.drawString(calendar, 140, 22);
        switch (this.filter) {
            case 0: {
                this.paintUnits(g);
                break;
            }
            case 1: {
                this.paintPResources(g);
                break;
            }
            case 2: {
                this.paintPoliticalMap(g);
            }
        }
        g.setColor(new Color(255, 255, 255, 204));
        Point p = this.warWindow.getMapCanvas().getViewPosition();
        g.drawRect((int)((double)p.x / (8.52 * (double)this.getZoom()) + (double)this.xOffset), (int)((double)p.y / (8.52 * (double)this.getZoom()) + (double)this.yOffset - 2.0), 124 / this.getZoom(), 68 / this.getZoom());
    }

    public int getZoom() {
        return this.warWindow.getZoom();
    }

    private void paintPoliticalMap(Graphics g) {
        Game game = this.warWindow.getGame();
        int k = 0;
        while (k < game.getHexes().length) {
            if (game.getHex(k) instanceof LandHex && game.getRow(k) != 0) {
                Color axis = new Color(90, 120, 130, 204);
                Color proaxis = new Color(60, 90, 110, 204);
                Color allies = new Color(180, 70, 0, 204);
                Color proallies = new Color(120, 30, 0, 204);
                Color neutral = new Color(200, 200, 100, 204);
                Country country = game.getCountry(game.getHex(k).getOwningCountry());
                int faction = game.owningFaction(k);
                Color color = country.getAtWar() ? (faction == 100 ? axis : (faction == 200 ? allies : (faction == 5 ? allies : neutral))) : (country.getSide() == 100 ? proaxis : (country.getSide() == 200 ? proallies : neutral));
                this.paintDot(g, color, k, 3);
            }
            ++k;
        }
    }

    private void paintPResources(Graphics g) {
        Game game = this.warWindow.getGame();
        int k = 0;
        while (k < game.getHexes().length) {
            PResource pr = game.getHex(k).getPResource();
            if (!(pr instanceof SeaPort) && !(pr instanceof Fortress) && pr != null) {
                Country country = game.getCountry(game.getHex(k).getOwningCountry());
                Color c = country.getWarSide() == 100 ? new Color(0, 0, 255, 204) : (country.getWarSide() == 200 ? new Color(255, 0, 0, 204) : new Color(0, 255, 0, 204));
                this.paintDot(g, c, k, 3);
            }
            ++k;
        }
    }

    private void paintUnits(Graphics g) {
        int ypos;
        int xpos;
        Point p;
        Hex onHex;
        Unit u;
        int j;
        Vector<Unit> units;
        Game game = this.warWindow.getGame();
        int i = 0;
        while (i < game.getCountries().length) {
            if (game.getCountry(i).getAtWar() && game.getCountry(i).getSide() != game.viewingSide()) {
                units = game.getCountry(i).getUnits();
                j = 0;
                while (j < game.getCountry(i).getUnits().size()) {
                    u = units.get(j);
                    onHex = u.getOnHex();
                    p = game.centreOfHex(game.getHexIndex(onHex));
                    xpos = (int)((double)p.x / (8.52 * (double)this.getZoom()) + (double)this.xOffset);
                    ypos = (int)((double)p.y / (8.52 * (double)this.getZoom()) + (double)this.yOffset);
                    if (this.warWindow.getGame().canSeeUnit(u, game.viewingSide())) {
                        if (u instanceof Convoy) {
                            g.setColor(new Color(0, 0, 0, 204));
                        } else if (u.getCountry().getSide() == 100) {
                            g.setColor(new Color(0, 0, 255, 204));
                        } else {
                            g.setColor(new Color(255, 0, 0, 204));
                        }
                        g.fillRect(xpos - 1, ypos - 1, 3, 3);
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < game.getCountries().length) {
            if (game.getCountry(i).getAtWar() && game.getCountry(i).getSide() == game.viewingSide()) {
                units = game.getCountry(i).getUnits();
                j = 0;
                while (j < game.getCountry(i).getUnits().size()) {
                    u = units.get(j);
                    onHex = u.getOnHex();
                    p = game.centreOfHex(game.getHexIndex(onHex));
                    xpos = (int)((double)p.x / (8.52 * (double)this.getZoom()) + (double)this.xOffset);
                    ypos = (int)((double)p.y / (8.52 * (double)this.getZoom()) + (double)this.yOffset);
                    if (this.warWindow.getGame().canSeeUnit(u, game.viewingSide())) {
                        if (u instanceof Convoy) {
                            g.setColor(new Color(0, 0, 0, 204));
                        } else if (u.getCountry().getSide() == 100) {
                            g.setColor(new Color(0, 0, 255, 204));
                        } else {
                            g.setColor(new Color(255, 0, 0, 204));
                        }
                        g.fillRect(xpos - 1, ypos - 1, 3, 3);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void paintComponent(Graphics g) {
        this.render(g);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(0, 33));
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.jPanel2.setOpaque(false);
        this.jPanel2.setPreferredSize(new Dimension(140, 0));
        this.jToggleButton1.setFont(new Font(Global.bigFontName1, 1, 14));
        this.jToggleButton1.setBorder(null);
        this.jToggleButton1.setPreferredSize(new Dimension(20, 21));
        this.jToggleButton1.setRequestFocusEnabled(false);
        this.jToggleButton1.setToolTipText(Global.getMessage(288));
        this.jToggleButton1.setBorderPainted(false);
        this.jToggleButton1.setContentAreaFilled(false);
        this.jToggleButton1.setHorizontalTextPosition(0);
        this.jToggleButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButton1.setSelected(true);
        this.jToggleButton1.addActionListener(new MiniMap_jToggleButton1_actionAdapter(this));
        this.jToggleButton2.setFont(new Font(Global.bigFontName1, 1, 14));
        this.jToggleButton2.setBorder(null);
        this.jToggleButton2.setPreferredSize(new Dimension(20, 21));
        this.jToggleButton2.setRequestFocusEnabled(false);
        this.jToggleButton2.setToolTipText(Global.getMessage(289));
        this.jToggleButton2.setBorderPainted(false);
        this.jToggleButton2.setContentAreaFilled(false);
        this.jToggleButton2.setHorizontalTextPosition(0);
        this.jToggleButton2.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButton2.addActionListener(new MiniMap_jToggleButton2_actionAdapter(this));
        this.jToggleButton3.setFont(new Font(Global.bigFontName1, 1, 14));
        this.jToggleButton3.setBorder(null);
        this.jToggleButton3.setPreferredSize(new Dimension(20, 21));
        this.jToggleButton3.setRequestFocusEnabled(false);
        this.jToggleButton3.setToolTipText(Global.getMessage(290));
        this.jToggleButton3.setBorderPainted(false);
        this.jToggleButton3.setContentAreaFilled(false);
        this.jToggleButton3.setHorizontalTextPosition(0);
        this.jToggleButton3.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButton3.addActionListener(new MiniMap_jToggleButton3_actionAdapter(this));
        this.jToggleButton4.setFont(new Font(Global.bigFontName1, 1, 14));
        this.jToggleButton4.setBorder(null);
        this.jToggleButton4.setPreferredSize(new Dimension(20, 21));
        this.jToggleButton4.setRequestFocusEnabled(false);
        this.jToggleButton4.setToolTipText(Global.getMessage(291));
        this.jToggleButton4.setBorderPainted(false);
        this.jToggleButton4.setContentAreaFilled(false);
        this.jToggleButton4.setHorizontalTextPosition(0);
        this.jToggleButton4.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButton4.setSelected(true);
        this.jToggleButton4.addActionListener(new MiniMap_jToggleButton4_actionAdapter(this));
        this.jToggleButton5.setFont(new Font(Global.bigFontName1, 1, 14));
        this.jToggleButton5.setBorder(null);
        this.jToggleButton5.setPreferredSize(new Dimension(20, 21));
        this.jToggleButton5.setRequestFocusEnabled(false);
        this.jToggleButton5.setToolTipText(Global.getMessage(292));
        this.jToggleButton5.setBorderPainted(false);
        this.jToggleButton5.setContentAreaFilled(false);
        this.jToggleButton5.setHorizontalTextPosition(0);
        this.jToggleButton5.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButton5.setSelected(true);
        this.jToggleButton5.addActionListener(new MiniMap_jToggleButton5_actionAdapter(this));
        this.jToggleButton6.setFont(new Font(Global.bigFontName1, 1, 14));
        this.jToggleButton6.setBorder(null);
        this.jToggleButton6.setPreferredSize(new Dimension(20, 21));
        this.jToggleButton6.setRequestFocusEnabled(false);
        this.jToggleButton6.setToolTipText(Global.getMessage(293));
        this.jToggleButton6.setBorderPainted(false);
        this.jToggleButton6.setContentAreaFilled(false);
        this.jToggleButton6.setHorizontalTextPosition(0);
        this.jToggleButton6.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButton6.addActionListener(new MiniMap_jToggleButton6_actionAdapter(this));
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jPanel2, "West");
        this.jPanel2.add((Component)this.jToggleButton1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jToggleButton2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jToggleButton3, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jToggleButton4, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jToggleButton5, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jToggleButton6, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 0), 0, 0));
        this.buttonGroup1.add(this.jToggleButton1);
        this.buttonGroup1.add(this.jToggleButton2);
        this.buttonGroup1.add(this.jToggleButton3);
        this.jToggleButton1.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_units.png")));
        this.jToggleButton1.setRolloverIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_units_hig.png")));
        this.jToggleButton1.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_units_sel.png")));
        this.jToggleButton1.setDisabledIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_units_dis.png")));
        this.jToggleButton1.setDisabledSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_units_dis.png")));
        this.jToggleButton2.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_resources.png")));
        this.jToggleButton2.setRolloverIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_resources_hig.png")));
        this.jToggleButton2.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_resources_sel.png")));
        this.jToggleButton2.setDisabledIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_resources_dis.png")));
        this.jToggleButton2.setDisabledSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_resources_dis.png")));
        this.jToggleButton3.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_political.png")));
        this.jToggleButton3.setRolloverIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_political_hig.png")));
        this.jToggleButton3.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_political_sel.png")));
        this.jToggleButton3.setDisabledIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_political_dis.png")));
        this.jToggleButton3.setDisabledSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "minimap_political_dis.png")));
        this.jToggleButton4.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_unit.png")));
        this.jToggleButton4.setRolloverIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_unit_hig.png")));
        this.jToggleButton4.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_unit_sel.png")));
        this.jToggleButton4.setDisabledIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_unit_dis.png")));
        this.jToggleButton4.setDisabledSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_unit_dis.png")));
        this.jToggleButton5.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_city.png")));
        this.jToggleButton5.setRolloverIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_city_hig.png")));
        this.jToggleButton5.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_city_sel.png")));
        this.jToggleButton5.setDisabledIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_city_dis.png")));
        this.jToggleButton5.setDisabledSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_city_dis.png")));
        this.jToggleButton6.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_zoom.png")));
        this.jToggleButton6.setRolloverIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_zoom_hig.png")));
        this.jToggleButton6.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_zoom_sel.png")));
        this.jToggleButton6.setDisabledIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_zoom_dis.png")));
        this.jToggleButton6.setDisabledSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "maximap_zoom_dis.png")));
    }

    public void updateAll(boolean buttonsEnabled, boolean updatebg) {
        if (updatebg) {
            this.image = this.warWindow.getGame().whosTurn() == 100 ? Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "minimap_axis.png") : Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "minimap_allies.png");
        }
        this.jToggleButton1.setEnabled(buttonsEnabled);
        this.jToggleButton2.setEnabled(buttonsEnabled);
        this.jToggleButton3.setEnabled(buttonsEnabled);
        this.jToggleButton4.setEnabled(buttonsEnabled);
        this.jToggleButton5.setEnabled(buttonsEnabled);
        this.jToggleButton6.setEnabled(buttonsEnabled);
    }

    void jToggleButton1_actionPerformed(ActionEvent e) {
        if (!this.warWindow.getGame().getBusy() && !this.warWindow.getMapCanvas().getAutomaticMoving()) {
            this.warWindow.getGame().playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
            this.filter = 0;
            this.repaint();
        }
    }

    void jToggleButton2_actionPerformed(ActionEvent e) {
        if (!this.warWindow.getGame().getBusy() && !this.warWindow.getMapCanvas().getAutomaticMoving()) {
            this.warWindow.getGame().playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
            this.filter = 1;
            this.repaint();
        }
    }

    void jToggleButton3_actionPerformed(ActionEvent e) {
        if (!this.warWindow.getGame().getBusy() && !this.warWindow.getMapCanvas().getAutomaticMoving()) {
            this.warWindow.getGame().playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
            this.filter = 2;
            this.repaint();
        }
    }

    void jToggleButton4_actionPerformed(ActionEvent e) {
        this.warWindow.getGame().playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        this.warWindow.getMapCanvas().setShowUnits(this.jToggleButton4.isSelected());
        this.warWindow.oneSlowFrame();
    }

    void jToggleButton5_actionPerformed(ActionEvent e) {
        this.warWindow.getGame().playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        this.warWindow.getMapCanvas().setShowHexNames(this.jToggleButton5.isSelected());
        this.warWindow.oneSlowFrame();
    }

    void jToggleButton6_actionPerformed(ActionEvent e) {
        this.warWindow.getGame().playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        this.warWindow.getGame().changeZoom(true, true, false);
        this.jToggleButton6.setSelected(false);
    }
}

