/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.ColorString;
import game.Country;
import game.Damages;
import game.Game;
import game.Global;
import game.OddsAndPenalties;
import game.Strategy;
import game.hex.Hex;
import game.hex.LandHex;
import game.hex.LoopHex;
import game.hex.LoopHex2;
import game.p_resource.Capital;
import game.p_resource.City;
import game.p_resource.Fortress;
import game.p_resource.Mine;
import game.p_resource.OilField;
import game.p_resource.PResource;
import game.p_resource.SeaPort;
import game.terrain.Clear;
import game.terrain.Desert;
import game.terrain.Forest;
import game.terrain.Mountain;
import game.terrain.Rough;
import game.terrain.Swamp;
import game.terrain.Terrain;
import game.unit.NavalUnit;
import game.unit.StrategicBomber;
import game.unit.Unit;
import gui.MapCanvas_this_mouseAdapter;
import gui.MapCanvas_this_mouseMotionAdapter;
import gui.MyJPanel;
import gui.TileImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JScrollPane;

public class MapCanvas
extends MyJPanel {
    private static final long serialVersionUID = 25L;
    long toolTipStartTime = 0L;
    long damageStopTime = Long.MAX_VALUE;
    int count;
    Image map25;
    Image map50;
    Image map100;
    Image damage;
    TileImage map25_nogrid;
    TileImage map50_nogrid;
    TileImage map100_nogrid;
    int animationState = 0;
    JScrollPane Boss;
    public boolean allowPaint = true;
    Game game;
    boolean showUnits = true;
    boolean showHexNames = true;
    boolean showHexGrid = false;
    boolean paintFullCanvas = true;
    boolean isScrolling = true;
    boolean firstPaint = true;
    boolean automaticMoving = false;
    Point viewPosition;
    Unit toolTipUnit = null;
    Damages damages = new Damages(-1, -1, -1, -1, -1, -1, -1, -1);
    BorderLayout borderLayout1 = new BorderLayout();
    boolean debug = true;
    int unitsRebuffered = 0;
    HashMap<Integer, Font> mUnitFonts = new HashMap();
    long debugInfo = 0L;
    long frames = 0L;

    public MapCanvas(Game g) {
        this.setIgnoreRepaint(true);
        this.game = g;
        this.defaultView();
        this.map25 = Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "map25.png");
        this.map50 = Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "map50.png");
        this.map100 = Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "map100.png");
        this.map25_nogrid = TileImage.load(String.valueOf(Global.getBackgroundPath()) + "map25_nogrid.png");
        this.map50_nogrid = TileImage.load(String.valueOf(Global.getBackgroundPath()) + "map50_nogrid.png");
        this.map100_nogrid = TileImage.load(String.valueOf(Global.getBackgroundPath()) + "map100_nogrid.png");
        this.damage = Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "damage.gif");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.black);
        this.setEnabled(false);
        this.setForeground(Color.black);
        this.setOpaque(false);
        this.setLayout(this.borderLayout1);
        this.addMouseMotionListener(new MapCanvas_this_mouseMotionAdapter(this));
        this.addMouseListener(new MapCanvas_this_mouseAdapter(this));
    }

    public void defaultView() {
        this.setMapViewPosition(this.game.getHex(this.game.getHex(94, 24)), false);
    }

    public void prepareForRender() {
        this.map25_nogrid.prepareForRender(this.getGraphics());
        this.map50_nogrid.prepareForRender(this.getGraphics());
        if (Global.MAX_ZOOM >= 4) {
            this.map100_nogrid.prepareForRender(this.getGraphics());
        }
    }

    public long getToolTipStartTime() {
        return this.toolTipStartTime;
    }

    public long getDamageStopTime() {
        return this.damageStopTime;
    }

    public int getZoom() {
        return this.game.getZoom();
    }

    public void setState(int newState) {
        this.animationState = newState;
    }

    public void reset() {
        this.defaultView();
        this.animationState = 0;
    }

    public void setDamages(int hexx1, int strLoss1, int morLoss1, int typ1, int hexx2, int strLoss2, int morLoss2, int typ2) {
        this.damages.set(hexx1, strLoss1, morLoss1, typ1, hexx2, strLoss2, morLoss2, typ2);
        this.damageStopTime = System.currentTimeMillis() + 1300L;
    }

    public void setAutomaticMoving(boolean b) {
        if (b) {
            this.game.adjustToolTipManager(false);
        } else {
            this.game.adjustToolTipManager(this.game.getTooltips());
        }
        this.automaticMoving = b;
    }

    public boolean getAutomaticMoving() {
        return this.automaticMoving;
    }

    public void setShowHexNames(boolean b) {
        this.showHexNames = b;
    }

    public void setShowUnits(boolean b) {
        this.showUnits = b;
    }

    public void switchHexGrid() {
        this.showHexGrid = !this.showHexGrid;
        this.game.getWarWindow().oneSlowFrame();
    }

    public Point getViewPosition() {
        return this.viewPosition;
    }

    public void setMapViewPosition(Hex h, boolean lazyUpdate) {
        int hexIndex = this.game.getHexIndex(h);
        int col = this.game.getColumn(hexIndex) - 32 / this.getZoom();
        int row = this.game.getRow(hexIndex) - 16 / this.getZoom();
        int pixelX = 1 + (20 * this.getZoom() * col + 10 * this.getZoom() * col) / 2;
        int pixelY = 1 + 16 * this.getZoom() * row;
        this.setMapViewPosition(pixelX, pixelY, lazyUpdate);
    }

    public void zoomChangeRescale(int preZoom, int postZoom) {
        Point newPoint = new Point(this.viewPosition.x / preZoom, this.viewPosition.y / preZoom);
        this.viewPosition = new Point(newPoint.x * postZoom, newPoint.y * postZoom);
        this.forceUpdateAllUnits();
    }

    public void setMapViewPosition(int xx, int yy, boolean lazyUpdate) {
        this.toolTipUnit = null;
        int x = xx;
        int y = yy;
        if (x < 1) {
            x = 1;
        } else if (x > this.horizontalMaxScroll()) {
            x = this.horizontalMaxScroll();
        }
        if (y < 1) {
            y = 1;
        } else if (y > this.verticalMaxScroll()) {
            y = this.verticalMaxScroll();
        }
        int xRest = 0;
        if (x != this.horizontalMaxScroll()) {
            xRest = (x - 1) % (20 * this.getZoom() + 10 * this.getZoom());
        }
        int yRest = 0;
        if (y != this.verticalMaxScroll()) {
            yRest = (y - 1) % (32 * this.getZoom());
        }
        Point p = new Point(x -= xRest, y -= yRest);
        if (lazyUpdate && ((double)Math.abs(this.viewPosition.x - p.x) > 409.6 || (double)Math.abs(this.viewPosition.y - p.y) > 229.60000000000002)) {
            this.viewPosition = p;
            this.repaint();
            this.game.getWarWindow().getMiniMap().repaint();
        }
        if (!(lazyUpdate || this.viewPosition != null && this.viewPosition.x == p.x && this.viewPosition.y == p.y)) {
            this.viewPosition = p;
            this.repaint();
            this.game.getWarWindow().getMiniMap().repaint();
        }
        if (this.game.whosTurn() == this.game.playerSide()) {
            this.game.setTutorialMessage(17);
        }
    }

    public int horizontalMaxScroll() {
        return 2250 * this.getZoom() - 1024;
    }

    public int verticalMaxScroll() {
        return 1160 * this.getZoom() - 556 - this.getZoom() * 16 / 2;
    }

    public void adjustViewPosition(int horChange, int vertChange) {
        int x = this.viewPosition.x + horChange;
        int y = this.viewPosition.y + vertChange;
        if (x < 1) {
            x = 1;
        } else if (x > this.horizontalMaxScroll()) {
            x = this.horizontalMaxScroll();
        }
        if (y < 1) {
            y = 1;
        } else if (y > this.verticalMaxScroll()) {
            y = this.verticalMaxScroll();
        }
        this.setMapViewPosition(x, y, false);
    }

    public void setBoss(JScrollPane bosss) {
        this.Boss = bosss;
    }

    public void setPaintFullCanvas(boolean b) {
        this.paintFullCanvas = b;
    }

    private void drawGappedLine(Graphics g, int x1, int y1, int x2, int y2, int numLines, int thickness, Color c) {
        g.setColor(c);
        int diffX = x2 - x1;
        int diffY = y2 - y1;
        int pieces = 1 + numLines * 3;
        int i = 0;
        while (i < numLines) {
            if (thickness > 1) {
                this.drawThickLine(g, x1 + (3 * i + 1) * diffX / pieces, y1 + (3 * i + 1) * diffY / pieces, x1 + (3 * i + 3) * diffX / pieces, y1 + (3 * i + 3) * diffY / pieces, thickness, c);
            } else {
                g.drawLine(x1 + (3 * i + 1) * diffX / pieces, y1 + (3 * i + 1) * diffY / pieces, x1 + (3 * i + 3) * diffX / pieces, y1 + (3 * i + 3) * diffY / pieces);
            }
            ++i;
        }
    }

    private void drawThickLine(Graphics g, int x1, int y1, int x2, int y2, int thickness, Color c) {
        g.setColor(c);
        int dX = x2 - x1;
        int dY = y2 - y1;
        double lineLength = Math.sqrt(dX * dX + dY * dY);
        double scale = (double)thickness / (2.0 * lineLength);
        double ddx = -scale * (double)dY;
        double ddy = scale * (double)dX;
        double d = ddy > 0.0 ? 0.5 : -0.5;
        int dx = (int)(ddx += ddx > 0.0 ? 0.5 : -0.5);
        int dy = (int)(ddy += d);
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        xPoints[0] = x1 + dx;
        yPoints[0] = y1 + dy;
        xPoints[1] = x1 - dx;
        yPoints[1] = y1 - dy;
        xPoints[2] = x2 - dx;
        yPoints[2] = y2 - dy;
        xPoints[3] = x2 + dx;
        yPoints[3] = y2 + dy;
        g.fillPolygon(xPoints, yPoints, 4);
    }

    private void drawNationalBorders(Graphics g, Point viewPos) {
        Color tmp = new Color(255, 235, 200, 178);
        int numLines = 2;
        boolean thickness = true;
        Rectangle rect = this.game.areaOnScreen();
        int col1 = rect.x;
        int row1 = rect.y;
        int col2 = col1 + rect.width;
        int row2 = row1 + rect.height;
        int k = col1;
        while (k < col2) {
            int t = row1;
            while (t <= row2) {
                int hexIndex = this.game.getHex(k, t);
                if (hexIndex != -1 && this.game.getHex(hexIndex) instanceof LandHex) {
                    if (((LandHex)this.game.getHex(hexIndex)).hasBorderN()) {
                        this.drawGappedLine(g, this.game.getHex((int)hexIndex).getPolygon().xpoints[0] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[0] * this.getZoom() - viewPos.y, this.game.getHex((int)hexIndex).getPolygon().xpoints[1] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[1] * this.getZoom() - viewPos.y, 2, 1, tmp);
                    }
                    if (((LandHex)this.game.getHex(hexIndex)).hasBorderNE()) {
                        this.drawGappedLine(g, this.game.getHex((int)hexIndex).getPolygon().xpoints[1] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[1] * this.getZoom() - viewPos.y, this.game.getHex((int)hexIndex).getPolygon().xpoints[2] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[2] * this.getZoom() - viewPos.y, 2, 1, tmp);
                    }
                    if (((LandHex)this.game.getHex(hexIndex)).hasBorderSE()) {
                        this.drawGappedLine(g, this.game.getHex((int)hexIndex).getPolygon().xpoints[2] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[2] * this.getZoom() - viewPos.y, this.game.getHex((int)hexIndex).getPolygon().xpoints[3] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[3] * this.getZoom() - viewPos.y, 2, 1, tmp);
                    }
                    if (((LandHex)this.game.getHex(hexIndex)).hasBorderS()) {
                        this.drawGappedLine(g, this.game.getHex((int)hexIndex).getPolygon().xpoints[3] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[3] * this.getZoom() - viewPos.y, this.game.getHex((int)hexIndex).getPolygon().xpoints[4] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[4] * this.getZoom() - viewPos.y, 2, 1, tmp);
                    }
                    if (((LandHex)this.game.getHex(hexIndex)).hasBorderSW()) {
                        this.drawGappedLine(g, this.game.getHex((int)hexIndex).getPolygon().xpoints[4] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[4] * this.getZoom() - viewPos.y, this.game.getHex((int)hexIndex).getPolygon().xpoints[5] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[5] * this.getZoom() - viewPos.y, 2, 1, tmp);
                    }
                    if (((LandHex)this.game.getHex(hexIndex)).hasBorderNW()) {
                        this.drawGappedLine(g, this.game.getHex((int)hexIndex).getPolygon().xpoints[5] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[5] * this.getZoom() - viewPos.y, this.game.getHex((int)hexIndex).getPolygon().xpoints[0] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[0] * this.getZoom() - viewPos.y, 2, 1, tmp);
                    }
                }
                ++t;
            }
            ++k;
        }
    }

    private Point centerOfHex(int hex, Point viewPos) {
        Point tmp = this.game.northwestHexEdge(hex);
        int xPos = tmp.x + (int)(5.0 * (double)this.getZoom());
        int yPos = tmp.y + (int)(8.0 * (double)this.getZoom());
        if (viewPos != null) {
            xPos -= viewPos.x;
            yPos -= viewPos.y;
        }
        return new Point(xPos, yPos);
    }

    private Point upSection(int hex, Point viewPos) {
        Point tmp = this.game.northwestHexEdge(hex);
        int xPos = tmp.x + (int)(5.0 * (double)this.getZoom());
        int yPos = tmp.y + (int)(5.6 * (double)this.getZoom());
        if (viewPos != null) {
            xPos -= viewPos.x;
            yPos -= viewPos.y;
        }
        return new Point(xPos, yPos);
    }

    private Point aboveSection(int hex, Point viewPos) {
        Point tmp = this.game.northwestHexEdge(hex);
        int xPos = tmp.x + (int)(5.0 * (double)this.getZoom());
        int yPos = tmp.y + (int)(1.6 * (double)this.getZoom());
        if (viewPos != null) {
            xPos -= viewPos.x;
            yPos -= viewPos.y;
        }
        return new Point(xPos, yPos);
    }

    private Point downSection(int hex, Point viewPos) {
        Point tmp = this.game.northwestHexEdge(hex);
        int xPos = tmp.x + (int)(5.0 * (double)this.getZoom());
        int yPos = tmp.y + (int)(15.2 * (double)this.getZoom());
        if (viewPos != null) {
            xPos -= viewPos.x;
            yPos -= viewPos.y;
        }
        return new Point(xPos, yPos);
    }

    private Point belowSection(int hex, Point viewPos) {
        Point tmp = this.game.northwestHexEdge(hex);
        int xPos = tmp.x + (int)(5.0 * (double)this.getZoom());
        int yPos = tmp.y + (int)(19.2 * (double)this.getZoom());
        if (viewPos != null) {
            xPos -= viewPos.x;
            yPos -= viewPos.y;
        }
        return new Point(xPos, yPos);
    }

    private void drawOccupyingBorders(Graphics g, Point viewPos) {
        int numLines = 2;
        int thick = 4;
        Color tmp = new Color(0, 0, 0, 178);
        Rectangle rect = this.game.areaOnScreen();
        int col1 = rect.x;
        int row1 = rect.y;
        int col2 = col1 + rect.width;
        int row2 = row1 + rect.height;
        int k = col1;
        while (k < col2) {
            int t = row1;
            while (t <= row2) {
                int hexIndex = this.game.getHex(k, t);
                if (hexIndex != -1 && this.game.getHex(hexIndex) instanceof LandHex) {
                    if (((LandHex)this.game.getHex(hexIndex)).hasOwnerBorderNE()) {
                        this.drawGappedLine(g, this.game.getHex((int)hexIndex).getPolygon().xpoints[1] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[1] * this.getZoom() - viewPos.y, this.game.getHex((int)hexIndex).getPolygon().xpoints[2] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[2] * this.getZoom() - viewPos.y, 2, 4, tmp);
                    }
                    if (((LandHex)this.game.getHex(hexIndex)).hasOwnerBorderSE()) {
                        this.drawGappedLine(g, this.game.getHex((int)hexIndex).getPolygon().xpoints[2] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[2] * this.getZoom() - viewPos.y, this.game.getHex((int)hexIndex).getPolygon().xpoints[3] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[3] * this.getZoom() - viewPos.y, 2, 4, tmp);
                    }
                    if (((LandHex)this.game.getHex(hexIndex)).hasOwnerBorderS()) {
                        this.drawGappedLine(g, this.game.getHex((int)hexIndex).getPolygon().xpoints[3] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[3] * this.getZoom() - viewPos.y, this.game.getHex((int)hexIndex).getPolygon().xpoints[4] * this.getZoom() - viewPos.x, this.game.getHex((int)hexIndex).getPolygon().ypoints[4] * this.getZoom() - viewPos.y, 2, 4, tmp);
                    }
                }
                ++t;
            }
            ++k;
        }
    }

    private void drawArrows(Graphics g, Point viewPos) {
        int wid = 9;
        int hei = 9;
        Rectangle rect = this.game.areaOnScreen();
        int col1 = rect.x;
        int row1 = rect.y;
        int col2 = col1 + rect.width;
        int row2 = row1 + rect.height;
        int k = col1;
        while (k < col2) {
            int t = row1;
            while (t <= row2) {
                int hexIndex = this.game.getHex(k, t);
                Hex h = this.game.getHex(hexIndex);
                if (hexIndex != -1 && this.game.canSeeHex(hexIndex, this.game.playerSide())) {
                    if (h.hasArrowN()) {
                        g.drawImage(h.getArrowImage(this.getZoom(), 0), (h.getPolygon().xpoints[0] * this.getZoom() + h.getPolygon().xpoints[1] * this.getZoom()) / 2 - 9 * this.getZoom() / 2 - viewPos.x, (h.getPolygon().ypoints[0] * this.getZoom() + h.getPolygon().ypoints[1] * this.getZoom()) / 2 - 9 * this.getZoom() / 2 - viewPos.y, this);
                    }
                    if (h.hasArrowNE()) {
                        g.drawImage(h.getArrowImage(this.getZoom(), 1), (h.getPolygon().xpoints[1] * this.getZoom() + h.getPolygon().xpoints[2] * this.getZoom()) / 2 - 9 * this.getZoom() / 2 - viewPos.x, (h.getPolygon().ypoints[1] * this.getZoom() + h.getPolygon().ypoints[2] * this.getZoom()) / 2 - 9 * this.getZoom() / 2 - viewPos.y, this);
                    }
                    if (h.hasArrowSE()) {
                        g.drawImage(h.getArrowImage(this.getZoom(), 2), (h.getPolygon().xpoints[2] * this.getZoom() + h.getPolygon().xpoints[3] * this.getZoom()) / 2 - 9 * this.getZoom() / 2 - viewPos.x, (h.getPolygon().ypoints[2] * this.getZoom() + h.getPolygon().ypoints[3] * this.getZoom()) / 2 - 9 * this.getZoom() / 2 - viewPos.y, this);
                    }
                    if (h.hasArrowS()) {
                        g.drawImage(h.getArrowImage(this.getZoom(), 3), (h.getPolygon().xpoints[3] * this.getZoom() + h.getPolygon().xpoints[4] * this.getZoom()) / 2 - 9 * this.getZoom() / 2 - viewPos.x, (h.getPolygon().ypoints[3] * this.getZoom() + h.getPolygon().ypoints[4] * this.getZoom()) / 2 - 9 * this.getZoom() / 2 - viewPos.y, this);
                    }
                    if (h.hasArrowSW()) {
                        g.drawImage(h.getArrowImage(this.getZoom(), 4), (h.getPolygon().xpoints[4] * this.getZoom() + h.getPolygon().xpoints[5] * this.getZoom()) / 2 - 9 * this.getZoom() / 2 - viewPos.x, (h.getPolygon().ypoints[4] * this.getZoom() + h.getPolygon().ypoints[5] * this.getZoom()) / 2 - 9 * this.getZoom() / 2 - viewPos.y, this);
                    }
                    if (h.hasArrowNW()) {
                        g.drawImage(h.getArrowImage(this.getZoom(), 5), (h.getPolygon().xpoints[5] * this.getZoom() + h.getPolygon().xpoints[0] * this.getZoom()) / 2 - 9 * this.getZoom() / 2 - viewPos.x, (h.getPolygon().ypoints[5] * this.getZoom() + h.getPolygon().ypoints[0] * this.getZoom()) / 2 - 9 * this.getZoom() / 2 - viewPos.y, this);
                    }
                }
                ++t;
            }
            ++k;
        }
    }

    private void drawHighlights(Graphics g, Point viewPos) {
        Image highlight = Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "highlight_" + 16 * this.getZoom() + ".png");
        g.setColor(Color.black);
        Rectangle rect = this.game.areaOnScreen();
        int col1 = rect.x;
        int row1 = rect.y;
        int col2 = col1 + rect.width;
        int row2 = row1 + rect.height;
        int k = col1;
        while (k < col2) {
            int t = row1;
            while (t <= row2) {
                int hexIndex = this.game.getHex(k, t);
                if (hexIndex != -1 && this.game.getHex(hexIndex).getHighlighted()) {
                    Point p = new Point(this.game.northwestQuadraticCorner(hexIndex));
                    int x = p.x - viewPos.x;
                    int y = p.y - viewPos.y;
                    g.drawImage(highlight, x, y, this);
                }
                ++t;
            }
            ++k;
        }
    }

    private void drawHexColorsAndFOW(Graphics g, Point viewPos) {
        g.setColor(Color.black);
        Rectangle rect = this.game.areaOnScreen();
        int col1 = rect.x;
        int row1 = rect.y;
        int col2 = col1 + rect.width;
        int row2 = row1 + rect.height;
        int k = col1;
        while (k < col2) {
            int t = row1;
            while (t <= row2) {
                int hexIndex = this.game.getHex(k, t);
                if (hexIndex != -1) {
                    Point p = new Point(this.game.northwestQuadraticCorner(hexIndex));
                    int x = p.x - viewPos.x;
                    int y = p.y - viewPos.y;
                    boolean political = false;
                    if (this.game.getNowShowing() == 5) {
                        political = true;
                    }
                    boolean fow = false;
                    if (!this.game.canSeeHex(hexIndex, this.game.playerSide())) {
                        fow = true;
                    }
                    if (political) {
                        fow = false;
                    }
                    if (fow || this.game.getHex(hexIndex) instanceof LandHex) {
                        g.drawImage(this.game.getHex(hexIndex).getOverlay(this.game, political, fow), x, y, this);
                    }
                }
                ++t;
            }
            ++k;
        }
    }

    private void drawMoveMarkers(Graphics g, Point viewPos) {
        int circleDiameter = 5;
        g.setColor(Color.black);
        Rectangle rect = this.game.areaOnScreen();
        int col1 = rect.x;
        int row1 = rect.y;
        int col2 = col1 + rect.width;
        int row2 = row1 + rect.height;
        int k = col1;
        while (k < col2) {
            int t = row1;
            while (t <= row2) {
                int hexIndex = this.game.getHex(k, t);
                if (hexIndex != -1 && this.game.getHex(hexIndex).getHighlighted()) {
                    g.fillOval((int)((double)this.game.northwestHexEdge((int)hexIndex).x + 5.0 * (double)this.getZoom() - 2.0 - (double)viewPos.x), (int)((double)this.game.northwestHexEdge((int)hexIndex).y + 8.0 * (double)this.getZoom() - 2.0 - (double)viewPos.y), 5, 5);
                }
                ++t;
            }
            ++k;
        }
    }

    private void drawAttackTargets(Graphics g, Point viewPos) {
        Rectangle rect = this.game.areaOnScreen();
        int col1 = rect.x;
        int row1 = rect.y;
        int col2 = col1 + rect.width;
        int row2 = row1 + rect.height;
        int k = col1;
        while (k < col2) {
            int i = row1;
            while (i <= row2) {
                Unit u;
                int hexIndex = this.game.getHex(k, i);
                if (hexIndex != -1 && ((u = this.game.getHex(hexIndex).getUnit()) != null && this.game.canSeeUnit(u, this.game.viewingSide()) || this.game.getHex(hexIndex).getPResource() != null)) {
                    int xPos = 0;
                    int yPos = 0;
                    Point p = new Point(this.game.northwestHexEdge(hexIndex));
                    xPos = (int)(p.getX() + 5.0 * (double)this.getZoom() - 0.5 * (double)(16 * this.getZoom()) - (double)viewPos.x);
                    yPos = (int)(p.getY() + 7.2 * (double)this.getZoom() - 0.45 * (double)(16 * this.getZoom()) - (double)viewPos.y);
                    if (!this.getAutomaticMoving() && this.game.getHex(hexIndex).getTargetted()) {
                        String targetType = "target_";
                        if (this.game.isStrategicBattle(this.game.getSelectedHex(), this.game.getHex(hexIndex))) {
                            targetType = String.valueOf(targetType) + "strategic_";
                        }
                        Image image = Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + targetType + 16 * this.getZoom() + ".png");
                        g.drawImage(image, xPos, yPos, this);
                    }
                }
                ++i;
            }
            ++k;
        }
    }

    private void drawTransportationLoops(Graphics g, Point viewPos) {
        g.setFont(new Font("Arial", 0, 20));
        g.setColor(Color.red);
        Rectangle rect = this.game.areaOnScreen();
        int col1 = rect.x;
        int row1 = rect.y;
        int col2 = col1 + rect.width;
        int row2 = row1 + rect.height;
        int k = col1;
        while (k < col2) {
            int t = row1;
            while (t <= row2) {
                int hexIndex = this.game.getHex(k, t);
                if (hexIndex != -1 && (this.game.getHex(hexIndex) instanceof LoopHex || this.game.getHex(hexIndex) instanceof LoopHex2)) {
                    Image img = null;
                    if (this.game.getHex(hexIndex) instanceof LoopHex) {
                        img = ((LoopHex)this.game.getHex(hexIndex)).getImage(this.getZoom());
                    } else if (this.game.getHex(hexIndex) instanceof LoopHex2) {
                        img = ((LoopHex2)this.game.getHex(hexIndex)).getImage(this.getZoom());
                    }
                    if (this.game.getHex(hexIndex) instanceof LoopHex) {
                        g.setColor(Color.red);
                    } else {
                        g.setColor(Color.black);
                    }
                    int xPos = 0;
                    int yPos = 0;
                    Point p = new Point(this.game.northwestHexEdge(hexIndex));
                    xPos = (int)(p.getX() - (double)(this.getZoom() * 10 / 2) + (double)(2 * this.getZoom()) - (double)viewPos.x);
                    yPos = (int)(p.getY() - (double)viewPos.y);
                    g.drawImage(img, xPos, yPos, this);
                }
                ++t;
            }
            ++k;
        }
    }

    private void drawMap(Graphics g, Point viewPos) {
        TileImage map = null;
        Image grid = null;
        switch (this.game.getZoom()) {
            case 1: {
                map = this.map25_nogrid;
                if (!this.game.getHexGrid()) break;
                grid = this.map25;
                break;
            }
            case 2: {
                map = this.map50_nogrid;
                if (!this.game.getHexGrid()) break;
                grid = this.map50;
                break;
            }
            case 4: {
                map = this.map100_nogrid;
                if (!this.game.getHexGrid()) break;
                grid = this.map100;
            }
        }
        map.drawAt(0 - viewPos.x, 0 - viewPos.y, g, this);
        if (grid != null) {
            g.drawImage(grid, 0 - (viewPos.x - 1) % (20 * this.getZoom() + 10 * this.getZoom()), 0 - (viewPos.y - 1) % (32 * this.getZoom()), this);
        }
    }

    private void drawPResources(Graphics g, Point viewPos) {
        Rectangle rect = this.game.areaOnScreen();
        int col1 = rect.x;
        int row1 = rect.y;
        int col2 = col1 + rect.width;
        int row2 = row1 + rect.height;
        int k = col1;
        while (k < col2) {
            int i = row1;
            while (i <= row2) {
                int hexIndex = this.game.getHex(k, i);
                Hex h = this.game.getHex(hexIndex);
                if (hexIndex != -1 && h.hasPResource()) {
                    PResource pr = this.game.getHex(hexIndex).getPResource();
                    Country c = this.game.getCountry(h.getOwningCountry());
                    int xPos = 0;
                    int yPos = 0;
                    Point p = new Point(this.game.northwestHexEdge(hexIndex));
                    xPos = (int)(p.getX() + 5.0 * (double)this.getZoom() - 8.0 * (double)this.getZoom() - (double)viewPos.x);
                    yPos = (int)(p.getY() + 8.0 * (double)this.getZoom() - 8.0 * (double)this.getZoom() - (double)viewPos.y);
                    g.drawImage(pr.getImage(this.getZoom(), c), xPos, yPos, this);
                    if (pr != null && pr.getPP() > 0 && this.game.getZoom() == 4) {
                        double fraction = (double)pr.getStrength() / (double)pr.maxStrength();
                        g.setColor(this.game.intervalColor(fraction, true));
                        int fontSize = 0 + 6 * this.getZoom();
                        if (!Global.bigFontFound()) {
                            fontSize -= 1 * this.getZoom();
                        }
                        g.setFont(new Font(Global.bigFontName1, 0, fontSize));
                        String s = "" + pr.getPP();
                        int xPos3 = this.game.centreOfHex((int)hexIndex).x - viewPos.x;
                        int yPos3 = this.game.centreOfHex((int)hexIndex).y + 2 * this.game.getZoom() - viewPos.y;
                        int displacement = Game.horizontalCentering(fontSize, s);
                        if (!Global.bigFontFound()) {
                            displacement -= 4;
                        }
                        g.drawString(s, xPos3 + displacement, yPos3);
                    }
                }
                ++i;
            }
            ++k;
        }
    }

    private void drawBattleImages(Graphics g, Point viewPos) {
        int wid = 16;
        int hei = 16;
        Rectangle rect = this.game.areaOnScreen();
        int col1 = rect.x;
        int row1 = rect.y;
        int col2 = col1 + rect.width;
        int row2 = row1 + rect.height;
        int k = col1;
        while (k < col2) {
            int i = row1;
            while (i <= row2) {
                Hex h;
                int hexIndex = this.game.getHex(k, i);
                if (hexIndex != -1 && (h = this.game.getHex(hexIndex)).getBattleImage(this.getZoom()) != null) {
                    int xPos = 0;
                    int yPos = 0;
                    Point p = new Point(this.game.centreOfHex(hexIndex));
                    xPos = (int)(p.getX() - 8.0 * (double)this.getZoom() - (double)viewPos.x);
                    yPos = (int)(p.getY() - 8.0 * (double)this.getZoom() - (double)viewPos.y);
                    g.drawImage(h.getBattleImage(this.getZoom()), xPos, yPos, this);
                }
                ++i;
            }
            ++k;
        }
    }

    private void drawHexNames2(Graphics g, Point viewPos) {
        int fontSize = 10 + 4 * this.getZoom();
        g.setFont(new Font(Global.bigFontName1, 0, fontSize));
        Rectangle rect = this.game.areaOnScreen();
        int col1 = rect.x;
        int row1 = rect.y;
        int col2 = col1 + rect.width;
        int row2 = row1 + rect.height;
        int k = col1;
        while (k < col2) {
            int i = row1;
            while (i <= row2) {
                String s = "";
                int hexIndex = this.game.getHex(k, i);
                if (hexIndex != -1) {
                    Hex hex = this.game.getHex(hexIndex);
                    PResource pr = this.game.getHex(hexIndex).getPResource();
                    int xPos = this.aboveSection((int)hexIndex, (Point)viewPos).x;
                    int yPos = this.aboveSection((int)hexIndex, (Point)viewPos).y;
                    if (!(hex.getHexName().length() == 0 || pr instanceof SeaPort && hex.getHexName().compareTo("Port") == 0 || pr instanceof Fortress && hex.getHexName().compareTo("Fortress") == 0)) {
                        s = this.game.getHex(hexIndex).getHexName();
                    }
                    if (pr != null) {
                        double fraction = (double)pr.getStrength() / (double)pr.maxStrength();
                        g.setColor(this.game.intervalColor(fraction, true));
                        if (pr.getPP() > 0) {
                            s = String.valueOf(s) + " (" + this.game.getHex(hexIndex).getPResource().getPP() + ")";
                        }
                    }
                    xPos = k == 0 ? (xPos += (int)(0.2 * (double)Game.horizontalCentering(fontSize, s))) : (xPos += Game.horizontalCentering(fontSize, s));
                    if (k == 149) {
                        xPos += (int)(0.5 * (double)Game.horizontalCentering(fontSize, s));
                    }
                    if (i == 0) {
                        yPos = this.belowSection((int)hexIndex, (Point)viewPos).y;
                    }
                    if (s != "") {
                        g.drawString(s, xPos, yPos);
                    }
                }
                ++i;
            }
            ++k;
        }
    }

    private void forceUpdateAllUnits() {
        if (this.game == null) {
            return;
        }
        int count = 10800;
        int i = 0;
        while (i < 10800) {
            this.game.getHex(i).setBufferedUnitImage(null);
            ++i;
        }
    }

    private void drawUnits(Graphics g, Point viewPos) {
        Rectangle rect = this.game.areaOnScreen();
        int col1 = rect.x;
        int row1 = rect.y;
        int col2 = col1 + rect.width;
        int row2 = row1 + rect.height;
        int k = col1;
        while (k < col2) {
            int i = row1;
            while (i <= row2) {
                int hexIndex = this.game.getHex(k, i);
                Unit u = this.game.getHex(hexIndex).getUnit();
                if (u != null && this.game.canSeeUnit(u, this.game.viewingSide())) {
                    int xPos = 0;
                    int yPos = 0;
                    Point p = new Point(this.game.northwestHexEdge(hexIndex));
                    xPos = (int)(p.getX() + 5.0 * (double)this.getZoom() - 0.5 * (double)(16 * this.getZoom()) + (double)u.getxoffset() - (double)viewPos.x);
                    yPos = (int)(p.getY() + 8.0 * (double)this.getZoom() - 0.45 * (double)(16 * this.getZoom()) + (double)u.getyoffset() - (double)viewPos.y);
                    int xPos2 = this.downSection((int)hexIndex, (Point)viewPos).x + u.getxoffset();
                    int yPos2 = this.downSection((int)hexIndex, (Point)viewPos).y + u.getyoffset();
                    BufferedImage buf = this.game.getHex(hexIndex).getBufferedUnitImage();
                    if (buf == null) {
                        ++this.unitsRebuffered;
                        buf = ((Graphics2D)g).getDeviceConfiguration().createCompatibleImage(16 * this.getZoom(), 16 * this.getZoom(), 3);
                        this.game.getHex(hexIndex).setBufferedUnitImage(buf);
                        Graphics2D g2d = buf.createGraphics();
                        AffineTransform savedTransform = g2d.getTransform();
                        g2d.translate(-xPos, -yPos);
                        AffineTransform at = new AffineTransform();
                        at.setToIdentity();
                        at.translate(xPos, yPos);
                        boolean mirrorImage = false;
                        int berlinColumn = this.game.getColumn(this.game.getCountry(0).getPrimaryCapital());
                        int unitColumn = this.game.getColumn(this.game.getHexIndex(u.getOnHex()));
                        if (u.getSide() == 100 && unitColumn < berlinColumn) {
                            mirrorImage = true;
                        } else if (u.getSide() != 100 && unitColumn > berlinColumn) {
                            mirrorImage = true;
                        }
                        if (mirrorImage && this.getZoom() > 1 && !this.game.getNatoSymbols()) {
                            at.translate(16 * this.getZoom(), 0.0);
                            at.scale(-1.0, 1.0);
                        }
                        g2d.drawImage(u.getImage(this.getZoom()), at, this);
                        String ss = "supply_";
                        if (u.getSupply() == 0) {
                            ss = String.valueOf(ss) + "out_";
                        } else if (u.getSupply() <= Global.LOW_SUPPLY) {
                            ss = String.valueOf(ss) + "low_";
                        } else if (u.getSupply() <= Global.HALF_SUPPLY) {
                            ss = String.valueOf(ss) + "half_";
                        }
                        if (u.getSupply() <= Global.HALF_SUPPLY) {
                            g2d.drawImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + ss + 16 * this.getZoom() + ".png"), (int)((double)xPos2 - 0.26 * (double)(16 * this.getZoom())), (int)((double)yPos2 - 0.6 * (double)(16 * this.getZoom())), this);
                        }
                        if (u.isInvisible()) {
                            String sss = "sub_below_";
                            g2d.drawImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "sub_below_" + 16 * this.getZoom() + ".png"), (int)((double)xPos2 - 0.26 * (double)(16 * this.getZoom())), (int)((double)yPos2 - 0.6 * (double)(16 * this.getZoom())), this);
                        }
                        int fontSize = 8 + 4 * this.getZoom();
                        if (!Global.bigFontFound()) {
                            fontSize -= 1 * this.getZoom();
                        }
                        g2d.setFont(this.getFontForUnit(fontSize));
                        int displacement = (int)(0.9 * (double)Game.horizontalCentering(fontSize, u.getStrength()));
                        if (!Global.bigFontFound()) {
                            displacement -= 3;
                            if (u.getStrength() >= 10) {
                                displacement -= 3;
                            }
                            if (u.getStrength() >= 100) {
                                displacement -= 3;
                            }
                        }
                        double fraction = (double)u.getMorale() / 100.0;
                        g2d.setColor(this.game.intervalColor(fraction, false));
                        if (this.getZoom() > 1) {
                            g2d.drawString(String.valueOf(u.getStrength()), xPos2 + displacement, yPos2);
                        }
                        if (this.game.getNowShowing() == 8 && u.getSide() == this.game.playerSide()) {
                            g2d.setColor(Color.white);
                            if (u.canUpgrade()) {
                                g2d.setColor(Color.red);
                            }
                            int xPos3 = this.upSection((int)hexIndex, (Point)viewPos).x + u.getxoffset();
                            int yPos3 = this.upSection((int)hexIndex, (Point)viewPos).y + u.getyoffset();
                            String upgr = String.valueOf(String.valueOf(u.getUpgradesHeld())) + "/" + String.valueOf(u.getCountry().getUpgradesHeld(u));
                            displacement = Game.horizontalCentering(fontSize, upgr);
                            g2d.drawString(upgr, xPos3 + displacement, yPos3 + 5);
                        }
                        g2d.setTransform(savedTransform);
                    }
                    g.drawImage(buf, xPos, yPos, this);
                    String s = "";
                    s = u.getHasMoved() ? "moved_" : (u.getSide() == this.game.whosTurn() && u.getSide() == this.game.playerSide() ? (this.animationState == 0 ? "move_" : "moved_") : (!u.getHasMoved() ? "move_" : "moved_"));
                    String emblem = "emblem_";
                    if (u.getCommander() != null) {
                        emblem = "leader_";
                    }
                    g.drawImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + emblem + u.getCountry().getDataName().toLowerCase() + "_" + s + 4 * this.getZoom() + ".png"), (int)((double)xPos2 - 0.4 * (double)(16 * this.getZoom())), (int)((double)yPos2 - 0.25 * (double)(16 * this.getZoom())), this);
                }
                ++i;
            }
            ++k;
        }
    }

    private Font getFontForUnit(int fontSize) {
        Integer key = new Integer(fontSize);
        Font ret = this.mUnitFonts.get(key);
        if (ret == null) {
            ret = new Font(Global.bigFontName1, 0, fontSize);
            this.mUnitFonts.put(key, ret);
        }
        return ret;
    }

    private void drawSelectRectangle(Graphics g, Point viewPos) {
        Unit u;
        Hex selectedHex = this.game.getActionHex();
        int hexIndex = this.game.getHexIndex(selectedHex);
        if (selectedHex != null && selectedHex.getUnit() != null && (u = selectedHex.getUnit()) != null && this.game.canSeeUnit(u, this.game.viewingSide())) {
            Point p = new Point(this.game.northwestHexEdge(this.game.getHexIndex(selectedHex)));
            int xPos = (int)(p.getX() + 5.0 * (double)this.getZoom() - 0.5 * (double)(16 * this.getZoom()) + (double)this.game.getHex(hexIndex).getUnit().getxoffset() - (double)viewPos.x);
            int yPos = (int)(p.getY() + 8.0 * (double)this.getZoom() - 0.5 * (double)(16 * this.getZoom()) + (double)this.game.getHex(hexIndex).getUnit().getyoffset() - (double)viewPos.y);
            g.setColor(Color.yellow);
            g.drawRect(xPos, yPos, 16 * this.getZoom(), 16 * this.getZoom());
            g.drawRect(xPos, yPos, 16 * this.getZoom(), 16 * this.getZoom());
        }
    }

    private void drawDefenderRectangle(Graphics g, Point viewPos) {
        Hex selectedHex = this.game.getEnemyActionHex();
        if (selectedHex != null) {
            Point p = new Point(this.game.northwestHexEdge(this.game.getHexIndex(selectedHex)));
            int xPos = (int)(p.getX() + 5.0 * (double)this.getZoom() - 0.5 * (double)(16 * this.getZoom()) - (double)viewPos.x);
            int yPos = (int)(p.getY() + 8.0 * (double)this.getZoom() - 0.5 * (double)(16 * this.getZoom()) - (double)viewPos.y);
            g.setColor(Color.red);
            g.drawRect(xPos, yPos, 16 * this.getZoom(), 16 * this.getZoom());
            g.drawRect(xPos, yPos, 16 * this.getZoom(), 16 * this.getZoom());
        }
    }

    private void drawCountryFlags(Graphics g, Point viewPos) {
        Country[] countries = this.game.getCountries();
        int i = 0;
        while (i < countries.length) {
            if (!countries[i].isConquered()) {
                int hexIndex = countries[i].activeCapital();
                if (hexIndex == -1) {
                    hexIndex = this.game.middleMostCity(i);
                }
                if (hexIndex != -1) {
                    int flagSize = 36;
                    int x = this.centerOfHex((int)hexIndex, (Point)viewPos).x - 18;
                    x = Math.max(0 - this.viewPosition.x, x);
                    int y = this.centerOfHex((int)hexIndex, (Point)viewPos).y - 13;
                    y = Math.max(0 - this.viewPosition.y, y);
                    g.drawImage(countries[i].getFlag(36, ""), x, y, this);
                }
            }
            ++i;
        }
    }

    private void drawChatMessages(Graphics g, Point viewPos) {
        Vector<ColorString> v = this.game.getChatMessages().getMessages();
        g.setFont(new Font("Arial", 0, 16));
        Point startLoc = new Point(10, 550);
        int looped_times = 0;
        int i = v.size() - 1;
        while (i >= 0) {
            ColorString cs = v.get(i);
            g.setColor(cs.getColor());
            g.drawString(cs.getString(), startLoc.x, startLoc.y - 18 * looped_times);
            ++looped_times;
            --i;
        }
    }

    private void drawDamages(Graphics g, Point viewPos) {
        Image unitDamage = Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "damage2_" + 16 * this.getZoom() + ".png");
        Image resourceDamage = Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "damage1_" + 16 * this.getZoom() + ".png");
        if (this.damages.isActive()) {
            int displacementY;
            int displacementX;
            int ypos;
            int xpos;
            int fontSize = 8 + 4 * this.getZoom();
            g.setFont(new Font(Global.bigFontName1, 1, fontSize));
            g.setColor(Color.black);
            int val = this.damages.getStrengthLoss1();
            if (val > 0) {
                xpos = this.game.northwestHexEdge((int)this.damages.getHex1()).x - viewPos.x - 10 * this.getZoom();
                ypos = this.game.northwestHexEdge((int)this.damages.getHex1()).y - viewPos.y;
                if (this.damages.getType1() == 1) {
                    g.drawImage(resourceDamage, xpos, ypos, this);
                } else {
                    g.drawImage(unitDamage, xpos, ypos, this);
                }
                xpos = this.centerOfHex((int)this.damages.getHex1(), (Point)viewPos).x - (int)(0.65 * (double)(this.getZoom() * 10));
                ypos = this.centerOfHex((int)this.damages.getHex1(), (Point)viewPos).y;
                displacementX = Game.horizontalCentering(fontSize, val);
                displacementY = Game.verticalCentering(fontSize);
                g.drawString("" + val, xpos + displacementX, ypos + displacementY);
            }
            if ((val = this.damages.getStrengthLoss2()) > 0) {
                xpos = this.game.northwestHexEdge((int)this.damages.getHex2()).x - viewPos.x - 10 * this.getZoom();
                ypos = this.game.northwestHexEdge((int)this.damages.getHex2()).y - viewPos.y;
                if (this.damages.getType2() == 1) {
                    g.drawImage(resourceDamage, xpos, ypos, this);
                } else {
                    g.drawImage(unitDamage, xpos, ypos, this);
                }
                xpos = this.centerOfHex((int)this.damages.getHex2(), (Point)viewPos).x - (int)(0.65 * (double)(this.getZoom() * 10));
                ypos = this.centerOfHex((int)this.damages.getHex2(), (Point)viewPos).y;
                displacementX = Game.horizontalCentering(fontSize, val);
                displacementY = Game.verticalCentering(fontSize);
                g.drawString("" + val, xpos + displacementX, ypos + displacementY);
            }
        }
        if (System.currentTimeMillis() >= this.damageStopTime) {
            this.damages.deactivate();
        }
    }

    private String toolTip(Unit u) {
        String ret = "";
        switch (this.game.getNowShowing()) {
            case 7: {
                if (!u.getOnHex().getHighlighted()) {
                    if (!u.getCountry().getAtWar()) {
                        ret = Global.getMessage(427);
                        break;
                    }
                    if (u.getSide() == this.game.opponentSide()) {
                        ret = Global.getMessage(428);
                        break;
                    }
                    if (u.getCountry().getPP() < (double)(-Global.MAX_DEFICIT_BEFORE_SPENDING_STOP)) {
                        ret = Global.getMessage(429);
                        break;
                    }
                    if (u.getSupply() == 0) {
                        ret = Global.getMessage(430);
                        break;
                    }
                    if (u.getStrength() == u.maxStrength()) {
                        ret = Global.getMessage(432);
                        break;
                    }
                    if (u.getHasMoved()) {
                        ret = Global.getMessage(433);
                        break;
                    }
                    if (!(u instanceof NavalUnit)) break;
                    ret = Global.getMessage(431);
                    break;
                }
                int reinf = (int)u.maximumAmountThatCanBeReinforced();
                ret = Global.createLanguageMessage(119, new String[]{"" + reinf, "" + (int)u.reinforceCost(reinf), "" + (int)u.manpowerCost(reinf)});
                break;
            }
            case 8: {
                if (!u.getOnHex().getHighlighted()) {
                    if (!u.getCountry().getAtWar()) {
                        ret = Global.getMessage(427);
                        break;
                    }
                    if (u.getSide() == this.game.opponentSide()) {
                        ret = Global.getMessage(428);
                        break;
                    }
                    if (u.getCountry().getPP() < (double)(-Global.MAX_DEFICIT_BEFORE_SPENDING_STOP)) {
                        ret = Global.getMessage(429);
                        break;
                    }
                    if (u.getSupply() == 0) {
                        ret = Global.getMessage(430);
                        break;
                    }
                    if (u.getUpgradesHeld() == u.getCountry().getUpgradesHeld(u)) {
                        ret = Global.getMessage(435);
                        break;
                    }
                    if (u.getHasMoved()) {
                        ret = Global.getMessage(433);
                        break;
                    }
                    if (u instanceof NavalUnit) {
                        ret = Global.getMessage(453);
                        break;
                    }
                    if (this.game.enemiesAdjacent(this.game.getHexIndex(u.getOnHex()), u) <= 0) break;
                    ret = Global.getMessage(475);
                    break;
                }
                ret = Global.createLanguageMessage(120, new String[]{"" + u.getUpgradesHeld(), "" + u.getCountry().getUpgradesHeld(u), "" + (int)u.upgradeCost()});
            }
        }
        return ret;
    }

    private void drawToolTips(Graphics g, Point viewPos) {
        if (this.game.getWarWindow().isShowingDialog() || this.automaticMoving || this.game.whosTurn() == this.game.playerSide()) {
            // empty if block
        }
        long beforeTime = System.currentTimeMillis();
        String s = "";
        if (this.game.getNowShowing() != 5 && this.toolTipUnit != null && !this.damages.isActive() && beforeTime >= this.toolTipStartTime) {
            int fontSize = 16;
            g.setFont(new Font(Global.bigFontName1, 0, 16));
            Hex h = this.toolTipUnit.getOnHex();
            if (h != null && this.game.getSelectedHex() == null && h.getUnit() != null && this.game.canSeeUnit(h.getUnit(), this.game.viewingSide())) {
                this.game.getWarWindow().showBelowPanels(1, this.toolTipUnit, null, null, false);
                int hexIndex = this.game.getHexIndex(h);
                PResource pResource = h.getPResource();
                Terrain terrain = h.getTerrain();
                int xpos = this.aboveSection((int)hexIndex, (Point)viewPos).x;
                int ypos = this.aboveSection((int)hexIndex, (Point)viewPos).y;
                g.setColor(new Color(80, 80, 255));
                String draw = this.toolTip(h.getUnit());
                int displacement = Game.horizontalCentering(16, draw);
                g.fillRect(xpos + displacement, ypos - 20, 2 * Math.abs(displacement), 20);
                g.setColor(Color.white);
                g.drawString(draw, xpos + displacement, ypos - 6);
                g.setColor(Color.black);
                g.setColor(Color.white);
                g.setColor(Color.black);
                if (Global.SETTINGS_DATA.getVal("DEBUG_AI") == 1) {
                    g.setFont(new Font("Arial", 0, 20));
                    ypos += 75;
                    if (this.toolTipUnit.getDestinationHex() != null) {
                        Strategy strat = this.toolTipUnit.getCountry().getStrategy();
                        int hex = this.game.getHexIndex(this.toolTipUnit.getDestinationHex());
                        String targetNum = "";
                        if (strat.getPrimaryTarget() == hex) {
                            targetNum = "PRIMARY";
                        } else if (strat.getSecondaryTarget() == hex) {
                            targetNum = "SECONDARY";
                        } else if (strat.getTertiaryTarget() == hex) {
                            targetNum = "TERTIARY";
                        }
                        g.drawString("Target->" + this.toolTipUnit.getDestinationHex().getHexName() + " (" + this.game.getColumn(hex) + "," + this.game.getRow(hex) + ") " + targetNum, xpos, ypos);
                        ypos -= 25;
                    }
                    if (this.toolTipUnit.getWayPoint() != null) {
                        g.drawString("Way Point->(" + this.game.getColumn(this.game.getHexIndex(this.toolTipUnit.getWayPoint())) + "," + this.game.getRow(this.game.getHexIndex(this.toolTipUnit.getWayPoint())) + ")", xpos, ypos);
                    }
                    ypos -= 25;
                    if (this.toolTipUnit.getChasePoint() != null) {
                        g.drawString("Chase Point->(" + this.game.getColumn(this.game.getHexIndex(this.toolTipUnit.getChasePoint())) + "," + this.game.getRow(this.game.getHexIndex(this.toolTipUnit.getChasePoint())) + ")", xpos, ypos);
                    }
                    ypos -= 25;
                }
                g.setFont(new Font("Arial", 0, 10));
                if (h instanceof LandHex) {
                    if (pResource != null) {
                        if (pResource instanceof City) {
                            s = "CITY";
                        } else if (pResource instanceof Capital) {
                            s = "CAPITAL";
                        } else if (pResource instanceof Mine) {
                            s = "MINE";
                        } else if (pResource instanceof OilField) {
                            s = "OIL";
                        } else if (pResource instanceof Fortress) {
                            s = "FORTRESS";
                        }
                    } else {
                        s = terrain instanceof Clear ? "CLEAR" : (terrain instanceof Forest ? "FOREST" : (terrain instanceof Rough ? "ROUGH" : (terrain instanceof Mountain ? "MOUNTAIN" : (terrain instanceof Swamp ? "SWAMP" : (terrain instanceof Desert ? "DESERT" : "DUNE")))));
                        s = String.valueOf(s) + " TERRAIN";
                    }
                } else {
                    s = pResource instanceof SeaPort ? "PORT" : "WATER";
                }
            }
        } else if (this.game.getSelectedHex() == null && this.toolTipUnit == null && this.game.getNowShowing() != 2) {
            this.game.getWarWindow().showBelowPanels(0, null, null, null, false);
        }
    }

    public void update(Graphics g) {
    }

    public void updateUI() {
        this.forceUpdateAllUnits();
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (!this.game.getWarWindow().isShowingDialog()) {
            if (this.isShowing() && (infoflags & 0x20) != 0) {
                this.repaint();
            }
            if (this.isShowing() && (infoflags & 0x10) != 0) {
                this.repaint();
            }
        }
        return this.isShowing();
    }

    public void render(Graphics g) {
        Point p = new Point(this.viewPosition.x, this.viewPosition.y);
        super.paintComponent(g);
        this.drawMap(g, p);
        if (Global.getMachineSpec() >= 2 || this.game.getNowShowing() == 5) {
            this.drawHexColorsAndFOW(g, p);
        }
        this.drawTransportationLoops(g, p);
        if (this.showHexNames) {
            this.drawHexNames2(g, p);
        }
        this.drawPResources(g, p);
        this.drawNationalBorders(g, p);
        this.drawOccupyingBorders(g, p);
        if (this.game.getNowShowing() != 5 && this.showUnits) {
            this.drawUnits(g, p);
        }
        this.drawToolTips(g, p);
        this.drawDamages(g, p);
        if (!this.game.getGameState().getHasStartedMoving()) {
            this.drawArrows(g, p);
        }
        if (!this.game.getGameState().getHasStartedMoving()) {
            this.drawBattleImages(g, p);
        }
        if (!this.automaticMoving) {
            this.drawMoveMarkers(g, p);
            this.drawHighlights(g, p);
            this.drawAttackTargets(g, p);
        }
        this.drawSelectRectangle(g, p);
        this.drawDefenderRectangle(g, p);
        if (this.game.getNowShowing() == 5) {
            this.drawCountryFlags(g, p);
        }
        this.drawChatMessages(g, p);
    }

    public void paintComponent(Graphics g) {
        long beforeTime = System.currentTimeMillis();
        this.animationState = beforeTime % 1500L > 1200L ? 1 : 0;
        this.render(g);
        this.game.repaintAllDialogs();
    }

    void this_mouseReleased(MouseEvent e) {
    }

    void this_mouseMoved(MouseEvent e) {
        Hex h;
        if (e.getX() < 10) {
            this.game.setMouseScroll(1);
        } else if (e.getY() < 10) {
            this.game.setMouseScroll(2);
        } else if (e.getX() > 1013) {
            this.game.setMouseScroll(3);
        } else if (e.getY() > 757) {
            this.game.setMouseScroll(4);
        } else {
            this.game.setMouseScroll(0);
        }
        if (this.game.getNowShowing() != 2 && this.game.allowInput() && this.game.mousePointedHex(e.getX(), e.getY(), true) != -1 && (h = this.game.getHex(this.game.mousePointedHex(e.getX(), e.getY(), true))) != null) {
            if (h.getTargetted()) {
                if (h.getPResource() != null) {
                    if (this.game.getWarWindow().getLeftUnit() instanceof StrategicBomber || h.getUnit() == null) {
                        this.game.getWarWindow().showBelowPanels(2, this.game.getWarWindow().getLeftUnit(), null, h, true);
                    } else {
                        this.game.getWarWindow().showBelowPanels(2, this.game.getWarWindow().getLeftUnit(), h.getUnit(), null, true);
                    }
                } else {
                    this.game.getWarWindow().showBelowPanels(2, this.game.getWarWindow().getLeftUnit(), h.getUnit(), null, true);
                }
                if (this.game.getSelectedHex() != null) {
                    OddsAndPenalties odds = this.game.expectedOdds(this.game.getSelectedHex(), h);
                    this.game.getWarWindow().getCombatPanel().updateAll(odds);
                } else {
                    OddsAndPenalties odds = this.game.expectedOdds(this.game.getTmpUnitHex(), h);
                    this.game.getWarWindow().getCombatPanel().updateAll(odds);
                }
                this.toolTipUnit = null;
            } else {
                this.game.getWarWindow().getCombatPanel().updateAll(null);
                if (this.game.getSelectedHex() == null && this.toolTipUnit == null) {
                    this.game.getWarWindow().showBelowPanels(0, null, null, null, false);
                } else if (this.game.getSelectedHex() != null && this.game.getWarWindow().getLeftUnit() != null) {
                    this.game.getWarWindow().showBelowPanels(1, this.game.getWarWindow().getLeftUnit(), null, null, false);
                }
                Unit preUnit = this.toolTipUnit;
                this.toolTipUnit = this.game.getSelectedHex() == null && h.getUnit() != null && this.game.canSeeUnit(h.getUnit(), this.game.viewingSide()) ? h.getUnit() : null;
                if (preUnit != this.toolTipUnit) {
                    this.toolTipStartTime = System.currentTimeMillis() + 100L;
                }
            }
        }
    }

    void this_mousePressed(MouseEvent e) {
        if (!this.game.getBusy()) {
            if (e.getButton() == 1) {
                this.game.mouseClickedPixel(e.getX(), e.getY(), null, true);
            } else if (e.getButton() == 3) {
                this.game.mouseClickedPixel(e.getX(), e.getY(), null, false);
            }
        }
    }

    void this_mouseExited(MouseEvent e) {
        this.game.resetScrolling();
    }
}

