/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.Game;
import game.Global;
import game.OrderThread;
import gui.BackgroundPanel;
import gui.Credits;
import gui.GameModeSelection2;
import gui.GameSetupPanel;
import gui.MainMenu_jButton1_actionAdapter;
import gui.MainMenu_jButton1_mouseAdapter;
import gui.MainMenu_jButton20_actionAdapter;
import gui.MainMenu_jButton20_mouseAdapter;
import gui.MainMenu_jButton2_actionAdapter;
import gui.MainMenu_jButton2_mouseAdapter;
import gui.MainMenu_jButton3_actionAdapter;
import gui.MainMenu_jButton3_mouseAdapter;
import gui.MainMenu_jButton4_actionAdapter;
import gui.MainMenu_jButton4_mouseAdapter;
import gui.MainMenu_jButton5_actionAdapter;
import gui.MainMenu_jButton5_mouseAdapter;
import gui.MainMenu_jButton6_actionAdapter;
import gui.MainMenu_jButton6_mouseAdapter;
import gui.MainMenu_jToggleButton3_actionAdapter;
import gui.MainMenu_jToggleButton3_mouseAdapter;
import gui.MyJFileChooser;
import gui.MyJToggleButton;
import gui.PickSidePanel;
import gui.ScenarioSelectionPanel;
import gui.TcpIpSetupPanel;
import gui.TheScreen;
import gui.WarWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class MainMenu
extends BackgroundPanel {
    private static final long serialVersionUID = 24L;
    Cursor busyCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "cursor_busy.png"), new Point(0, 0), "circle");
    int textSize = 24;
    int largeTextSize = 28;
    Color button = new Color(255, 255, 255, 63);
    Color selectedButton = Color.white;
    Credits credits;
    Game game;
    WarWindow warWindow;
    TheScreen theScreen;
    GameModeSelection2 gameModeSelection;
    MyJFileChooser myJFileChooser;
    GameSetupPanel gameSetupPanel;
    PickSidePanel pickSidePanel;
    TcpIpSetupPanel tcpIpSetupPanel;
    ScenarioSelectionPanel scenarioSelectionPanel;
    boolean showSettingsButton = false;
    JPanel jPanel1;
    BorderLayout borderLayout1 = new BorderLayout();
    JToggleButton jButton1 = new MyJToggleButton(Global.getMessage(43), new Font(Global.bigFontName1, 0, this.textSize), this.button, this.selectedButton, this.largeTextSize);
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JToggleButton jButton2 = new MyJToggleButton(Global.getMessage(49), new Font(Global.bigFontName1, 0, this.textSize), this.button, this.selectedButton, this.largeTextSize);
    JToggleButton jButton4 = new MyJToggleButton(Global.getMessage(45), new Font(Global.bigFontName1, 0, this.textSize), this.button, this.selectedButton, this.largeTextSize);
    JToggleButton jButton5 = new MyJToggleButton(Global.getMessage(44), new Font(Global.bigFontName1, 0, this.textSize), this.button, this.selectedButton, this.largeTextSize);
    JToggleButton jButton6 = new MyJToggleButton(Global.getMessage(46), new Font(Global.bigFontName1, 0, this.textSize), this.button, this.selectedButton, this.largeTextSize);
    JToggleButton jButton3 = new MyJToggleButton(Global.getMessage(48), new Font(Global.bigFontName1, 0, this.textSize), this.button, this.selectedButton, this.largeTextSize);
    JToggleButton jButton20 = new MyJToggleButton(Global.getMessage(1308), new Font(Global.bigFontName1, 0, this.textSize), this.button, this.selectedButton, this.largeTextSize);
    JToggleButton jToggleButton3 = new MyJToggleButton(Global.getMessage(47), new Font(Global.bigFontName1, 0, this.textSize), this.button, this.selectedButton, this.largeTextSize);
    JPanel jPanel2 = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel jPanel3 = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();

    public MainMenu(TheScreen theScr, Image im) {
        super(im);
        int i = Global.SETTINGS_DATA.getVal("HAS_RUN_TUTORIAL");
        if (i == 0) {
            this.jToggleButton3 = new MyJToggleButton(Global.getMessage(47), new Font(Global.bigFontName1, 0, this.textSize), Color.red, this.selectedButton, this.largeTextSize);
        }
        this.theScreen = theScr;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setCursor(Cursor.getDefaultCursor());
        this.game = new Game(this.theScreen);
        this.game.setMainMenu(this);
        this.warWindow = new WarWindow(this.theScreen, this.game);
        this.credits = new Credits(this.theScreen, this, null);
        this.gameSetupPanel = new GameSetupPanel(this.game);
        this.tcpIpSetupPanel = new TcpIpSetupPanel(this.game);
        this.pickSidePanel = new PickSidePanel(this.game);
        this.scenarioSelectionPanel = new ScenarioSelectionPanel(this.game);
        this.gameModeSelection = new GameModeSelection2(this.theScreen, this.game, this.gameSetupPanel, "PICK GAME MODE", "HOTSEAT", "PBEM", "TCP/IP");
        this.myJFileChooser = new MyJFileChooser();
        OrderThread o = new OrderThread(this.game);
        this.game.setOrderThread(o);
        this.jPanel1 = new JPanel();
        this.setLayout(this.borderLayout1);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(1024, 768));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jButton1.setMaximumSize(new Dimension(220, 15));
        this.jButton1.setMinimumSize(new Dimension(220, 21));
        this.jButton1.setOpaque(false);
        this.jButton1.setPreferredSize(new Dimension(320, 34));
        this.jButton1.setRequestFocusEnabled(false);
        this.jButton1.setBorderPainted(false);
        this.jButton1.setContentAreaFilled(false);
        this.jButton1.addMouseListener(new MainMenu_jButton1_mouseAdapter(this));
        this.jButton1.addActionListener(new MainMenu_jButton1_actionAdapter(this));
        this.jButton2.setMaximumSize(new Dimension(220, 15));
        this.jButton2.setMinimumSize(new Dimension(220, 21));
        this.jButton2.setOpaque(false);
        this.jButton2.setPreferredSize(new Dimension(320, 34));
        this.jButton2.setRequestFocusEnabled(false);
        this.jButton2.setBorderPainted(false);
        this.jButton2.setContentAreaFilled(false);
        this.jButton2.addMouseListener(new MainMenu_jButton2_mouseAdapter(this));
        this.jButton2.addActionListener(new MainMenu_jButton2_actionAdapter(this));
        this.jButton4.setMaximumSize(new Dimension(220, 15));
        this.jButton4.setMinimumSize(new Dimension(220, 21));
        this.jButton4.setOpaque(false);
        this.jButton4.setPreferredSize(new Dimension(320, 34));
        this.jButton4.setRequestFocusEnabled(false);
        this.jButton4.setBorderPainted(false);
        this.jButton4.setContentAreaFilled(false);
        this.jButton4.addMouseListener(new MainMenu_jButton4_mouseAdapter(this));
        this.jButton4.addActionListener(new MainMenu_jButton4_actionAdapter(this));
        this.jButton5.setMaximumSize(new Dimension(220, 15));
        this.jButton5.setMinimumSize(new Dimension(220, 21));
        this.jButton5.setOpaque(false);
        this.jButton5.setPreferredSize(new Dimension(320, 34));
        this.jButton5.setRequestFocusEnabled(false);
        this.jButton5.setActionCommand("Load Game");
        this.jButton5.setBorderPainted(false);
        this.jButton5.setContentAreaFilled(false);
        this.jButton5.addMouseListener(new MainMenu_jButton5_mouseAdapter(this));
        this.jButton5.addActionListener(new MainMenu_jButton5_actionAdapter(this));
        this.jButton6.setMaximumSize(new Dimension(220, 15));
        this.jButton6.setMinimumSize(new Dimension(220, 21));
        this.jButton6.setOpaque(false);
        this.jButton6.setPreferredSize(new Dimension(320, 34));
        this.jButton6.setRequestFocusEnabled(false);
        this.jButton6.setBorderPainted(false);
        this.jButton6.setContentAreaFilled(false);
        this.jButton6.addMouseListener(new MainMenu_jButton6_mouseAdapter(this));
        this.jButton6.addActionListener(new MainMenu_jButton6_actionAdapter(this));
        this.setMinimumSize(new Dimension(1024, 768));
        this.setPreferredSize(new Dimension(1024, 768));
        this.jButton3.setOpaque(false);
        this.jButton3.setPreferredSize(new Dimension(320, 34));
        this.jButton3.setRequestFocusEnabled(false);
        this.jButton3.setBorderPainted(false);
        this.jButton3.setContentAreaFilled(false);
        this.jButton3.addMouseListener(new MainMenu_jButton3_mouseAdapter(this));
        this.jButton3.addActionListener(new MainMenu_jButton3_actionAdapter(this));
        this.jButton20.setOpaque(false);
        this.jButton20.setPreferredSize(new Dimension(320, 34));
        this.jButton20.setRequestFocusEnabled(false);
        this.jButton20.setBorderPainted(false);
        this.jButton20.setContentAreaFilled(false);
        this.jButton20.addMouseListener(new MainMenu_jButton20_mouseAdapter(this));
        this.jButton20.addActionListener(new MainMenu_jButton20_actionAdapter(this));
        this.jToggleButton3.setOpaque(false);
        this.jToggleButton3.setPreferredSize(new Dimension(320, 34));
        this.jToggleButton3.setRequestFocusEnabled(false);
        this.jToggleButton3.setBorderPainted(false);
        this.jToggleButton3.setContentAreaFilled(false);
        this.jToggleButton3.addMouseListener(new MainMenu_jToggleButton3_mouseAdapter(this));
        this.jToggleButton3.addActionListener(new MainMenu_jToggleButton3_actionAdapter(this));
        this.jPanel2.setOpaque(false);
        this.jPanel2.setPreferredSize(new Dimension(200, 10));
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setPreferredSize(new Dimension(200, 768));
        this.jPanel3.setLayout(this.gridBagLayout3);
        this.jLabel1.setFont(new Font(Global.smallFontName1, 0, 14));
        this.jLabel1.setForeground(Color.white);
        this.jLabel1.setPreferredSize(new Dimension(100, 15));
        String ss = "" + this.game.getGameState().getVersion() % 100;
        if (ss.length() == 1) {
            ss = "0" + ss;
        }
        this.jLabel1.setText(Global.createLanguageMessage(351, new String[]{this.game.getGameState().getVersion() / 100 + "." + ss}));
        this.jPanel1.add((Component)this.jButton1, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(288, 11, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButton2, new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButton4, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButton5, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButton6, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButton3, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 5, 0, 0), 0, 0));
        if (this.showSettingsButton) {
            this.jPanel1.add((Component)this.jButton20, new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 5, 0, 0), 0, 0));
        }
        this.jPanel1.add((Component)this.jToggleButton3, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 0, new Insets(20, 5, 0, 0), 0, 0));
        this.add((Component)this.jPanel3, "East");
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(740, 108, 0, 0), 0, 0));
        this.add((Component)this.jPanel2, "West");
        this.add((Component)this.jPanel1, "Center");
        this.jButton1.setFocusable(false);
        this.jButton2.setFocusable(false);
        this.jButton3.setFocusable(false);
        this.jButton4.setFocusable(false);
        this.jButton5.setFocusable(false);
        this.jButton6.setFocusable(false);
        this.jButton20.setFocusable(false);
        this.tcpIpSetupPanel.reset();
    }

    public GameSetupPanel getGameSetupPanel() {
        return this.gameSetupPanel;
    }

    public TcpIpSetupPanel getTcpIpSetupPanel() {
        return this.tcpIpSetupPanel;
    }

    public void activateMainMenu() {
        this.jButton1.setEnabled(true);
        this.jButton2.setEnabled(true);
        this.jButton3.setEnabled(true);
        this.jButton4.setEnabled(true);
        this.jButton5.setEnabled(true);
        this.jButton6.setEnabled(true);
        this.jButton20.setEnabled(true);
        this.jToggleButton3.setEnabled(true);
    }

    public void connectPhase(int phase) {
        this.tcpIpSetupPanel.connectPhase(phase);
    }

    public void reset() {
        this.setCursor(new Cursor(0));
        this.gameSetupPanel.reset();
        this.gameSetupPanel.enableDiableOptions(true);
        this.jButton1.setSelected(false);
        this.jButton2.setSelected(false);
        this.jButton3.setSelected(false);
        this.jButton4.setSelected(false);
        this.jButton5.setSelected(false);
        this.jButton6.setSelected(false);
        this.jButton20.setSelected(false);
        this.jToggleButton3.setSelected(false);
        this.setFullEnabled(true);
    }

    public void setFullEnabled(boolean on) {
        this.tcpIpSetupPanel.setFullEnabled(on);
    }

    public Game getGame() {
        return this.game;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.game.repaintAllDialogs();
    }

    public void repaintDialogs() {
        if (this.myJFileChooser == null) {
            return;
        }
        this.myJFileChooser.repaint();
        this.gameModeSelection.repaint();
    }

    public void showGameSetupPanel(String text, int mode) {
        if (this.gameSetupPanel.optionsEnabled()) {
            this.game.getGameState().setFOW(this.getGameSetupPanel().getOption(1));
            this.game.getGameState().setEnd1945(this.getGameSetupPanel().getOption(2));
            this.game.getGameState().setRandomResearch(this.getGameSetupPanel().getOption(3));
            this.game.getGameState().setOilConsumption(this.getGameSetupPanel().getOption(4));
        }
        this.warWindow.getOptionsDialog().resetAllOptions();
        this.game.setGameMode(mode);
        this.gameSetupPanel.updateAll(text, this.gameSetupPanel.tab);
        this.theScreen.showPanel(this.gameSetupPanel);
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        this.showGameSetupPanel("NEW GAME", 1000);
    }

    void jButton2_actionPerformed(ActionEvent e) {
        this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        Global.SETTINGS_DATA.saveSettings();
        System.exit(0);
    }

    void jButton3_actionPerformed(ActionEvent e) {
        this.theScreen.showPanel(this.credits);
    }

    void jButton20_actionPerformed(ActionEvent e) {
        this.warWindow.optionsDialog.showDialog();
    }

    void jButton4_actionPerformed(ActionEvent e) {
        this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        this.gameModeSelection.setState(0);
        this.theScreen.showPanel(this.gameModeSelection);
    }

    public void nnewMulti() {
        int mode = -1;
        int selected = this.gameModeSelection.getSelectedButton();
        if (selected == 0) {
            mode = 2000;
            this.showGameSetupPanel("NEW HOTSEAT GAME", mode);
        } else if (selected == 1) {
            mode = 4000;
            this.showGameSetupPanel("NEW PBEM GAME", mode);
        } else if (selected == 2) {
            mode = 3000;
            this.showGameSetupPanel("NEW TCP/IP GAME", mode);
        }
    }

    public void lloadMulti() {
        int mode = -1;
        int selected = this.gameModeSelection.getSelectedButton();
        if (selected == 0) {
            mode = 2000;
        } else if (selected == 1) {
            mode = 4000;
        } else if (selected == 2) {
            mode = 3000;
        }
        this.loadGame(mode, false);
    }

    public void startTCPIPGame(boolean newScenario) {
        if (newScenario) {
            this.game.setUpGame();
        }
        this.game.startGame(newScenario);
        this.warWindow.updateAll(true);
    }

    void jButton5_actionPerformed(ActionEvent e) {
        this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        int mode = 1000;
        this.loadGame(1000, false);
    }

    void jButton6_actionPerformed(ActionEvent e) {
        this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        this.gameModeSelection.setState(1);
        this.theScreen.showPanel(this.gameModeSelection);
    }

    public String loadGame(int mode, boolean scenario) {
        String fileName = "";
        if (scenario) {
            this.myJFileChooser.prepare(99, true);
        } else {
            this.myJFileChooser.prepare(mode, true);
        }
        int result = this.myJFileChooser.showOpenDialog(this.theScreen);
        boolean loadSuceeded = false;
        switch (result) {
            case 0: {
                this.setCursor(this.busyCursor);
                fileName = this.myJFileChooser.getName(this.myJFileChooser.getSelectedFile());
                loadSuceeded = this.game.loadGame(mode, false, scenario, this.myJFileChooser.getCurrentDirectory() + "/", fileName);
                if (!loadSuceeded) {
                    this.warWindow.showOkDialog(Global.getMessage(270));
                }
                this.reset();
                break;
            }
            case 1: {
                break;
            }
        }
        if (loadSuceeded && mode != 3000 && !scenario) {
            this.game.startGame(false);
        } else if (mode == 3000) {
            this.gameSetupPanel.enableDiableOptions(false);
            this.showGameSetupPanel("LOAD TCP/IP GAME", mode);
        }
        this.setCursor(Cursor.getDefaultCursor());
        return fileName;
    }

    public void saveGame(int mode) {
        this.myJFileChooser.prepare(mode, false);
        int result = this.myJFileChooser.showSaveDialog(this.theScreen);
        switch (result) {
            case 0: {
                String name = this.myJFileChooser.getName(this.myJFileChooser.getSelectedFile());
                if (!name.endsWith(".data")) {
                    name = String.valueOf(name) + ".data";
                }
                this.game.saveGame(false, false, this.myJFileChooser.getCurrentDirectory() + "/", name);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    void jToggleButton2_actionPerformed(ActionEvent e) {
        this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        System.exit(0);
    }

    void jToggleButton1_actionPerformed(ActionEvent e) {
        this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        this.game.setGameMode(1000);
        this.game.setUpGame();
        this.game.getWarWindow().updateAll(true);
        this.game.startGame(true);
    }

    void jToggleButton3_actionPerformed(ActionEvent e) {
        this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        this.setCursor(this.busyCursor);
        this.game.setGameMode(1000);
        this.game.getGameState().getTutorial().setActive(true);
        this.game.setUpGame();
        this.game.getWarWindow().updateAll(true);
        Global.SETTINGS_DATA.setVal("HAS_RUN_TUTORIAL", 1);
        this.game.startGame(true);
    }

    void jButton1_mouseEntered(MouseEvent e) {
    }

    void jButton1_mouseExited(MouseEvent e) {
    }

    void jButton2_mouseEntered(MouseEvent e) {
    }

    void jButton2_mouseExited(MouseEvent e) {
    }

    void jButton4_mouseEntered(MouseEvent e) {
    }

    void jButton4_mouseExited(MouseEvent e) {
    }

    void jButton5_mouseEntered(MouseEvent e) {
    }

    void jButton5_mouseExited(MouseEvent e) {
    }

    void jButton6_mouseEntered(MouseEvent e) {
    }

    void jButton6_mouseExited(MouseEvent e) {
    }

    void jButton3_mouseEntered(MouseEvent e) {
    }

    void jButton3_mouseExited(MouseEvent e) {
    }

    void jButton20_mouseEntered(MouseEvent e) {
    }

    void jButton20_mouseExited(MouseEvent e) {
    }

    void jToggleButton3_mouseEntered(MouseEvent e) {
    }

    void jToggleButton3_mouseExited(MouseEvent e) {
    }
}

