/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.Country;
import game.Game;
import game.Global;
import game.Research;
import game.ResearchArea;
import gui.BackgroundPanel;
import gui.LabBuyPanel_jToggleButton1_mouseAdapter;
import gui.LabBuyPanel_jToggleButton2_mouseAdapter;
import gui.LabBuyPanel_jToggleButton3_mouseAdapter;
import gui.WarWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class LabBuyPanel
extends BackgroundPanel {
    private static final long serialVersionUID = 17L;
    Game game;
    String type;
    BackgroundPanel owner;
    ResearchArea researchArea;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JToggleButton jToggleButton1 = new JToggleButton();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JToggleButton jToggleButton2 = new JToggleButton();
    JToggleButton jToggleButton3 = new JToggleButton();

    public LabBuyPanel(Game g, Image im, BackgroundPanel bp, ResearchArea ra) {
        super(im);
        this.game = g;
        this.type = ra.getName();
        this.owner = bp;
        this.researchArea = ra;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(266, 10));
        this.jPanel1.setRequestFocusEnabled(false);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.setPreferredSize(new Dimension(300, 78));
        this.setRequestFocusEnabled(false);
        this.jToggleButton1.setPreferredSize(new Dimension(94, 66));
        this.jToggleButton1.setRequestFocusEnabled(false);
        this.jToggleButton1.setBorderPainted(false);
        this.jToggleButton1.setContentAreaFilled(false);
        this.jToggleButton1.setText("");
        this.jToggleButton1.addMouseListener(new LabBuyPanel_jToggleButton1_mouseAdapter(this));
        this.jLabel1.setFont(new Font(Global.bigFontName1, 0, 24));
        this.jLabel1.setForeground(Color.white);
        this.jLabel1.setPreferredSize(new Dimension(106, 30));
        this.jLabel1.setRequestFocusEnabled(true);
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("jLabel1");
        this.jLabel2.setFont(new Font(Global.bigFontName1, 0, 24));
        this.jLabel2.setForeground(Color.white);
        this.jLabel2.setPreferredSize(new Dimension(20, 30));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setHorizontalTextPosition(11);
        this.jLabel2.setText("jLabel2");
        this.jToggleButton2.setPreferredSize(new Dimension(13, 13));
        this.jToggleButton2.setRequestFocusEnabled(false);
        this.jToggleButton2.setBorderPainted(false);
        this.jToggleButton2.setContentAreaFilled(false);
        this.jToggleButton2.setText("");
        this.jToggleButton2.addMouseListener(new LabBuyPanel_jToggleButton2_mouseAdapter(this));
        this.jToggleButton3.setPreferredSize(new Dimension(13, 13));
        this.jToggleButton3.setRequestFocusEnabled(false);
        this.jToggleButton3.setBorderPainted(false);
        this.jToggleButton3.setContentAreaFilled(false);
        this.jToggleButton3.setText("");
        this.jToggleButton3.addMouseListener(new LabBuyPanel_jToggleButton3_mouseAdapter(this));
        this.add((Component)this.jPanel1, "West");
        this.jPanel1.add((Component)this.jToggleButton1, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 0, new Insets(0, 18, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jToggleButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 0, 0, 0), 27, 0));
        this.jPanel1.add((Component)this.jToggleButton3, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 0), 27, 0));
        this.jToggleButton1.setIcon(new ImageIcon(this.researchArea.getImage(94, "")));
        this.jToggleButton1.setRolloverIcon(new ImageIcon(this.researchArea.getImage(94, "hig")));
        this.jToggleButton1.setSelectedIcon(new ImageIcon(this.researchArea.getImage(94, "sel")));
        this.jToggleButton1.setDisabledIcon(new ImageIcon(this.researchArea.getImage(94, "dis")));
        this.jToggleButton2.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_up_13.png")));
        this.jToggleButton2.setRolloverIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_up_hig_13.png")));
        this.jToggleButton2.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_up_sel_13.png")));
        this.jToggleButton2.setDisabledIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_up_dis_13.png")));
        this.jToggleButton3.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_down_13.png")));
        this.jToggleButton3.setRolloverIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_down_hig_13.png")));
        this.jToggleButton3.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_down_sel_13.png")));
        this.jToggleButton3.setDisabledIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_down_dis_13.png")));
    }

    public boolean isSelected() {
        return this.jToggleButton1.isSelected();
    }

    public void setSelected(boolean b) {
        this.jToggleButton1.setSelected(b);
    }

    public void updateAll(Research r, ResearchArea ra) {
        this.researchArea = ra;
        if (this.jToggleButton1.isSelected()) {
            this.jLabel1.setForeground(Color.white);
            this.jLabel2.setForeground(Color.white);
        } else {
            this.jLabel1.setForeground(new Color(255, 255, 255, 127));
            this.jLabel2.setForeground(new Color(255, 255, 255, 127));
        }
        this.jToggleButton1.setToolTipText(Global.getMessage(443));
        this.jToggleButton3.setToolTipText(Global.createLanguageMessage(122, new String[]{ra.getName(), "" + r.currentLabPrice() * Global.LAB_SELL_FACTOR / 100}));
        this.jToggleButton2.setSelected(false);
        this.jToggleButton3.setSelected(false);
        this.jLabel1.setText(ra.getName());
        this.jLabel2.setText("" + ra.getLabs());
        Country c = r.getCountry();
        Research t = c.getResearch();
        if (t.getNumLabs() >= c.getMaxLabs()) {
            this.jToggleButton2.setEnabled(false);
            this.jToggleButton2.setToolTipText(Global.getMessage(83));
        } else if (ra.getLabs() > t.getNumLabs() / 2) {
            this.jToggleButton2.setEnabled(false);
            this.jToggleButton2.setToolTipText(Global.getMessage(82));
        } else if (c.getPP() < (double)t.currentLabPrice()) {
            this.jToggleButton2.setEnabled(false);
            this.jToggleButton2.setToolTipText(Global.getMessage(429));
        } else {
            this.jToggleButton2.setEnabled(true);
            this.jToggleButton2.setToolTipText(Global.createLanguageMessage(121, new String[]{ra.getName(), "" + r.currentLabPrice()}));
        }
        if (ra.getLabs() > 0) {
            this.jToggleButton3.setEnabled(true);
        } else {
            this.jToggleButton3.setEnabled(false);
        }
    }

    void jToggleButton2_mousePressed(MouseEvent e) {
    }

    void jToggleButton3_mousePressed(MouseEvent e) {
    }

    void jToggleButton1_mouseReleased(MouseEvent e) {
        this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        this.owner.updateAll(false);
    }

    void jToggleButton2_mouseReleased(MouseEvent e) {
        if (this.jToggleButton2.isEnabled()) {
            this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
            this.researchArea.getResearch().doAction(10, this.researchArea, false, true);
            this.owner.updateAll(false);
            this.researchArea.getResearch().getCountry().getGame().setTutorialMessage(19);
        }
    }

    void jToggleButton3_mouseReleased(MouseEvent e) {
        if (this.jToggleButton3.isEnabled()) {
            this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
            WarWindow ww = this.researchArea.getResearch().getCountry().getGame().getWarWindow();
            Research r = this.researchArea.getResearch();
            ww.showYesNoDialog(Global.createLanguageMessage(105, new String[]{"" + Global.LAB_SELL_FACTOR * r.currentLabPrice() / 100}));
            if (ww.yesNoDialog.yesSelected()) {
                this.researchArea.getResearch().doAction(20, this.researchArea, false, true);
                this.owner.updateAll(false);
            }
        }
    }
}

