/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.Country;
import game.Game;
import game.Global;
import game.hex.Hex;
import game.hex.LandHex;
import game.p_resource.PResource;
import game.terrain.Terrain;
import gui.BackgroundPanel;
import gui.HexInfoPanel_jToggleButton1_actionAdapter;
import gui.HexInfoPanel_jToggleButton1_mouseAdapter;
import gui.HexInfoPanel_jToggleButton2_actionAdapter;
import gui.HexInfoPanel_jToggleButton2_mouseAdapter;
import gui.LabelledIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class HexInfoPanel
extends BackgroundPanel {
    private static final long serialVersionUID = 15L;
    Game game;
    Hex currentHex;
    boolean enemyPanel;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    LabelledIcon jPanel4;
    LabelledIcon jPanel5;
    LabelledIcon jPanel6;
    LabelledIcon jPanel7;
    LabelledIcon jPanel8;
    LabelledIcon jPanel9;
    JPanel jPanel10 = new JPanel();
    JPanel jPanel11 = new JPanel();
    JPanel jPanel12 = new JPanel();
    JPanel jPanel13 = new JPanel();
    JPanel jPanel16 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel17 = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel14 = new JPanel();
    JPanel jPanel15 = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel jLabel9 = new JLabel();
    JLabel jLabel10 = new JLabel();
    JLabel jLabel11 = new JLabel();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JPanel jPanel25 = new JPanel();
    JPanel jPanel26 = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    JToggleButton jToggleButton1 = new JToggleButton();
    JToggleButton jToggleButton2 = new JToggleButton();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JLabel jLabel12 = new JLabel();

    public HexInfoPanel(Game g, Image im, boolean enemy) {
        super(im);
        this.game = g;
        this.enemyPanel = enemy;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reset() {
    }

    public void showHex(Hex u) {
        this.currentHex = u;
        if (u != null) {
            if (this.game.whosTurn() == 200) {
                this.game.getCountry(2);
            }
            if (u instanceof LandHex) {
                this.game.getCountry(u.getOwningCountry());
            }
            String s = "01";
            if (this.game.whosTurn() == 100) {
                this.setbgImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "unit_" + "01" + "_axis.png"));
            } else {
                this.setbgImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "unit_" + "01" + "_allies.png"));
            }
            this.updateAll();
            this.updateUI();
        }
    }

    public Hex getCurrentHex() {
        return this.currentHex;
    }

    public void updateAll() {
        Hex h = this.currentHex;
        PResource r = h.getPResource();
        Terrain t = h.getTerrain();
        int hexIndex = this.game.getHexIndex(h);
        this.jToggleButton1.setEnabled(false);
        if (h.getUnit() != null && this.game.canSeeUnit(h.getUnit(), this.game.playerSide())) {
            this.jToggleButton1.setEnabled(true);
        }
        Country owningCountry = this.game.getCountry(h.getOwningCountry());
        Country coreOwningCountry = null;
        if (h instanceof LandHex) {
            coreOwningCountry = this.game.getCountry(h.getCoreOwningCountry());
        }
        if (r != null) {
            this.jPanel4.setLabel("" + h.basicMovementCost());
            this.jPanel5.setLabel("" + h.vehicleMovementPenalty());
            this.jPanel6.setLabel("" + (100 - (int)(100.0 * r.getDefenceBonusModifier())));
            this.jPanel7.setLabel("" + (100 - (int)(100.0 * r.getTankPenaltyModifier())));
            this.jPanel8.setLabel("" + r.getAirCombat(owningCountry));
            this.jPanel9.setLabel("" + r.getSurvivability(owningCountry));
            double fraction = (double)r.getStrength() / (double)r.maxStrength();
            this.jLabel1.setText(r.getTypeName());
            this.jLabel7.setText(h.getHexName());
            this.jLabel8.setText(owningCountry.getName());
            this.jLabel9.setText("");
            if (coreOwningCountry != null) {
                this.jLabel9.setText("(" + coreOwningCountry.getOwningName() + ")");
            }
            this.jLabel10.setText(r.getPP() + "/" + r.getMaxProduction());
            this.jLabel10.setForeground(this.game.intervalColor(fraction, true));
            this.jLabel11.setText(this.game.getColumn(hexIndex) + ", " + this.game.getRow(hexIndex));
        } else {
            this.jPanel4.setLabel("" + h.basicMovementCost());
            this.jPanel5.setLabel("" + h.vehicleMovementPenalty());
            this.jPanel6.setLabel("" + (100 - (int)(100.0 * t.getDefenceBonusModifier())));
            this.jPanel7.setLabel("" + (100 - (int)(100.0 * t.getTankPenaltyModifier())));
            this.jPanel8.setLabel("0");
            this.jPanel9.setLabel("0");
            if (h instanceof LandHex) {
                this.jLabel1.setText(t.getTypeName());
            } else {
                this.jLabel1.setText(Global.getMessage(294));
            }
            this.jLabel7.setText(h.getHexName());
            this.jLabel8.setText("");
            if (h instanceof LandHex) {
                this.jLabel8.setText(owningCountry.getName());
            }
            this.jLabel9.setText("");
            if (h instanceof LandHex) {
                this.jLabel9.setText("(" + coreOwningCountry.getOwningName() + ")");
            }
            this.jLabel10.setText("");
            this.jLabel11.setText(this.game.getColumn(hexIndex) + ", " + this.game.getRow(hexIndex));
        }
        this.jLabel12.setIcon(new ImageIcon(h.getImage()));
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(462, 10));
        this.setLayout(this.borderLayout1);
        this.jPanel4 = new LabelledIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "icon_mov_cost.png"), Global.getMessage(421));
        this.jPanel5 = new LabelledIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "icon_veh_pen.png"), Global.getMessage(422));
        this.jPanel6 = new LabelledIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "icon_att_pen.png"), Global.getMessage(423));
        this.jPanel7 = new LabelledIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "icon_arm_pen.png"), Global.getMessage(424));
        this.jPanel8 = new LabelledIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "icon_air_def.png"), Global.getMessage(425));
        this.jPanel9 = new LabelledIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "icon_sur.png"), Global.getMessage(388));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(10, 56));
        this.jPanel1.setToolTipText("");
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jPanel2.setOpaque(false);
        this.jPanel2.setPreferredSize(new Dimension(216, 10));
        this.jPanel2.setLayout(this.gridBagLayout5);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(this.borderLayout3);
        this.jPanel4.setPreferredSize(new Dimension(33, 45));
        this.jPanel5.setPreferredSize(new Dimension(33, 45));
        this.jPanel6.setPreferredSize(new Dimension(33, 45));
        this.jPanel7.setPreferredSize(new Dimension(33, 45));
        this.jPanel8.setPreferredSize(new Dimension(33, 45));
        this.jPanel9.setPreferredSize(new Dimension(33, 45));
        this.jPanel10.setOpaque(false);
        this.jPanel10.setPreferredSize(new Dimension(33, 45));
        this.jPanel11.setOpaque(false);
        this.jPanel11.setPreferredSize(new Dimension(33, 45));
        this.jPanel12.setOpaque(false);
        this.jPanel12.setPreferredSize(new Dimension(33, 45));
        this.jPanel13.setOpaque(false);
        this.jPanel13.setPreferredSize(new Dimension(33, 45));
        this.jPanel16.setOpaque(false);
        this.jPanel16.setPreferredSize(new Dimension(10, 56));
        this.jPanel16.setLayout(this.borderLayout2);
        this.jPanel17.setOpaque(false);
        this.jPanel17.setPreferredSize(new Dimension(112, 10));
        this.jPanel17.setLayout(this.gridBagLayout2);
        this.jPanel14.setOpaque(false);
        this.jPanel14.setPreferredSize(new Dimension(10, 36));
        this.jPanel14.setLayout(this.gridBagLayout4);
        this.jPanel15.setOpaque(false);
        this.jPanel15.setLayout(this.gridBagLayout3);
        this.jLabel2.setFont(new Font(Global.smallFontName1, 1, 14));
        this.jLabel2.setForeground(new Color(0, 0, 0, 127));
        this.jLabel2.setPreferredSize(new Dimension(100, 15));
        this.jLabel2.setHorizontalAlignment(2);
        this.jLabel2.setHorizontalTextPosition(10);
        this.jLabel2.setText(Global.getMessage(353));
        this.jLabel3.setFont(new Font(Global.smallFontName1, 1, 14));
        this.jLabel3.setForeground(new Color(0, 0, 0, 127));
        this.jLabel3.setPreferredSize(new Dimension(100, 15));
        this.jLabel3.setHorizontalAlignment(2);
        this.jLabel3.setHorizontalTextPosition(10);
        this.jLabel3.setText(Global.getMessage(354));
        this.jLabel4.setFont(new Font(Global.smallFontName1, 1, 14));
        this.jLabel4.setForeground(new Color(0, 0, 0, 127));
        this.jLabel4.setPreferredSize(new Dimension(100, 15));
        this.jLabel4.setToolTipText("");
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setHorizontalTextPosition(10);
        this.jLabel4.setText(Global.getMessage(355));
        this.jLabel5.setFont(new Font(Global.smallFontName1, 1, 14));
        this.jLabel5.setForeground(new Color(0, 0, 0, 127));
        this.jLabel5.setPreferredSize(new Dimension(100, 15));
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setHorizontalTextPosition(10);
        this.jLabel5.setText(Global.getMessage(356));
        this.jLabel6.setFont(new Font(Global.smallFontName1, 1, 14));
        this.jLabel6.setForeground(new Color(0, 0, 0, 127));
        this.jLabel6.setPreferredSize(new Dimension(100, 15));
        this.jLabel6.setHorizontalAlignment(2);
        this.jLabel6.setHorizontalTextPosition(10);
        this.jLabel6.setText(Global.getMessage(357));
        this.jLabel7.setFont(new Font(Global.smallFontName1, 1, 14));
        this.jLabel7.setPreferredSize(new Dimension(120, 15));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setHorizontalTextPosition(4);
        this.jLabel7.setText("jLabel7");
        this.jLabel8.setFont(new Font(Global.smallFontName1, 1, 14));
        this.jLabel8.setPreferredSize(new Dimension(120, 15));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setHorizontalTextPosition(4);
        this.jLabel8.setText("jLabel8");
        this.jLabel9.setFont(new Font(Global.smallFontName1, 1, 14));
        this.jLabel7.setForeground(new Color(0, 0, 0, 127));
        this.jLabel8.setForeground(new Color(0, 0, 0, 127));
        this.jLabel9.setForeground(new Color(0, 0, 0, 127));
        this.jLabel10.setForeground(new Color(0, 0, 0, 127));
        this.jLabel11.setForeground(new Color(0, 0, 0, 127));
        this.jLabel9.setPreferredSize(new Dimension(120, 15));
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setHorizontalTextPosition(4);
        this.jLabel9.setText("jLabel9");
        this.jLabel10.setFont(new Font(Global.smallFontName1, 1, 14));
        this.jLabel10.setPreferredSize(new Dimension(120, 15));
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setHorizontalTextPosition(4);
        this.jLabel10.setText("jLabel10");
        this.jLabel11.setFont(new Font(Global.smallFontName1, 1, 14));
        this.jLabel11.setPreferredSize(new Dimension(120, 15));
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setHorizontalTextPosition(4);
        this.jLabel11.setText("jLabel11");
        this.jLabel1.setFont(new Font(Global.bigFontName1, 0, 24));
        this.jLabel1.setForeground(new Color(0, 0, 0, 89));
        this.jLabel1.setPreferredSize(new Dimension(164, 26));
        this.jLabel1.setText("jLabel1");
        this.jPanel25.setOpaque(false);
        this.jPanel26.setOpaque(false);
        this.jPanel26.setLayout(this.borderLayout6);
        this.jToggleButton1.setPreferredSize(new Dimension(26, 26));
        this.jToggleButton1.setRequestFocusEnabled(false);
        this.jToggleButton1.setToolTipText(Global.getMessage(255));
        this.jToggleButton1.setBorderPainted(false);
        this.jToggleButton1.setContentAreaFilled(false);
        this.jToggleButton1.setText("");
        this.jToggleButton1.addActionListener(new HexInfoPanel_jToggleButton1_actionAdapter(this));
        this.jToggleButton1.addMouseListener(new HexInfoPanel_jToggleButton1_mouseAdapter(this));
        this.jToggleButton2.setEnabled(false);
        this.jToggleButton2.setPreferredSize(new Dimension(26, 26));
        this.jToggleButton2.setRequestFocusEnabled(false);
        this.jToggleButton2.setToolTipText(Global.getMessage(261));
        this.jToggleButton2.setBorderPainted(false);
        this.jToggleButton2.setContentAreaFilled(false);
        this.jToggleButton2.setSelected(true);
        this.jToggleButton2.setText("");
        this.jToggleButton2.addActionListener(new HexInfoPanel_jToggleButton2_actionAdapter(this));
        this.jToggleButton2.addMouseListener(new HexInfoPanel_jToggleButton2_mouseAdapter(this));
        this.jLabel12.setPreferredSize(new Dimension(201, 108));
        this.jLabel12.setText("");
        this.jPanel1.add((Component)this.jPanel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 6, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel5, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel6, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel7, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel8, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel9, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel10, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel11, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel12, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel13, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 0), 0, 0));
        this.jPanel26.add((Component)this.jPanel2, "West");
        this.jPanel2.add((Component)this.jLabel12, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 12, 0, 0), 0, 0));
        if (this.enemyPanel) {
            this.add((Component)this.jPanel25, "East");
        }
        this.add((Component)this.jPanel26, "Center");
        this.jPanel26.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jPanel14, "North");
        this.jPanel14.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.jPanel14.add((Component)this.jToggleButton1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 4, 0, 0), 0, 0));
        this.jPanel14.add((Component)this.jToggleButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 2, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jPanel15, "Center");
        this.jPanel15.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel15.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel15.add((Component)this.jLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel15.add((Component)this.jLabel5, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel15.add((Component)this.jLabel6, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel15.add((Component)this.jLabel7, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.jPanel15.add((Component)this.jLabel8, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.jPanel15.add((Component)this.jLabel9, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.jPanel15.add((Component)this.jLabel10, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.jPanel15.add((Component)this.jLabel11, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.jPanel26.add((Component)this.jPanel16, "South");
        this.jPanel16.add((Component)this.jPanel17, "East");
        this.jPanel16.add((Component)this.jPanel1, "Center");
        this.jToggleButton1.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "unit_26.png")));
        this.jToggleButton1.setRolloverIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "unit_hig_26.png")));
        this.jToggleButton1.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "unit_sel_26.png")));
        this.jToggleButton1.setDisabledIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "unit_dis_26.png")));
        this.jToggleButton2.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "terrain_26.png")));
        this.jToggleButton2.setRolloverIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "terrain_hig_26.png")));
        this.jToggleButton2.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "terrain_sel_26.png")));
        this.jToggleButton2.setDisabledIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "terrain_dis_26.png")));
    }

    void jLabel14_actionPerformed(ActionEvent e) {
    }

    void jButton2_actionPerformed(ActionEvent e) {
    }

    void jButton1_actionPerformed(ActionEvent e) {
    }

    void jToggleButton1_mouseReleased(MouseEvent e) {
    }

    void jToggleButton2_mouseReleased(MouseEvent e) {
    }

    void jToggleButton1_actionPerformed(ActionEvent e) {
        this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        this.jToggleButton1.setSelected(true);
        this.jToggleButton2.setSelected(false);
        this.game.getWarWindow().showBelowPanels(1, this.currentHex.getUnit(), null, null, true);
    }

    void jToggleButton2_actionPerformed(ActionEvent e) {
        this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
        this.jToggleButton2.setSelected(true);
        this.jToggleButton1.setSelected(false);
    }
}

