/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.Country;
import game.Game;
import game.Global;
import gui.BackgroundPanel;
import gui.FlagSelectionPanel_jToggleButton1_mouseAdapter;
import gui.FlagSelectionPanel_jToggleButton2_mouseAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class FlagSelectionPanel
extends BackgroundPanel {
    private static final long serialVersionUID = 10L;
    BackgroundPanel owner;
    Game game;
    Vector<Country> countries = new Vector(5, 1);
    private int selectedIndex = 0;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JToggleButton jToggleButton1 = new JToggleButton();
    JToggleButton jToggleButton2 = new JToggleButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JLabel flagLabel = new JLabel();

    public FlagSelectionPanel(Image im, Game g, BackgroundPanel pp) {
        super(im);
        this.game = g;
        this.owner = pp;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(160, 10));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jToggleButton1.setPreferredSize(new Dimension(12, 20));
        this.jToggleButton1.setRequestFocusEnabled(false);
        this.jToggleButton1.setBorderPainted(false);
        this.jToggleButton1.setContentAreaFilled(false);
        this.jToggleButton1.setText("");
        this.jToggleButton1.addMouseListener(new FlagSelectionPanel_jToggleButton1_mouseAdapter(this));
        this.jToggleButton2.setPreferredSize(new Dimension(12, 20));
        this.jToggleButton2.setRequestFocusEnabled(false);
        this.jToggleButton2.setBorderPainted(false);
        this.jToggleButton2.setContentAreaFilled(false);
        this.jToggleButton2.addMouseListener(new FlagSelectionPanel_jToggleButton2_mouseAdapter(this));
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.setOpaque(false);
        this.jLabel2.setPreferredSize(new Dimension(50, 25));
        this.jLabel2.setToolTipText(Global.getMessage(346));
        this.jLabel3.setPreferredSize(new Dimension(44, 25));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setHorizontalTextPosition(11);
        this.jLabel3.setText("jLabel3");
        this.jLabel4.setPreferredSize(new Dimension(50, 25));
        this.jLabel4.setToolTipText(Global.getMessage(347));
        this.jLabel5.setPreferredSize(new Dimension(44, 25));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setHorizontalTextPosition(11);
        this.jLabel5.setText("jLabel5");
        this.jLabel6.setPreferredSize(new Dimension(50, 25));
        this.jLabel6.setToolTipText(Global.getMessage(348));
        this.jLabel7.setPreferredSize(new Dimension(44, 25));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setHorizontalTextPosition(11);
        this.jLabel7.setText("jLabel7");
        this.flagLabel.setPreferredSize(new Dimension(98, 74));
        this.add((Component)this.jPanel1, "West");
        this.jPanel1.add((Component)this.jToggleButton1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jToggleButton2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.flagLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jLabel3, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.jPanel2.add((Component)this.jLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jLabel5, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.jPanel2.add((Component)this.jLabel6, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jLabel7, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.jLabel2.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "resource_industry.png")));
        this.jLabel4.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "resource_manpower.png")));
        this.jLabel6.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "resource_oil.png")));
    }

    public Country getSelectedCountry() {
        if (this.countries.size() == 0) {
            return null;
        }
        return this.countries.get(this.selectedIndex);
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void updateAll(boolean pickFirstCountry) {
        if (pickFirstCountry) {
            this.selectedIndex = 0;
        }
        boolean oilCons = this.game.getGameState().getOilConsumption();
        this.countries.removeAllElements();
        Country[] coun = this.game.getCountries();
        int i = 0;
        while (i < coun.length) {
            if (coun[i].majorAliveFriendly(this.game.whosTurn())) {
                this.countries.add(coun[i]);
            }
            ++i;
        }
        Country c = this.getSelectedCountry();
        if (c != null) {
            this.jToggleButton1.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_left_12.png")));
            this.jToggleButton1.setRolloverIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_left_hig_12.png")));
            this.jToggleButton1.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_left_sel_12.png")));
            this.jToggleButton1.setDisabledIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_left_dis_12.png")));
            this.jToggleButton2.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_right_12.png")));
            this.jToggleButton2.setRolloverIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_right_hig_12.png")));
            this.jToggleButton2.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_right_sel_12.png")));
            this.jToggleButton2.setDisabledIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "arrow_right_dis_12.png")));
            this.flagLabel.setIcon(new ImageIcon(c.getFlag(98, "")));
            this.jLabel3.setText("" + (int)c.getPP());
            this.jLabel3.setForeground(this.game.shortageColor((int)c.getPP(), false));
            this.jLabel5.setText("" + ((int)c.getManpower() - (int)(0.0 * c.realManpowerCap())));
            this.jLabel5.setForeground(this.game.manpowerColor(c.getManpowerFraction(), false));
            this.jLabel5.setToolTipText(c.manpowerString());
            if (oilCons) {
                this.jLabel7.setText("" + Math.min(999, (int)c.getOil()));
            } else {
                this.jLabel7.setText("---");
            }
            this.jLabel7.setForeground(this.game.shortageColor((int)c.getOil(), false));
        }
    }

    public void changeflag(int change) {
        int numFlags = this.countries.size();
        this.selectedIndex += change;
        if (this.selectedIndex > numFlags - 1) {
            this.selectedIndex -= numFlags;
        }
        if (this.selectedIndex < 0) {
            this.selectedIndex += numFlags;
        }
        this.owner.updateAll(false);
    }

    void jToggleButton1_mousePressed(MouseEvent e) {
    }

    void jToggleButton2_mousePressed(MouseEvent e) {
    }

    void jToggleButton1_mouseReleased(MouseEvent e) {
        if (this.jToggleButton1.isEnabled()) {
            this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
            this.changeflag(-1);
            this.jToggleButton1.setSelected(false);
        }
    }

    void jToggleButton2_mouseReleased(MouseEvent e) {
        if (this.jToggleButton2.isEnabled()) {
            this.game.playSoundSimultaneously(String.valueOf(Global.getSoundPath()) + "click.wav", 0, false);
            this.changeflag(1);
            this.jToggleButton2.setSelected(false);
        }
    }
}

