/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.Game;
import game.Global;
import game.OddsAndPenalties;
import gui.BackgroundPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CombatPanel
extends BackgroundPanel {
    private static final long serialVersionUID = 8L;
    Game game;
    ImageIcon riverIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "combat_river.png"));
    ImageIcon terrainIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "combat_terrain.png"));
    ImageIcon entrenchmentIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + "combat_entrenchment.png"));
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel3 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel jLabel9 = new JLabel();

    public CombatPanel(Game g, Image im) {
        super(im);
        this.game = g;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateAll(OddsAndPenalties odds) {
        if (this.game.whosTurn() == 100) {
            this.setbgImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "combat_axis.png"));
        } else {
            this.setbgImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "combat_allies.png"));
        }
        this.jLabel1.setText("");
        this.jLabel2.setText("");
        this.jLabel3.setText("");
        this.jLabel4.setIcon(null);
        this.jLabel5.setText("");
        this.jLabel6.setIcon(null);
        this.jLabel7.setText("");
        this.jLabel8.setIcon(null);
        this.jLabel9.setText("");
        if (odds != null) {
            int val = odds.getAttackerBattleOdds2();
            if (val == -99) {
                this.jLabel1.setText("");
            } else if (val < -15) {
                this.jLabel1.setText("----");
            } else if (val <= 0) {
                this.jLabel1.setText("0");
            } else {
                this.jLabel1.setText("" + val);
            }
            val = odds.getDefenderBattleOdds2();
            if (val == -99) {
                this.jLabel3.setText("");
            } else if (val < -15) {
                this.jLabel3.setText("----");
            } else if (val <= 0) {
                this.jLabel3.setText("0");
            } else {
                this.jLabel3.setText("" + val);
            }
            this.jLabel2.setText(":");
            if (odds.getRiverEfficiency() != 1.0) {
                this.jLabel4.setIcon(this.riverIcon);
                this.jLabel5.setText("-" + (100 - (int)(odds.getRiverEfficiency() * 100.0)) + "%");
            }
            if (odds.getTerrainEfficiency() != 1.0) {
                this.jLabel6.setIcon(this.terrainIcon);
                this.jLabel7.setText("-" + (100 - (int)(odds.getTerrainEfficiency() * 100.0)) + "%");
            }
            if (odds.getEntrenchmentEfficiency() != 1.0) {
                this.jLabel8.setIcon(this.entrenchmentIcon);
                this.jLabel9.setText("-" + (100 - (int)(odds.getEntrenchmentEfficiency() * 100.0)) + "%");
            }
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(10, 116));
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(this.gridBagLayout1);
        this.jLabel1.setFont(new Font(Global.bigFontName1, 0, 40));
        this.jLabel1.setForeground(Color.white);
        this.jLabel1.setToolTipText("");
        this.jLabel1.setText(" ");
        this.jLabel2.setFont(new Font(Global.bigFontName1, 0, 40));
        this.jLabel2.setForeground(Color.white);
        this.jLabel2.setText(":");
        this.jLabel3.setFont(new Font(Global.bigFontName1, 0, 40));
        this.jLabel3.setForeground(Color.white);
        this.jLabel3.setToolTipText("");
        this.jLabel3.setText(" ");
        this.jLabel4.setFont(new Font("Arial", 0, 14));
        this.jLabel4.setForeground(Color.white);
        this.jLabel4.setPreferredSize(new Dimension(36, 36));
        this.jLabel5.setFont(new Font("Arial", 0, 14));
        this.jLabel5.setForeground(Color.white);
        this.jLabel5.setPreferredSize(new Dimension(36, 36));
        this.jLabel6.setFont(new Font("Arial", 0, 14));
        this.jLabel6.setForeground(Color.white);
        this.jLabel6.setPreferredSize(new Dimension(36, 36));
        this.jLabel7.setFont(new Font("Arial", 0, 14));
        this.jLabel7.setForeground(Color.white);
        this.jLabel7.setPreferredSize(new Dimension(36, 36));
        this.jLabel8.setFont(new Font("Arial", 0, 14));
        this.jLabel8.setForeground(Color.white);
        this.jLabel8.setPreferredSize(new Dimension(36, 36));
        this.jLabel9.setFont(new Font("Arial", 0, 14));
        this.jLabel9.setForeground(Color.white);
        this.jLabel9.setPreferredSize(new Dimension(36, 36));
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(14, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel5, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(14, 8, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel6, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel7, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel8, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel9, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jLabel3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

