/*
 * Decompiled with CFR 0.152.
 */
package game.unit;

import game.Country;
import game.Game;
import game.Global;
import game.Research;
import game.TechLevels;
import game.Technology;
import game.UnitAttributes;
import game.XRandAndCalc;
import game.hex.Hex;
import game.p_resource.PResource;
import game.terrain.Desert;
import game.terrain.Dune;
import game.terrain.Terrain;
import game.unit.AirUnit;
import game.unit.Commander;
import game.unit.Convoy;
import game.unit.GroundUnit;
import game.unit.NavalUnit;
import game.unit.Transport;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.Serializable;

public abstract class Unit
implements Serializable {
    private static final long serialVersionUID = 126L;
    public int testImageLevel = -1;
    int leftFlank = XRandAndCalc.randZero(20) - 10;
    Commander commander;
    Commander rangedCommander;
    protected boolean FOWed = false;
    protected boolean invisible = false;
    TechLevels techLevels;
    int upgradesHeld = 0;
    boolean canUpgrade = false;
    boolean sentry = false;
    int maxUpgrades = 0;
    protected String image;
    protected Country country;
    protected Hex onHex;
    protected Hex destinationHex;
    protected Hex wayPoint;
    protected Hex chasePoint;
    protected int xOffset;
    protected int yOffset;
    protected String className;
    protected String typeName;
    protected String individualName;
    protected double aggressiveness = 1.0;
    protected int maxEntrenchment = 99;
    protected int price;
    protected int manpower;
    protected int oilConsumption;
    protected int turnsBeforeComplete;
    protected int maxMovement;
    protected int attackRange;
    protected int landSpotting;
    protected int seaSpotting;
    protected int groundAttack;
    protected int groundDefence;
    protected int shockAttack;
    protected int airCombat;
    protected int navalCombat;
    protected int subCombat;
    protected int strategicAttack;
    protected double quality;
    protected double survivability;
    protected int antiTankBonus;
    protected int strength = 10;
    protected int morale;
    protected double supply;
    protected double experience;
    protected int entrenchment;
    protected boolean hasMoved = true;
    protected boolean hasRaided = false;
    protected double reinforceCostFactor;
    protected int zoomLevel;
    double startQuality;
    double startSurvivability;

    Unit(Country countryP, int pricee, int manpow, int oilConsum, int turnsComp, int movementP, int attackRangeP, int landSpot, int seaSpot, int groundAtt, int groundDef, int shockAtt, int airComb, int navalComb, int subComb, int stratAtt, int qual, int surviv, int antiTank) {
        this.country = countryP;
        this.price = pricee;
        this.manpower = manpow;
        this.oilConsumption = oilConsum;
        this.turnsBeforeComplete = turnsComp;
        this.maxMovement = movementP;
        this.attackRange = attackRangeP;
        this.landSpotting = landSpot;
        this.seaSpotting = seaSpot;
        this.groundAttack = groundAtt;
        this.groundDefence = groundDef;
        this.shockAttack = shockAtt;
        this.airCombat = airComb;
        this.navalCombat = navalComb;
        this.subCombat = subComb;
        this.strategicAttack = stratAtt;
        this.quality = qual;
        this.survivability = surviv;
        this.antiTankBonus = antiTank;
        this.techLevels = new TechLevels();
    }

    public void setSentry(boolean b) {
        this.sentry = b;
    }

    public boolean getSentry() {
        return this.sentry;
    }

    public void updateLeftFlank() {
        int rnd = XRandAndCalc.rand(5);
        switch (rnd) {
            case 1: {
                this.leftFlank -= 2;
                break;
            }
            case 2: {
                --this.leftFlank;
                break;
            }
            case 4: {
                ++this.leftFlank;
                break;
            }
            case 5: {
                this.leftFlank += 2;
            }
        }
        this.leftFlank = Math.min(10, this.leftFlank);
        this.leftFlank = Math.max(-10, this.leftFlank);
    }

    public int getLeftFlank() {
        return this.leftFlank;
    }

    public String toolTipText1() {
        return this.typeName;
    }

    protected void setAttributes(String clasName) {
        int unitIndex = -1;
        UnitAttributes ua = Global.UNIT_ATTRIBUTES;
        int i = 0;
        while (i < ua.numColumns()) {
            if (ua.getClassName(i).compareTo(clasName) == 0) {
                unitIndex = i;
                break;
            }
            ++i;
        }
        if (unitIndex != -1) {
            this.price = ua.getValue(unitIndex, 0);
            this.manpower = ua.getValue(unitIndex, 1);
            this.turnsBeforeComplete = ua.getValue(unitIndex, 2);
            this.maxMovement = ua.getValue(unitIndex, 3);
            this.attackRange = ua.getValue(unitIndex, 4);
            this.landSpotting = ua.getValue(unitIndex, 5);
            this.seaSpotting = ua.getValue(unitIndex, 6);
            this.groundAttack = ua.getValue(unitIndex, 7);
            this.groundDefence = ua.getValue(unitIndex, 8);
            this.shockAttack = ua.getValue(unitIndex, 9);
            this.airCombat = ua.getValue(unitIndex, 10);
            this.navalCombat = ua.getValue(unitIndex, 11);
            this.subCombat = ua.getValue(unitIndex, 12);
            this.strategicAttack = ua.getValue(unitIndex, 13);
            this.quality = ua.getValue(unitIndex, 14);
            this.survivability = ua.getValue(unitIndex, 15);
            this.antiTankBonus = ua.getValue(unitIndex, 16);
            this.oilConsumption = ua.getValue(unitIndex, 17);
            this.image = ua.getIcongraphic(unitIndex);
            this.individualName = this.typeName;
        }
        this.startQuality = this.quality;
        this.startSurvivability = this.survivability;
        if (!(this instanceof Commander)) {
            this.quality -= (double)Unit.qualityManpowerPenalty(this.country);
        }
        this.survivability -= (double)Unit.survivabilityManpowerPenalty(this.country);
        this.supply = this instanceof NavalUnit ? (double)Global.MAX_SUPPLY : (double)Global.HALF_SUPPLY;
        this.strength = this.maxStrength();
        this.morale = this.maxMorale();
    }

    public void setMaxUpgrades(int i) {
        this.maxUpgrades = i;
    }

    public int getMaxUpgrades() {
        return this.maxUpgrades;
    }

    public int getUpgradesHeld() {
        return this.upgradesHeld;
    }

    public void setUpgradesHeld(int i) {
        this.upgradesHeld = i;
    }

    public TechLevels getTechLevels() {
        return this.techLevels;
    }

    public boolean canUpgrade() {
        if (this.getGame().countryInCharge(this.getCountry()).getPP() < (double)(-Global.MAX_DEFICIT_BEFORE_SPENDING_STOP)) {
            return false;
        }
        if (this.country.getGame().enemiesAdjacent(this.country.getGame().getHexIndex(this.onHex), this) > 0) {
            return false;
        }
        return this.getUpgradesHeld() < this.country.getUpgradesHeld(this) && this.supply > 0.0;
    }

    public double upgradeCost() {
        return (double)Global.UPGRADE_MINIMUM_COST + 0.01 * (double)this.price * (double)Global.UPGRADE_FRACTION_COST;
    }

    public void upgradeUnit(boolean penalties) {
        Technology[] t = this.getCountry().getResearch().getTechs();
        this.setTechLevels(t[0].getLevel(), t[1].getLevel(), t[2].getLevel(), t[3].getLevel(), t[4].getLevel(), t[5].getLevel(), t[6].getLevel(), t[7].getLevel(), t[8].getLevel(), t[9].getLevel(), t[10].getLevel(), t[11].getLevel(), t[12].getLevel(), t[13].getLevel(), t[14].getLevel());
        this.setMaxUpgrades(this.country.getMaxUpgrades(this));
        this.setUpgradesHeld(this.country.getUpgradesHeld(this));
        if (penalties) {
            this.getCountry().payPP(this.upgradeCost());
            this.setHasMoved(true);
            this.changeMorale(-Global.UPGRADE_EFFICIENCY_LOSS);
        }
    }

    public void setTechLevels(int a, int b, int c, int d, int e, int f, int g, int h, int i, int j, int k, int l, int m, int n, int o) {
        this.techLevels.setTechLevels(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
    }

    public static int survivabilityManpowerPenalty(Country c) {
        int ret = 0;
        double d = c.getManpowerFraction();
        if (d < 0.5) {
            ++ret;
        }
        if (d < 0.0) {
            ++ret;
        }
        return ret;
    }

    public static int qualityManpowerPenalty(Country c) {
        int ret = 0;
        double d = c.getManpowerFraction();
        if (d < 0.75) {
            ++ret;
        }
        if (d < 0.25) {
            ++ret;
        }
        return ret;
    }

    public boolean isAtWar() {
        return this.country.getAtWar();
    }

    public Game getGame() {
        return this.country.getGame();
    }

    public void setCommander(Commander c) {
        this.commander = c;
    }

    public void setRangedCommander(Commander c) {
        this.rangedCommander = c;
    }

    public Commander getCommander() {
        return this.commander;
    }

    public Commander getRangedCommander() {
        return this.rangedCommander;
    }

    public boolean getFOWed() {
        return this.FOWed;
    }

    public void setFOWed(boolean b) {
        this.FOWed = b;
    }

    public int zocPenalty() {
        return 0;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean b) {
        this.invisible = b;
        if (!this.invisible) {
            this.FOWed = false;
        }
    }

    public int maxExperience() {
        return 100;
    }

    public void setDestinationHex(Hex h) {
        if (h != this.getDestinationHex()) {
            this.destinationHex = h;
            this.wayPoint = null;
        }
    }

    public void setWayPoint(Hex h) {
        this.wayPoint = h;
    }

    public void setChasePoint(Hex h) {
        if (!this.onDefenceMission()) {
            this.chasePoint = h;
        }
    }

    public boolean isVehicle() {
        return false;
    }

    public boolean isArmour() {
        return false;
    }

    public Hex getDestinationHex() {
        return this.destinationHex;
    }

    public Hex getWayPoint() {
        return this.wayPoint;
    }

    public Hex getChasePoint() {
        return this.chasePoint;
    }

    public void incExperience(int val) {
        this.experience += (double)val;
        if (this.experience > (double)this.maxExperience()) {
            this.experience = this.maxExperience();
        }
    }

    public int getEntrenchment() {
        return this.entrenchment;
    }

    public void setEntrenchment(int val) {
        this.entrenchment = val;
    }

    public void incEntrenchment() {
        if (this.entrenchment < this.getMaxEntrenchment()) {
            ++this.entrenchment;
        }
    }

    public int getMaxEntrenchment() {
        return Math.min(this.maxEntrenchment, this.onHex.getMaxEntrenchment());
    }

    public void decEntrenchment() {
        if (this.entrenchment > 0) {
            --this.entrenchment;
        }
    }

    public int maxMorale() {
        Research research = this.country.getResearch();
        int val = Global.LOWEST_MAX_EFFICIENCY;
        if (research != null) {
            val += this.getTechBonus(16);
        }
        val += 2 * (int)this.quality;
        val += 3 * (int)this.supply;
        if (this.rangedCommander != null) {
            val += 2 * this.rangedCommander.getQuality();
        } else if (this.commander != null) {
            val += 2 * this.commander.getQuality();
        }
        val = this.country.getSide() == 100 ? (val += this.country.getGame().getGameState().getAxisMorale()) : (val += this.country.getGame().getGameState().getAlliesMorale());
        if (this.supply == 0.0) {
            val = (int)((double)val * 0.8);
        }
        return val;
    }

    public double getExperience() {
        return this.experience;
    }

    public Country getCountry() {
        return this.country;
    }

    public String getClassName() {
        return this.className;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getIndividualName() {
        return this.individualName;
    }

    public void setIndividualName(String s) {
        this.individualName = s;
    }

    public void updateTurnsBeforeComplete() {
        if (this.turnsBeforeComplete > 0) {
            --this.turnsBeforeComplete;
        }
    }

    public void setTurnsBeforeComplete(int turns) {
        this.turnsBeforeComplete = turns;
    }

    public void setHasMoved(boolean b) {
        this.hasMoved = b;
    }

    public boolean getHasMoved() {
        return this.hasMoved;
    }

    public double getAggressiveness() {
        return this.aggressiveness;
    }

    public void setAggressiveness(double aggr) {
        this.aggressiveness = aggr;
    }

    public boolean getHasRaided() {
        return false;
    }

    public Hex getOnHex() {
        return this.onHex;
    }

    public void setOffsets(int xoff, int yoff) {
        this.xOffset = xoff;
        this.yOffset = yoff;
    }

    public void resetOffsets() {
        this.xOffset = 0;
        this.yOffset = 0;
    }

    public void resetHasMoved() {
        this.hasMoved = false;
    }

    public void resetHasRaided() {
        this.hasRaided = false;
    }

    public int getxoffset() {
        return this.xOffset;
    }

    public int getyoffset() {
        return this.yOffset;
    }

    public void casualties(int cas, boolean resourceDamage, int[] rolls) {
        int roll1 = 0;
        int roll2 = 0;
        int roll3 = 0;
        if (rolls != null) {
            roll1 = rolls[0] % 15;
            roll2 = rolls[1] % 15;
            roll3 = rolls[2] % 15;
        }
        if (cas > 0) {
            int preStrength = this.strength;
            this.strength -= cas;
            int loss = preStrength - this.strength;
            if (!(this instanceof Transport) && !(this instanceof Convoy)) {
                if (this.isInfantry()) {
                    this.country.getCasualties().incInfantryCas(loss);
                } else if (this.isArmour()) {
                    this.country.getCasualties().incArmourCas(loss);
                } else if (this instanceof AirUnit) {
                    this.country.getCasualties().incAirCas(loss);
                } else if (this instanceof NavalUnit) {
                    this.country.getCasualties().incNavalCas(loss);
                }
            }
            int newMorale = this.morale - (int)((double)(Global.EFFICIENCY_LOSS_CASUALTY_FACTOR * cas * (roll1 + roll2 + roll3)) / (this.quality * 100.0));
            this.setMorale(newMorale);
        }
        if (this.onHex != null && resourceDamage) {
            PResource pr = this.onHex.getPResource();
            if (cas > 0 && pr != null) {
                pr.casualties(1);
            }
        }
    }

    public void moraleShock(int hits) {
        if (hits > 0) {
            int newMorale = this.morale - hits * Global.EFFICIENCY_LOSS_FROM_SHOCK;
            this.setMorale(newMorale);
        }
    }

    public boolean isDead() {
        return this.strength <= 0;
    }

    public boolean killedProcedure(int injuryRoll, boolean dialogMessage) {
        if (this.strength <= 0) {
            this.killUnit(injuryRoll, dialogMessage);
            return true;
        }
        return false;
    }

    public void killUnit(int injuryRoll, boolean dialogMessage) {
        if (this.commander != null) {
            this.country.injureCommander(this, injuryRoll);
        }
        if (this.onHex != null) {
            this.onHex.setUnit(null);
            this.onHex = null;
            this.country.killUnit(this, dialogMessage);
        }
    }

    public void enterHex(Hex nextHex, boolean adjacentOwnershipChanges) {
        if (this instanceof Commander) {
            nextHex.getUnit().setCommander((Commander)this);
            nextHex.getUnit().setHasMoved(true);
        } else {
            if (this.onHex != null) {
                this.onHex.activeTempUnit();
            }
            nextHex.hideTempUnit(this);
            this.onHex = nextHex;
            this.xOffset = 0;
            this.yOffset = 0;
            Game g = this.country.getGame();
            g.ownershipChange(nextHex, this, true);
            if (this instanceof GroundUnit && adjacentOwnershipChanges) {
                g.ownershipChanges(nextHex, this);
            }
            this.setEntrenchment(0);
        }
    }

    public boolean sameSide(Unit other) {
        return this.getCountry().getSide() == other.getCountry().getSide();
    }

    public void enterHex(Hex[] hex, int col, int row, boolean adjacentOwnershipChanges) {
        this.enterHex(hex[col * 72 + row], adjacentOwnershipChanges);
    }

    public int getCountryIndex() {
        return this.country.getCountryIndex();
    }

    public Image getImage(int inZoomLevel) {
        this.zoomLevel = inZoomLevel;
        return Toolkit.getDefaultToolkit().getImage(this.getImagePath());
    }

    public String getImagePath() {
        boolean showNato = false;
        if (this.zoomLevel == 1) {
            showNato = true;
        } else if (this.zoomLevel == 8) {
            showNato = false;
        } else if (this.country.getGame().getGameState().getNatoSymbols()) {
            showNato = true;
        }
        String imageLevel = "0";
        if (!showNato) {
            imageLevel = String.valueOf(this.getImageLevel());
        }
        String s = String.valueOf(Global.getUnitPath()) + this.image + "_";
        s = showNato && !this.country.isMajorCountry() && !this.country.getAtWar() ? String.valueOf(s) + "neutral" : String.valueOf(s) + this.getCountry().getCountryGraphicString();
        s = String.valueOf(s) + imageLevel + "_";
        if (showNato) {
            s = String.valueOf(s) + "n";
        }
        s = String.valueOf(s) + this.zoomLevel * 16 + ".png";
        return s;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getMaxMovement() {
        Research research = this.country.getResearch();
        int val = this.maxMovement;
        if (research != null) {
            val += this.getTechBonus(2);
        }
        return val;
    }

    public int getTechBonus(int column) {
        Technology[] techs = this.country.getResearch().getTechs();
        int bonus = 0;
        int i = 0;
        while (i < techs.length) {
            bonus += techs[i].getUnitTechBonus(this, column, this.techLevels.getTechLevel(i));
            ++i;
        }
        return bonus;
    }

    public int getRealMovement() {
        double ret = this.supply > (double)Global.HALF_SUPPLY ? (double)this.getMaxMovement() : (this.supply > (double)Global.LOW_SUPPLY ? (double)(this.getMaxMovement() - 1) : (this.supply > 0.0 ? (double)(1 + this.getMaxMovement() / 4) : 1.0));
        if (this.oilConsumption > 0 && this.getCountry().getOil() < (double)this.oilConsumption) {
            ret = 0.0;
        }
        return (int)ret;
    }

    public int getAttackRange() {
        Research research = this.country.getResearch();
        int val = this.attackRange;
        if (research != null) {
            val += this.getTechBonus(3);
        }
        return val;
    }

    public int getStrategicAttack() {
        Research research = this.country.getResearch();
        int val = this.strategicAttack;
        if (research != null) {
            val += this.getTechBonus(12);
        }
        return val;
    }

    public int getTurnsBeforeComplete() {
        return this.turnsBeforeComplete;
    }

    public int getLandSpotting() {
        Research research = this.country.getResearch();
        int val = this.landSpotting;
        if (research != null) {
            val += this.getTechBonus(4);
        }
        return val;
    }

    public int getSeaSpotting() {
        Research research = this.country.getResearch();
        int val = this.seaSpotting;
        if (research != null) {
            val += this.getTechBonus(5);
        }
        return val;
    }

    public int getGroundAttack() {
        Research research = this.country.getResearch();
        int val = this.groundAttack;
        if (this.commander != null) {
            val += this.commander.getGroundAttack();
        }
        if (research != null) {
            val += this.getTechBonus(6);
        }
        return val;
    }

    public int getGroundDefence() {
        Research research = this.country.getResearch();
        int val = this.groundDefence;
        if (this.commander != null) {
            val += this.commander.getGroundDefence();
        }
        if (research != null) {
            val += this.getTechBonus(7);
        }
        return val;
    }

    public int getShockAttack() {
        Research research = this.country.getResearch();
        int val = this.shockAttack;
        if (research != null) {
            val += this.getTechBonus(8);
        }
        return val;
    }

    public int getQuality() {
        Research research = this.country.getResearch();
        double val = this.quality;
        if (research != null) {
            val += (double)this.getTechBonus(13);
        }
        return (int)(val += this.experience / (double)Global.EXPERIENCE_PER_QUALITY_INCREASE);
    }

    public int getSurvivability() {
        Research research = this.country.getResearch();
        double val = this.survivability;
        if (research != null) {
            val += (double)this.getTechBonus(14);
        }
        return (int)(val += this.experience / (double)Global.EXPERIENCE_PER_SURVIVABILITY_INCREASE);
    }

    public int getAntiTankBonus() {
        Research research = this.country.getResearch();
        int val = this.antiTankBonus;
        if (research != null) {
            val += this.getTechBonus(15);
        }
        return val;
    }

    public int getMorale() {
        return this.morale;
    }

    public void setMorale(int newMorale) {
        this.morale = Math.min(newMorale, this.maxMorale());
        if (this.morale < 0) {
            this.morale = 0;
        }
    }

    public void changeMorale(int amount) {
        int newMorale = this.morale + amount;
        this.setMorale(newMorale);
        if (this.morale < 0) {
            this.morale = 0;
        }
    }

    public void changeStrength(int amount) {
        this.strength += amount;
        this.strength = Math.max(1, this.strength);
    }

    public void updateEffectiveness() {
        double change = 0.0;
        if (this.supply == 0.0) {
            change -= (double)Global.EFFICIENCY_LOSS_LACK_SUPPLY;
        } else {
            int missingMorale = this.maxMorale() - this.morale;
            change = (double)Global.EFFICIENCY_REGAIN * ((double)missingMorale * (3.0 * this.quality + 3.0 * this.supply)) / 10000.0;
        }
        int newMorale = this.morale + (int)change;
        this.setMorale(newMorale);
    }

    public int getAirCombat() {
        Research research = this.country.getResearch();
        int val = this.airCombat;
        if (research != null) {
            val += this.getTechBonus(9);
        }
        return val;
    }

    public int getNavalCombat() {
        Research research = this.country.getResearch();
        int val = this.navalCombat;
        if (research != null) {
            val += this.getTechBonus(10);
        }
        return val;
    }

    public int getSubCombat() {
        Research research = this.country.getResearch();
        int val = this.subCombat;
        if (research != null) {
            val += this.getTechBonus(11);
        }
        return val;
    }

    public boolean notDead() {
        return this.strength > 0;
    }

    public boolean canReassignCommander() {
        return this.commander != null;
    }

    public boolean canOperate() {
        boolean ret = false;
        if (this.supply <= (double)Global.HALF_SUPPLY) {
            ret = false;
        } else {
            if (this.country.getGame().enemiesAdjacent(this.country.getGame().getHexIndex(this.onHex), this) > 0) {
                return false;
            }
            ret = true;
        }
        return ret;
    }

    public boolean canReinforce() {
        boolean ret = false;
        if (this.onHex != null && this.maxStrength() - this.strength > 0 && this.supply > 0.0 && !this.getHasMoved() && !(this.getGame().countryInCharge(this.getCountry()).getPP() < (double)(-Global.MAX_DEFICIT_BEFORE_SPENDING_STOP))) {
            ret = true;
        }
        return ret;
    }

    public boolean canReinforceToMax() {
        int val = (int)this.supply;
        boolean ret = false;
        if (this.getCountry().getPP() < (double)(-Global.MAX_DEFICIT_BEFORE_SPENDING_STOP)) {
            ret = false;
        } else if (this.canReinforce() && val >= this.maxStrength() - this.strength) {
            ret = true;
        }
        return ret;
    }

    public double maximumAmountThatCanBeReinforced() {
        int val = (int)this.supply;
        double reinf = this.maxStrength() - this.strength;
        if ((double)val < reinf) {
            reinf = val;
        }
        return reinf;
    }

    public double reinforceCost(double reinf) {
        double cost = reinf * this.getReinforceCost();
        return cost;
    }

    public double manpowerCost(double reinf) {
        double cost = (double)this.manpower * reinf / (double)this.maxStrength();
        return cost;
    }

    public double reinforce(double amount) {
        double reinf = amount;
        if (this.maximumAmountThatCanBeReinforced() < reinf) {
            reinf = this.maximumAmountThatCanBeReinforced();
        }
        double cost = this.reinforceCost(reinf);
        this.country.changeManpower(-this.manpowerCost(reinf));
        double val1 = (double)this.strength * this.experience;
        double val2 = (double)this.strength * this.quality;
        double val3 = reinf * (this.startQuality - (double)Unit.qualityManpowerPenalty(this.country));
        double val4 = (double)this.strength * this.survivability;
        double val5 = reinf * (this.startSurvivability - (double)Unit.survivabilityManpowerPenalty(this.country));
        this.strength = (int)((double)this.strength + reinf);
        this.experience = val1 / (double)this.strength;
        this.quality = (val2 + val3) / (double)this.strength;
        this.survivability = (val4 + val5) / (double)this.strength;
        this.hasMoved = true;
        return cost;
    }

    public double reinforceToMax() {
        int sup = (int)this.supply;
        double reinf = this.maxStrength() - this.strength;
        if ((double)sup < reinf) {
            reinf = this.supply;
        }
        double cost = reinf * this.getReinforceCost();
        this.country.changeManpower((double)(-this.manpower) * reinf / (double)this.maxStrength());
        double val1 = (double)this.strength * this.experience;
        double val2 = (double)this.strength * this.quality;
        double val3 = reinf * (this.startQuality - (double)Unit.qualityManpowerPenalty(this.country));
        double val4 = (double)this.strength * this.survivability;
        double val5 = reinf * (this.startSurvivability - (double)Unit.survivabilityManpowerPenalty(this.country));
        this.strength = (int)((double)this.strength + reinf);
        this.experience = val1 / (double)this.strength;
        this.quality = (val2 + val3) / (double)this.strength;
        this.survivability = (val4 + val5) / (double)this.strength;
        this.hasMoved = true;
        return cost;
    }

    public int getSupply() {
        return (int)this.supply;
    }

    public void changeSupply(double amount) {
        this.supply += amount;
        if (this.supply < (double)this.minimumSupply()) {
            this.supply = this.minimumSupply();
        }
    }

    public void setSupply(int sup) {
        if (sup >= 0) {
            Terrain t;
            this.supply = sup;
            if (this.onHex != null && (t = this.onHex.getTerrain()) != null) {
                if (t instanceof Desert) {
                    this.supply -= 2.0;
                }
                if (t instanceof Dune) {
                    this.supply -= 2.0;
                }
            }
            if (this.supply < (double)this.minimumSupply()) {
                this.supply = this.minimumSupply();
            }
        }
    }

    public void removeFromMap() {
        if (this.onHex != null) {
            this.onHex.setUnit(null);
        }
        this.onHex = null;
        this.setWayPoint(null);
        this.chasePoint = null;
    }

    public int getSide() {
        return this.country.getSide();
    }

    public void raid(int amount) {
    }

    public int raidAmount() {
        return 0;
    }

    public boolean afraidOfHex(int hex) {
        return false;
    }

    public boolean isInfantry() {
        return false;
    }

    public int compare(Object a, Object b) {
        if (((Unit)a).airCombat < ((Unit)b).airCombat) {
            return -1;
        }
        if (((Unit)a).airCombat > ((Unit)b).airCombat) {
            return 1;
        }
        return 0;
    }

    public boolean garrisonDuty() {
        boolean ret = false;
        if (this.onHex != null && this.onHex.getPResource() != null && this.wayPoint == null) {
            ret = true;
        }
        return ret;
    }

    public boolean offensiveDuty() {
        int coreOwner;
        Game game = this.country.getGame();
        return this.destinationHex != null && (coreOwner = this.destinationHex.getCoreOwningCountry()) != -1 && game.getCountry(coreOwner).getSide() != this.getSide();
    }

    public boolean capitalDefenceDuty() {
        boolean ret = false;
        int capital = this.country.activeCapital();
        if (this.destinationHex != null && capital != -1 && this.destinationHex == this.country.getGame().getHex(capital)) {
            ret = true;
        }
        return ret;
    }

    public boolean nothingToDo() {
        return !this.onDefenceMission() && this.destinationHex == null && this.wayPoint == null && this.chasePoint == null;
    }

    public boolean onDefenceMission() {
        if (this.garrisonDuty()) {
            return true;
        }
        return this.capitalDefenceDuty();
    }

    public boolean isLandUnit() {
        if (this instanceof AirUnit) {
            return true;
        }
        return this instanceof GroundUnit;
    }

    public double getLandInfluence() {
        return this.strength * this.morale * (this.price + 12 * this.shockAttack) / 9000;
    }

    public double getWaterInfluence() {
        return this.strength * this.morale * (this.price + 12 * this.shockAttack) / 9000;
    }

    public int getPrice() {
        return this.price;
    }

    public int getManpower() {
        return this.manpower;
    }

    public int getOilConsumption() {
        Research research = this.country.getResearch();
        int val = this.oilConsumption;
        if (research != null) {
            val += this.getTechBonus(18);
        }
        return val;
    }

    public boolean enoughOil() {
        return this.getOilConsumption() == 0 || this.getCountry().getOil() >= (double)this.getOilConsumption();
    }

    public int getImageLevel() {
        if (this.testImageLevel != -1) {
            return this.testImageLevel;
        }
        int ret = 0;
        int maxUpgrades = this.getMaxUpgrades();
        if (maxUpgrades > 0) {
            int upgrades = this.getUpgradesHeld();
            int numImages = this.numImageLevels();
            ret = 0 + numImages * upgrades / (maxUpgrades + 1);
        }
        return ret;
    }

    public int numImageLevels() {
        return 1;
    }

    public double getReinforceCost() {
        return this.reinforceCostFactor * (double)this.price / 10.0;
    }

    public abstract boolean hasGroundUnit();

    public abstract boolean canIntercept();

    public abstract int maxStrength();

    public abstract boolean canTransport();

    public abstract boolean canUnload();

    public abstract boolean canRaid();

    public abstract int minimumSupply();

    public abstract boolean hasAirDuelCapacity();

    public int displayHashCode_debug() {
        return 17;
    }

    public int displayHashCode() {
        int ret = 17;
        int c = this.getSide();
        ret = 37 * ret + c;
        c = this.getSupply();
        ret = 37 * ret + c;
        c = this.getStrength();
        ret = 37 * ret + c;
        c = this.getMorale();
        ret = 37 * ret + c;
        c = this.isInvisible() ? 0 : 1;
        ret = 37 * ret + c;
        c = this.getxoffset();
        ret = 37 * ret + c;
        c = this.getyoffset();
        ret = 37 * ret + c;
        c = this.getImagePath().hashCode();
        ret = 37 * ret + c;
        c = this.canUpgrade() ? 0 : 1;
        ret = 37 * ret + c;
        c = this.getUpgradesHeld();
        ret = 37 * ret + c;
        return ret;
    }
}

