/*
 * Decompiled with CFR 0.152.
 */
package game.unit;

import game.Country;
import game.Global;
import game.hex.Hex;
import game.unit.Corps;
import game.unit.NavalUnit;
import game.unit.Unit;

public class Transport
extends NavalUnit {
    private static final long serialVersionUID = 125L;
    Unit carryingUnit;

    public Transport(Country countryP, Unit u) {
        super(countryP, 100, 0, 0, 15, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        this.carryingUnit = u;
        this.className = "Transport";
        this.typeName = String.valueOf(Global.getMessage(472)) + " (" + this.carryingUnit.getTypeName() + ")";
        this.setAttributes("Transport");
        this.hasMoved = false;
    }

    public boolean hasGroundUnit() {
        return true;
    }

    public boolean canSupply() {
        return false;
    }

    public void setDestinationHex(Hex h) {
        super.setDestinationHex(h);
        this.carryingUnit.setDestinationHex(h);
    }

    public double getLandInfluence() {
        Corps c = new Corps(this.getCountry());
        return 4.0 * c.getLandInfluence();
    }

    public double getWaterInfluence() {
        return 0.0;
    }

    public int maxStrength() {
        return 10;
    }

    public int getCost() {
        return 50 * this.maxStrength();
    }

    public void casualties(int cas, boolean resourceDamage, int[] rolls) {
        if (this.carryingUnit != null) {
            this.carryingUnit.changeStrength(-cas);
        }
        super.casualties(cas, resourceDamage, rolls);
    }

    public boolean canReinforce() {
        return false;
    }

    public boolean killedProcedure() {
        if (this.strength <= 0) {
            this.onHex.setUnit(null);
            this.onHex = null;
            this.carryingUnit.casualties(99, false, null);
            this.carryingUnit.killedProcedure(Global.COMMANDER_MAX_INJURY - 1, false);
            return true;
        }
        return false;
    }

    public boolean canUnload() {
        return this.getGame().hasLandingSpotsAdjacent(this);
    }

    public Unit getCarryingUnit() {
        return this.carryingUnit;
    }

    public void setSupply(int sup) {
        if (sup >= 0) {
            this.supply = sup;
            if (this.supply < (double)this.minimumSupply()) {
                this.supply = this.minimumSupply();
            }
            this.carryingUnit.setSupply(1);
        }
    }

    public boolean canIntercept() {
        return false;
    }

    public void incExperience(int val) {
    }
}

