/*
 * Decompiled with CFR 0.152.
 */
package game.unit;

import game.Country;
import game.Global;
import game.p_resource.SeaPort;
import game.unit.Unit;

public abstract class NavalUnit
extends Unit {
    private static final long serialVersionUID = 120L;

    NavalUnit(Country countryP, int costt, int manpow, int oilConsum, int turnsComp, int movementP, int attackRangeP, int landSpot, int seaSpot, int groundAtt, int groundDef, int shockAtt, int airComb, int navalComb, int subComb, int stratAtt, int qual, int surviv, int antiTank) {
        super(countryP, costt, manpow, oilConsum, turnsComp, movementP, attackRangeP, landSpot, seaSpot, groundAtt, groundDef, shockAtt, airComb, navalComb, subComb, stratAtt, qual, surviv, antiTank);
        this.reinforceCostFactor = 0.8;
        this.supply = Global.MAX_SUPPLY;
    }

    public double getLandInfluence() {
        return 0.0;
    }

    public boolean canUpgrade() {
        if (this.getCountry().getPP() < (double)(-Global.MAX_DEFICIT_BEFORE_SPENDING_STOP)) {
            return false;
        }
        return this.getUpgradesHeld() < this.country.getUpgradesHeld(this) && this.supply > 0.0 && this.getOnHex() != null && this.getOnHex().getPResource() instanceof SeaPort;
    }

    public abstract boolean canSupply();

    public boolean onDefenceMission() {
        return false;
    }

    public boolean hasGroundUnit() {
        return false;
    }

    public int zocPenalty() {
        return 4;
    }

    public boolean canTransport() {
        return false;
    }

    public boolean canUnload() {
        return false;
    }

    public boolean canReinforce() {
        boolean ret = false;
        if (this.getCountry().getPP() < (double)(-Global.MAX_DEFICIT_BEFORE_SPENDING_STOP)) {
            ret = false;
        } else if (this.onHex != null && this.onHex.getPResource() instanceof SeaPort && this.maxStrength() - this.strength > 0 && this.supply > 0.0) {
            ret = true;
        }
        return ret;
    }

    public int minimumSupply() {
        return 1;
    }

    public boolean canOperate() {
        return false;
    }

    public boolean canRaid() {
        return false;
    }

    public boolean hasAirDuelCapacity() {
        return false;
    }

    public double maximumAmountThatCanBeReinforced() {
        double reinf;
        int val = (int)Math.ceil(this.supply / 2.0);
        if ((double)val < (reinf = (double)(this.maxStrength() - this.strength))) {
            reinf = val;
        }
        return reinf;
    }
}

