/*
 * Decompiled with CFR 0.152.
 */
package game.unit;

import game.Country;
import game.Game;
import game.Global;
import game.unit.Unit;

public abstract class GroundUnit
extends Unit {
    private static final long serialVersionUID = 117L;

    GroundUnit(Country countryP, int costt, int manpow, int oilConsum, int turnsComp, int movementP, int attackRangeP, int landSpot, int seaSpot, int groundAtt, int groundDef, int shockAtt, int airComb, int navalComb, int subComb, int stratAtt, int qual, int surviv, int antiTank) {
        super(countryP, costt, manpow, oilConsum, turnsComp, movementP, attackRangeP, landSpot, seaSpot, groundAtt, groundDef, shockAtt, airComb, navalComb, subComb, stratAtt, qual, surviv, antiTank);
        this.reinforceCostFactor = 0.6;
        this.supply = Global.HALF_SUPPLY;
    }

    public boolean afraidOfHex(int hex) {
        Game game = this.country.getGame();
        if (this.getSupply() <= Global.HALF_SUPPLY) {
            return false;
        }
        return this.getOnHex() != null && !this.offensiveDuty() && game.getCountry(game.getHex(hex).getCoreOwningCountry()).getSide() != this.getSide();
    }

    public boolean hasGroundUnit() {
        return true;
    }

    public boolean canTransport() {
        return this.getGame().transportHex(this) != -1;
    }

    public double getWaterInfluence() {
        return 0.0;
    }

    public boolean canUnload() {
        return false;
    }

    public int zocPenalty() {
        return 2;
    }

    public boolean canRaid() {
        return false;
    }

    public boolean hasAirDuelCapacity() {
        return false;
    }

    public int minimumSupply() {
        return 0;
    }

    public void resetCanIntercept() {
    }
}

