/*
 * Decompiled with CFR 0.152.
 */
package game.unit;

import game.Country;
import game.Global;
import game.unit.Unit;
import java.awt.Image;
import java.awt.Toolkit;

public class Commander
extends Unit {
    private static final long serialVersionUID = 111L;
    String biography = "";

    public Commander(Country countryP, String dataName, String translationName, int leadership, int groundAtt, int groundDef, int price, String bio) {
        super(countryP, price, 0, 0, Global.COMMANDER_BUILDING_TIME, 0, 0, 0, 0, groundAtt, groundDef, 0, 0, 0, 0, 0, leadership, 0, 0);
        this.className = "Commander";
        this.typeName = Global.getMessage(460);
        this.biography = bio;
        this.image = dataName.toLowerCase();
        this.individualName = translationName.replaceAll("_", " ");
        this.strength = this.maxStrength();
        this.morale = this.maxMorale();
        this.price = 5 * ((25 * this.groundAttack + 15 * this.groundDefence + (int)(7.0 * Math.pow(this.quality, 1.3))) / 5);
    }

    public boolean hasGroundUnit() {
        return false;
    }

    public String getBiography() {
        return this.biography;
    }

    public String toolTipText1() {
        String toolTip = String.valueOf(this.getIndividualName()) + "  ";
        if (this.groundAttack != 0) {
            toolTip = String.valueOf(toolTip) + Global.getMessage(375) + " " + this.groundAttack + "  ";
        }
        if (this.groundDefence != 0) {
            toolTip = String.valueOf(toolTip) + Global.getMessage(376) + " " + this.groundDefence + "  ";
        }
        if (this.quality != 0.0) {
            toolTip = String.valueOf(toolTip) + Global.getMessage(387) + " " + (int)this.quality + "  ";
        }
        return toolTip;
    }

    public Image getImage(int zoomLevel) {
        int size = 0;
        switch (zoomLevel) {
            case 3: {
                size = 37;
                break;
            }
            case 4: {
                size = 64;
                break;
            }
            case 8: {
                size = 126;
            }
        }
        Image ret = Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getLeaderPath()) + this.image + "_" + size + ".png");
        return ret;
    }

    public void modifyCommanderValue(int max) {
    }

    public int minimumSupply() {
        return Global.MAX_SUPPLY;
    }

    public int maxStrength() {
        return 10;
    }

    public boolean hasAirDuelCapacity() {
        return false;
    }

    public boolean canTransport() {
        return false;
    }

    public boolean canUnload() {
        return false;
    }

    public boolean canRaid() {
        return false;
    }

    public boolean canIntercept() {
        return false;
    }
}

