/*
 * Decompiled with CFR 0.152.
 */
package game.unit;

import game.Country;
import game.Global;
import game.unit.Unit;

public abstract class AirUnit
extends Unit {
    private static final long serialVersionUID = 107L;

    AirUnit(Country countryP, int costt, int manpow, int oilConsum, int turnsComp, int movementP, int attackRangeP, int landSpot, int seaSpot, int groundAtt, int groundDef, int shockAtt, int airComb, int navalComb, int subComb, int stratAtt, int qual, int surviv, int antiTank) {
        super(countryP, costt, manpow, oilConsum, turnsComp, movementP, attackRangeP, landSpot, seaSpot, groundAtt, groundDef, shockAtt, airComb, navalComb, subComb, stratAtt, qual, surviv, antiTank);
        this.maxEntrenchment = 0;
        this.reinforceCostFactor = 0.6;
    }

    public boolean afraidOfHex(int hex) {
        return this.country.getGame().nearestEnemyGroundUnitDistance(hex, this.getSide(), false) < Global.SAFE_AIR_DISTANCE;
    }

    public boolean hasGroundUnit() {
        return false;
    }

    public boolean garrisonDuty() {
        return false;
    }

    public void setSupply(int sup) {
        super.setSupply(sup);
    }

    public boolean canTransport() {
        return this.getGame().transportHex(this) != -1;
    }

    public boolean canUnload() {
        return false;
    }

    public boolean canRaid() {
        return false;
    }

    public boolean hasAirDuelCapacity() {
        return true;
    }

    public int minimumSupply() {
        return 2;
    }
}

