/*
 * Decompiled with CFR 0.152.
 */
package game.terrain;

import game.Global;
import game.TerrainPenalties;
import game.hex.Hex;
import game.unit.Unit;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.Serializable;

public abstract class Terrain
implements Serializable {
    private static final long serialVersionUID = 106L;
    int movementCost = 1;
    int vehicleMovementPenalty = 1;
    String className;
    String typeName;
    String image;
    double tankPenaltyModifier = 0.0;
    double defenceBonusModifier = 0.0;

    protected void setAttributes(String clasName) {
        int unitIndex = -1;
        TerrainPenalties bp = Global.BATTLE_PENALTIES;
        int i = 0;
        while (i < bp.numRows()) {
            if (bp.getTerrainName(i).compareTo(clasName) == 0) {
                unitIndex = i;
                break;
            }
            ++i;
        }
        if (unitIndex != -1) {
            this.defenceBonusModifier = 0.01 * (double)bp.getValue(0, unitIndex);
            this.tankPenaltyModifier = 0.01 * (double)bp.getValue(1, unitIndex);
            this.movementCost = bp.getValue(2, unitIndex);
            this.vehicleMovementPenalty = bp.getValue(3, unitIndex);
            this.typeName = bp.getTerrainTranslation(unitIndex);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public double getDefenceBonusModifier() {
        return this.defenceBonusModifier;
    }

    public double getTankPenaltyModifier() {
        return this.tankPenaltyModifier;
    }

    public int getBasicMovementCost() {
        return this.movementCost;
    }

    public int getVehicleMovementPenalty() {
        return this.vehicleMovementPenalty;
    }

    public int ggggetRealMovementCost(Hex h, Unit u) {
        int ret = this.movementCost;
        if (h.getWinterDuration() > 0) {
            ++ret;
        }
        if (u.isVehicle()) {
            ret += this.getVehicleMovementPenalty();
            if (h.getWinterDuration() > 0) {
                ++ret;
            }
        }
        return ret;
    }

    public Image getImage() {
        return Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getTerrainPath()) + this.image);
    }

    public abstract int maxEntrenchment();
}

