/*
 * Decompiled with CFR 0.152.
 */
package game.p_resource;

import game.Country;
import game.Global;
import game.Research;
import game.TerrainPenalties;
import game.UnitAttributes;
import game.hex.Hex;
import game.unit.Unit;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.Serializable;

public abstract class PResource
implements Serializable {
    private static final long serialVersionUID = 97L;
    String className;
    String typeName;
    String image;
    int strength = this.maxStrength();
    int airCombat = 0;
    int survivability = 0;
    protected int maxProduction;
    double tankPenaltyModifier = 0.0;
    double defenceBonusModifier = 0.0;
    int movementCost = 1;
    int vehicleMovementPenalty = 0;
    boolean hasDeployed = false;

    public String getClassName() {
        return this.className;
    }

    public abstract boolean isSupplySource();

    public String getTypeName() {
        return this.typeName;
    }

    public boolean getHasDeployed() {
        return this.hasDeployed;
    }

    public void setHasDeployed(boolean b) {
        this.hasDeployed = b;
    }

    public int getMorale() {
        return 100;
    }

    public int getBasicMovementCost() {
        return this.movementCost;
    }

    public int getVehicleMovementPenalty() {
        return this.vehicleMovementPenalty;
    }

    public int getMaxProduction() {
        return this.maxProduction;
    }

    public void setMaxProduction(int value) {
        this.maxProduction = value;
    }

    public int getAirCombat(Country country) {
        int val = this.airCombat;
        Research research = country.getResearch();
        if (research != null) {
            val += research.getPResourceTechBonus(this, 9);
        }
        return val;
    }

    public int getSurvivability(Country country) {
        int val = this.survivability;
        Research research = country.getResearch();
        if (research != null) {
            val += research.getPResourceTechBonus(this, 14);
        }
        return val;
    }

    public double getDefenceBonusModifier() {
        return this.defenceBonusModifier;
    }

    public double getTankPenaltyModifier() {
        return this.tankPenaltyModifier;
    }

    public Image getImage(int zoomLevel, Country country) {
        String s = "";
        if (country == null) {
            s = String.valueOf(Global.getPResourcesPath()) + this.image + "_" + zoomLevel * 16 + ".png";
        } else {
            String ss = "";
            switch (country.getFaction()) {
                case 100: {
                    ss = "_axis";
                    break;
                }
                case 200: {
                    ss = "_allies";
                    break;
                }
                case 5: {
                    ss = "_ussr";
                    break;
                }
                default: {
                    ss = "_neutral";
                }
            }
            s = String.valueOf(Global.getPResourcesPath()) + this.image + ss + "_" + zoomLevel * 16 + ".png";
        }
        return Toolkit.getDefaultToolkit().getImage(s);
    }

    protected void setAttributes(String clasName) {
        int unitIndex = -1;
        TerrainPenalties bp = Global.BATTLE_PENALTIES;
        int i = 0;
        while (i < bp.numRows()) {
            if (bp.getTerrainName(i).compareTo(clasName) == 0) {
                unitIndex = i;
                break;
            }
            ++i;
        }
        if (unitIndex != -1) {
            this.defenceBonusModifier = 0.01 * (double)bp.getValue(0, unitIndex);
            this.tankPenaltyModifier = 0.01 * (double)bp.getValue(1, unitIndex);
            this.movementCost = bp.getValue(2, unitIndex);
            this.vehicleMovementPenalty = bp.getValue(3, unitIndex);
            this.typeName = bp.getTerrainTranslation(unitIndex);
        }
        int index = -1;
        UnitAttributes ua = Global.UNIT_ATTRIBUTES;
        int i2 = 0;
        while (i2 < ua.numColumns()) {
            if (ua.getClassName(i2).compareTo(clasName) == 0) {
                index = i2;
                break;
            }
            ++i2;
        }
        if (index != -1) {
            this.airCombat = ua.getValue(index, 10);
            this.survivability = ua.getValue(index, 15);
            this.image = ua.getIcongraphic(index);
        }
    }

    public int getStrength() {
        return this.strength;
    }

    public int maxStrength() {
        return 10;
    }

    public int ggggetRealMovementCost(Hex h, Unit u) {
        int ret = this.movementCost;
        if (h.getWinterDuration() > 0) {
            ++ret;
        }
        if (u.isVehicle()) {
            ret += this.getVehicleMovementPenalty();
            if (h.getWinterDuration() > 0) {
                ++ret;
            }
        }
        return ret;
    }

    public void casualties(int cas) {
        if (cas > 0) {
            this.strength -= cas;
        }
        if (this.strength < 0) {
            this.strength = 0;
        }
    }

    public void repair() {
        if (this.strength < this.maxStrength()) {
            ++this.strength;
        }
        if (this.strength > this.maxStrength()) {
            this.strength = this.maxStrength();
        }
    }

    public double maxProduction() {
        return this.maxProduction;
    }

    public int getPP() {
        return (int)Math.round((double)this.maxProduction * ((double)this.strength / (double)this.maxStrength()));
    }

    public abstract double getOil();

    public abstract int maxEntrenchment();
}

