/*
 * Decompiled with CFR 0.152.
 */
package game.hex;

import game.hex.Hex;
import game.p_resource.Capital;
import game.p_resource.City;
import game.p_resource.Fortress;
import game.p_resource.Mine;
import game.p_resource.OilField;
import game.terrain.Clear;
import game.terrain.Desert;
import game.terrain.Dune;
import game.terrain.Forest;
import game.terrain.Mountain;
import game.terrain.Rough;
import game.terrain.Swamp;
import java.awt.Polygon;

public class LandHex
extends Hex {
    private static final long serialVersionUID = 89L;
    boolean borderN;
    boolean borderNE;
    boolean borderSE;
    boolean borderS;
    boolean borderSW;
    boolean borderNW;
    boolean ownerBorderNE;
    boolean ownerBorderSE;
    boolean ownerBorderS;
    boolean riverN;
    boolean riverNE;
    boolean riverSE;
    boolean riverS;
    boolean riverSW;
    boolean riverNW;

    public LandHex() {
        this.owningCountry = 300;
    }

    public LandHex(Polygon p) {
        super(p);
        this.owningCountry = 300;
    }

    public void setBorders(boolean n, boolean ne, boolean se, boolean s, boolean sw, boolean nw) {
        this.borderN = n;
        this.borderNE = ne;
        this.borderSE = se;
        this.borderS = s;
        this.borderSW = sw;
        this.borderNW = nw;
    }

    public void setRivers(boolean n, boolean ne, boolean se, boolean s, boolean sw, boolean nw) {
        this.riverN = n;
        this.riverNE = ne;
        this.riverSE = se;
        this.riverS = s;
        this.riverSW = sw;
        this.riverNW = nw;
    }

    public boolean isLandHex() {
        return true;
    }

    public boolean isWaterHex() {
        return false;
    }

    public boolean isLoopHex() {
        return false;
    }

    public boolean hasBorderN() {
        return this.borderN;
    }

    public boolean hasBorderNE() {
        return this.borderNE;
    }

    public boolean hasBorderSE() {
        return this.borderSE;
    }

    public boolean hasBorderS() {
        return this.borderS;
    }

    public boolean hasBorderSW() {
        return this.borderSW;
    }

    public boolean hasBorderNW() {
        return this.borderNW;
    }

    public boolean hasOwnerBorderNE() {
        return this.ownerBorderNE;
    }

    public boolean hasOwnerBorderSE() {
        return this.ownerBorderSE;
    }

    public boolean hasOwnerBorderS() {
        return this.ownerBorderS;
    }

    public void setOwningBorderNE(boolean b) {
        this.ownerBorderNE = b;
    }

    public void setOwningBorderSE(boolean b) {
        this.ownerBorderSE = b;
    }

    public void setOwningBorderS(boolean b) {
        this.ownerBorderS = b;
    }

    public boolean hasRiverN() {
        return this.riverN;
    }

    public boolean hasRiverNE() {
        return this.riverNE;
    }

    public boolean hasRiverSE() {
        return this.riverSE;
    }

    public boolean hasRiverS() {
        return this.riverS;
    }

    public boolean hasRiverSW() {
        return this.riverSW;
    }

    public boolean hasRiverNW() {
        return this.riverNW;
    }

    public void resetHex() {
        this.borderN = false;
        this.borderNE = false;
        this.borderSE = false;
        this.borderS = false;
        this.borderSW = false;
        this.borderNW = false;
        this.terrain = new Clear(false);
        this.pResource = null;
    }

    public void buildCapital() {
        this.pResource = new Capital();
    }

    public void buildCity() {
        this.pResource = new City();
    }

    public void growMountain() {
        this.terrain = new Mountain();
    }

    public void growSwamp() {
        this.terrain = new Swamp();
    }

    public void growForest() {
        this.terrain = new Forest();
    }

    public void growRough() {
        this.terrain = new Rough();
    }

    public void growDesert() {
        this.terrain = new Desert();
    }

    public void growDune() {
        this.terrain = new Dune();
    }

    public void buildOilField() {
        this.pResource = new OilField();
    }

    public void buildMine() {
        this.pResource = new Mine();
    }

    public void buildPort() {
    }

    public void buildFortress() {
        int production = 0;
        if (this.pResource != null) {
            production = this.pResource.getMaxProduction();
        }
        this.pResource = new Fortress();
        this.pResource.setMaxProduction(production);
    }
}

