/*
 * Decompiled with CFR 0.152.
 */
package game.hex;

import game.Game;
import game.Global;
import game.hex.LandHex;
import game.hex.WaterHex;
import game.p_resource.Fortress;
import game.p_resource.PResource;
import game.p_resource.SeaPort;
import game.terrain.Clear;
import game.terrain.Terrain;
import game.unit.Unit;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public abstract class Hex
implements Serializable {
    private static final long serialVersionUID = 88L;
    int battleState = 0;
    boolean hasArrowN;
    boolean hasArrowNE;
    boolean hasArrowSE;
    boolean hasArrowS;
    boolean hasArrowSW;
    boolean hasArrowNW;
    int winterDuration = 0;
    String hexName = "";
    boolean higlighted;
    boolean targetted;
    boolean alliesFOW;
    boolean axisFOW;
    Polygon polygon;
    Terrain terrain;
    public static Clear clear = new Clear(false);
    PResource pResource;
    Hex attachedPort;
    int owningCountry = 0;
    int coreOwningCountry = -1;
    int continent = -1;
    Unit unit = null;
    Unit tempUnit = null;
    int supply = 0;
    int tmpMovesLeft = 0;
    transient BufferedImage bufferedUnitImage = null;
    transient int bufferedUnitHash = 0;

    public Hex() {
        boolean water = false;
        if (this instanceof WaterHex) {
            water = true;
        }
        this.terrain = new Clear(water);
    }

    public Hex(Polygon p) {
        this.polygon = p;
        boolean water = false;
        if (this instanceof WaterHex) {
            water = true;
        }
        this.terrain = new Clear(water);
    }

    public abstract void buildCapital();

    public abstract void buildCity();

    public abstract void growMountain();

    public abstract void growSwamp();

    public abstract void growForest();

    public abstract void growRough();

    public abstract void growDesert();

    public abstract void growDune();

    public abstract void buildOilField();

    public abstract void buildMine();

    public abstract void buildPort();

    public abstract void buildFortress();

    public abstract boolean isLandHex();

    public abstract boolean isWaterHex();

    public abstract boolean isLoopHex();

    public double getPP(Game g) {
        double val = 0.0;
        if (this.pResource == null) {
            return 0.0;
        }
        val = this instanceof WaterHex ? (double)this.pResource.getPP() : (g.oppositeSide(g.getCountry(this.coreOwningCountry).getSide()) == g.getCountry(this.owningCountry).getSide() ? (double)(Global.OCCUPIED_PRODUCTION_RATE * this.pResource.getPP()) / 100.0 : (double)this.pResource.getPP());
        return val;
    }

    public boolean hasArrowN() {
        return this.hasArrowN;
    }

    public boolean hasArrowNE() {
        return this.hasArrowNE;
    }

    public boolean hasArrowSE() {
        return this.hasArrowSE;
    }

    public boolean hasArrowS() {
        return this.hasArrowS;
    }

    public boolean hasArrowSW() {
        return this.hasArrowSW;
    }

    public boolean hasArrowNW() {
        return this.hasArrowNW;
    }

    public void resetReplaySymbols() {
        this.setBattleState(0);
        this.hasArrowN = false;
        this.hasArrowNE = false;
        this.hasArrowSE = false;
        this.hasArrowS = false;
        this.hasArrowSW = false;
        this.hasArrowNW = false;
    }

    public void setBattleState(int i) {
        this.battleState = i;
    }

    public void setHasArrowN(boolean b) {
        this.hasArrowN = b;
    }

    public void setHasArrowNE(boolean b) {
        this.hasArrowNE = b;
    }

    public void setHasArrowSE(boolean b) {
        this.hasArrowSE = b;
    }

    public void setHasArrowS(boolean b) {
        this.hasArrowS = b;
    }

    public void setHasArrowSW(boolean b) {
        this.hasArrowSW = b;
    }

    public void setHasArrowNW(boolean b) {
        this.hasArrowNW = b;
    }

    public boolean getHasArrowN() {
        return this.hasArrowN;
    }

    public boolean getHasArrowNE() {
        return this.hasArrowNE;
    }

    public boolean getHasArrowSE() {
        return this.hasArrowSE;
    }

    public boolean getHasArrowS() {
        return this.hasArrowS;
    }

    public boolean getHasArrowSW() {
        return this.hasArrowSW;
    }

    public boolean getHasArrowNW() {
        return this.hasArrowNW;
    }

    public Image getArrowImage(int zoomLevel, int direction) {
        String s = "";
        Image ret = null;
        switch (direction) {
            case 0: {
                s = "arrow_n_" + 9 * zoomLevel + ".png";
                break;
            }
            case 1: {
                s = "arrow_ne_" + 9 * zoomLevel + ".png";
                break;
            }
            case 2: {
                s = "arrow_se_" + 9 * zoomLevel + ".png";
                break;
            }
            case 3: {
                s = "arrow_s_" + 9 * zoomLevel + ".png";
                break;
            }
            case 4: {
                s = "arrow_sw_" + 9 * zoomLevel + ".png";
                break;
            }
            case 5: {
                s = "arrow_nw_" + 9 * zoomLevel + ".png";
            }
        }
        if (s.length() > 0) {
            ret = Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + s);
        }
        return ret;
    }

    public Image getBattleImage(int zoomLevel) {
        String s = "";
        Image ret = null;
        switch (this.battleState) {
            case 0: {
                break;
            }
            case 1: {
                s = "battle_" + 16 * zoomLevel + ".png";
            }
        }
        if (s.length() > 0) {
            ret = Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + s);
        }
        return ret;
    }

    public double getOil(Game g) {
        double val = 0.0;
        if (this.pResource == null) {
            return 0.0;
        }
        val = this instanceof WaterHex ? this.pResource.getOil() : (g.oppositeSide(g.getCountry(this.coreOwningCountry).getSide()) == g.getCountry(this.owningCountry).getSide() ? (double)Global.OCCUPIED_PRODUCTION_RATE * this.pResource.getOil() / 100.0 : this.pResource.getOil());
        return val;
    }

    public int getWinterDuration() {
        return this.winterDuration;
    }

    public void setWinterDuration(int i) {
        this.winterDuration = i;
    }

    public void decWinterDuration() {
        if (this.winterDuration > 0) {
            --this.winterDuration;
        }
    }

    public Image getImage() {
        return Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getBackgroundPath()) + "image_ter_" + this.getImage2() + ".png");
    }

    public String getImage2() {
        if (this.getPResource() != null) {
            return this.pResource.getClassName().toLowerCase();
        }
        if (this instanceof WaterHex) {
            return "sea";
        }
        return this.terrain.getClassName().toLowerCase();
    }

    public Image getOverlay(Game g, boolean political, boolean fow) {
        String s = "";
        if (!political) {
            s = "owner_";
            s = this.owningCountry == -1 ? String.valueOf(s) + "neutral_" : (this.owningCountry == 5 ? String.valueOf(s) + "ussr_" : String.valueOf(s) + g.getSideData(g.getCountry(this.owningCountry).getWarSide()) + "_");
        } else {
            s = "political_";
            if (this.owningCountry == -1) {
                s = String.valueOf(s) + "neutral_";
            } else if (g.getCountry(this.owningCountry).getSide() == 300) {
                s = String.valueOf(s) + "neutral_";
            } else {
                if (!g.getCountry(this.owningCountry).getAtWar()) {
                    s = String.valueOf(s) + "pro";
                }
                s = String.valueOf(s) + g.getSideData(g.getCountry(this.owningCountry).getSide()) + "_";
            }
        }
        if (fow && !political) {
            s = String.valueOf(s) + "fow_";
        }
        s = !g.getDarkOverlay() ? String.valueOf(s) + "med_" : String.valueOf(s) + "dark_";
        s = String.valueOf(Global.getOverlayPath()) + s + g.getZoom() * 16 + ".png";
        return Toolkit.getDefaultToolkit().getImage(s);
    }

    public int getContinent() {
        return this.continent;
    }

    public void setContinent(int c) {
        this.continent = c;
    }

    public String getHexName() {
        String s = this.hexName;
        if (s.length() == 0 && this.pResource != null) {
            s = this.pResource.getTypeName();
        }
        return s;
    }

    public void setHexName(String s) {
        this.hexName = s;
    }

    public void setOwningCountry(int owner) {
        this.owningCountry = owner;
        if (this.attachedPort != null) {
            this.attachedPort.setOwningCountry(owner);
        }
    }

    public int getMaxEntrenchment() {
        if (this instanceof WaterHex) {
            return 0;
        }
        if (this.pResource != null) {
            return this.pResource.maxEntrenchment();
        }
        return this.terrain.maxEntrenchment();
    }

    public int getOwningCountry() {
        return this.owningCountry;
    }

    public boolean isEmpty() {
        return this.unit == null;
    }

    public void setUnit(Unit unitP) {
        this.unit = unitP;
    }

    public void setPolygon(Polygon p) {
        this.polygon = p;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public boolean hasPResource() {
        return this.pResource != null;
    }

    public boolean sameElement(Hex other) {
        if (this instanceof LandHex && other instanceof LandHex) {
            return true;
        }
        return this instanceof WaterHex && other instanceof WaterHex;
    }

    public boolean hasSeaPort() {
        return this.pResource != null && this.pResource instanceof SeaPort;
    }

    public PResource getPResource() {
        return this.pResource;
    }

    public Terrain getTerrain() {
        if (this.pResource != null) {
            return clear;
        }
        return this.terrain;
    }

    public void setAttachedPort(Hex h) {
        this.attachedPort = h;
    }

    public Hex getAttachedPort() {
        return this.attachedPort;
    }

    public void razeFortress() {
        if (this.pResource instanceof Fortress && this.attachedPort == null && this.pResource.getMaxProduction() == 0) {
            this.pResource = null;
        }
    }

    public void hideTempUnit(Unit u) {
        if (this.unit != null) {
            this.tempUnit = this.unit;
        }
        this.unit = u;
    }

    public void activeTempUnit() {
        this.unit = null;
        if (this.tempUnit != null) {
            this.unit = this.tempUnit;
            this.tempUnit = null;
        }
    }

    public Unit getTmpUnit() {
        return this.tempUnit;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setHighlighted(boolean b) {
        this.higlighted = b;
    }

    public boolean getHighlighted() {
        return this.higlighted;
    }

    public void setTargetted(boolean b) {
        this.targetted = b;
    }

    public boolean getTargetted() {
        return this.targetted;
    }

    public int realMovementCost(Unit movingUnit) {
        int cost = this.basicMovementCost();
        if (movingUnit.isVehicle()) {
            cost += this.vehicleMovementPenalty();
        }
        return cost;
    }

    public int basicMovementCost() {
        int moveCost = 0;
        if (this.winterDuration > 0) {
            ++moveCost;
        }
        moveCost = this.pResource != null ? (moveCost += this.pResource.getBasicMovementCost()) : (moveCost += this.terrain.getBasicMovementCost());
        return moveCost;
    }

    public int vehicleMovementPenalty() {
        int movePenalty = 0;
        if (this.winterDuration > 0) {
            ++movePenalty;
        }
        movePenalty = this.pResource != null ? (movePenalty += this.pResource.getVehicleMovementPenalty()) : (movePenalty += this.terrain.getVehicleMovementPenalty());
        return movePenalty;
    }

    public boolean isCoreHex() {
        return this.coreOwningCountry != -1;
    }

    public void setCoreOwningCountry(int i) {
        this.coreOwningCountry = i;
    }

    public int getCoreOwningCountry() {
        return this.coreOwningCountry;
    }

    public int getSupply() {
        return this.supply;
    }

    public void setSupply(int sup) {
        this.supply = sup;
    }

    public void repairResource() {
        if (this.pResource != null) {
            this.pResource.repair();
        }
    }

    public void settmpMovesLeft(int i) {
        this.tmpMovesLeft = i;
    }

    public int gettmpMovesLeft() {
        return this.tmpMovesLeft;
    }

    public void setAlliesFOW(boolean b) {
        this.alliesFOW = b;
        if (b && this.unit != null) {
            this.unit.setFOWed(true);
        }
    }

    public void setAxisFOW(boolean b) {
        this.axisFOW = b;
        if (b && this.unit != null) {
            this.unit.setFOWed(true);
        }
    }

    public boolean getFOW(int side) {
        if (side == 100) {
            return this.axisFOW;
        }
        return this.alliesFOW;
    }

    public BufferedImage getBufferedUnitImage() {
        int curHash = 0;
        if (this.getUnit() != null) {
            curHash = this.getUnit().displayHashCode();
        }
        if (curHash != this.bufferedUnitHash) {
            this.bufferedUnitImage = null;
        }
        return this.bufferedUnitImage;
    }

    public void setBufferedUnitImage(BufferedImage image) {
        this.bufferedUnitImage = image;
        this.bufferedUnitHash = 0;
        if (this.getUnit() != null) {
            this.bufferedUnitHash = this.getUnit().displayHashCode();
        }
    }
}

