/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.Global;
import game.unit.Unit;
import java.io.Serializable;
import java.util.Vector;

public class TransportationLoop
implements Serializable {
    private static final long serialVersionUID = 85L;
    int controllingSide = 200;
    int entryHex;
    int exitHex;
    int loopIndex;
    Vector<Unit> entryQueue;
    Vector<Unit> exitQueue;

    public TransportationLoop(int index) {
        this.loopIndex = index;
        this.entryQueue = new Vector(10, 5);
        this.exitQueue = new Vector(10, 5);
    }

    public void enterLoop(Unit u, boolean entryHex) {
        if (u.getCountry().getSide() == this.controllingSide) {
            if (entryHex) {
                this.entryQueue.add(u);
            } else {
                this.exitQueue.add(u);
            }
            int turns = -1;
            turns = this.loopIndex == 0 ? Global.AFRICA_LOOP_TURNS : Global.SUEZ_LOOP_TURNS;
            u.setTurnsBeforeComplete(turns);
            Game g = u.getCountry().getGame();
            if (g.playerSide() == u.getCountry().getSide()) {
                g.requestShowInfoDialog(Global.createLanguageMessage(114, new String[]{u.getTypeName(), u.getCountry().getName(), "" + turns}));
            }
            u.removeFromMap();
        }
    }

    public void updateLoop(int side) {
        Unit u;
        int i = 0;
        while (i < this.entryQueue.size()) {
            u = this.entryQueue.get(i);
            if (u.getCountry().isConquered()) {
                this.entryQueue.remove(i);
                --i;
            } else if (u.getSide() == side) {
                u.updateTurnsBeforeComplete();
            }
            ++i;
        }
        i = 0;
        while (i < this.exitQueue.size()) {
            u = this.exitQueue.get(i);
            if (u.getCountry().isConquered()) {
                this.exitQueue.remove(i);
                --i;
            } else if (u.getSide() == side) {
                u.updateTurnsBeforeComplete();
            }
            ++i;
        }
        i = 0;
        while (i < this.entryQueue.size()) {
            int tmp;
            u = this.entryQueue.get(i);
            Game game = u.getCountry().getGame();
            if (u.getTurnsBeforeComplete() < 1 && (tmp = game.getEmptyAdjacentWaterHex(this.exitHex, true)) != -1) {
                u.getCountry().transportationLoopPlaceUnit(u, tmp);
                this.entryQueue.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < this.exitQueue.size()) {
            int tmp;
            u = this.exitQueue.get(i);
            if (u.getTurnsBeforeComplete() < 1 && (tmp = u.getCountry().getGame().getEmptyAdjacentWaterHex(this.entryHex, true)) != -1) {
                u.getCountry().transportationLoopPlaceUnit(u, tmp);
                this.exitQueue.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void setEntryHex(int hex) {
        this.entryHex = hex;
    }

    public void setExitHex(int hex) {
        this.exitHex = hex;
    }

    public int getEntryHex() {
        return this.entryHex;
    }

    public int getExitHex() {
        return this.exitHex;
    }

    public int getOpposingHex(int first) {
        if (first == this.entryHex) {
            return this.exitHex;
        }
        if (first == this.exitHex) {
            return this.entryHex;
        }
        return -1;
    }

    public int getControllingSide() {
        return this.controllingSide;
    }

    public void setControllingSide(int side) {
        this.controllingSide = side;
    }
}

