/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.io.Serializable;

public class TimeSystem
implements Serializable {
    private static final long serialVersionUID = 84L;
    private long axisTimeLeft;
    private long alliesTimeLeft;
    private final long timePerTurn;
    boolean noTimeLimit = false;

    public TimeSystem(boolean noTimeLimit, long axisTime, long alliesTime, long timePerT) {
        this.noTimeLimit = noTimeLimit;
        this.axisTimeLeft = axisTime;
        this.alliesTimeLeft = alliesTime;
        this.timePerTurn = timePerT;
    }

    public boolean getNoTimeLimit() {
        return this.noTimeLimit;
    }

    public void setNoTimeLimit(boolean noLimit) {
        this.noTimeLimit = noLimit;
    }

    public long getAxisTimeLeft() {
        return this.axisTimeLeft;
    }

    public long getAlliesTimeLeft() {
        return this.alliesTimeLeft;
    }

    public long getTimePerTurn() {
        return this.timePerTurn;
    }

    public void newSecond(boolean axisTurn) {
        if (!this.noTimeLimit) {
            if (axisTurn) {
                this.axisTimeLeft -= 1000L;
            } else {
                this.alliesTimeLeft -= 1000L;
            }
        }
    }

    public boolean timeIsUp(int side) {
        if (this.noTimeLimit) {
            return false;
        }
        if (side == 100 && this.axisTimeLeft < 0L) {
            return true;
        }
        return side != 200 && this.alliesTimeLeft < 0L;
    }

    public void addTime(boolean axis) {
        if (axis) {
            this.axisTimeLeft += this.timePerTurn;
        } else {
            this.alliesTimeLeft += this.timePerTurn;
        }
    }
}

