/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Global;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TechnologyAttributes
implements Serializable {
    private static final long serialVersionUID = 82L;
    int numColumns = 50;
    int numRows = 90;
    int[] attribute;
    String[] columnName;
    String[] rowName;
    private BufferedReader inFile;
    private StringTokenizer stringTokenizer;

    public TechnologyAttributes() {
        this.readFromScripts(true);
        this.readFromScripts(false);
    }

    public void readFromScripts(boolean textOrDataTrueMeansText) {
        try {
            Vector<Integer> tmpAttribute = new Vector<Integer>(10, 5);
            Vector<String> tmpRowName = new Vector<String>(10, 5);
            Vector<String> tmpColumnName = new Vector<String>(10, 5);
            String ss = String.valueOf(Global.getDataPath()) + "technology";
            if (textOrDataTrueMeansText) {
                ss = String.valueOf(ss) + "_" + Global.getLanguageString();
            }
            ss = String.valueOf(ss) + ".txt";
            FileInputStream fis = new FileInputStream(ss);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            this.inFile = new BufferedReader(isr);
            int i = 0;
            while (i < this.numRows + 2) {
                this.stringTokenizer = new StringTokenizer(this.inFile.readLine());
                while (this.stringTokenizer.hasMoreTokens()) {
                    String s = "";
                    s = this.stringTokenizer.nextToken();
                    if (i == 0) continue;
                    if (i == 1) {
                        tmpColumnName.add(s);
                        continue;
                    }
                    if (tmpRowName.size() / 4 < i - 1) {
                        tmpRowName.add(s);
                        continue;
                    }
                    tmpAttribute.add(new Integer(s));
                }
                ++i;
            }
            int j = 0;
            while (j < 4) {
                tmpColumnName.remove(0);
                ++j;
            }
            if (!textOrDataTrueMeansText) {
                this.attribute = new int[tmpAttribute.size()];
                i = 0;
                while (i < tmpAttribute.size()) {
                    this.attribute[i] = (Integer)tmpAttribute.get(i);
                    ++i;
                }
            }
            if (textOrDataTrueMeansText) {
                this.rowName = new String[tmpRowName.size()];
                i = 0;
                while (i < tmpRowName.size()) {
                    this.rowName[i] = (String)tmpRowName.get(i);
                    ++i;
                }
            }
            if (textOrDataTrueMeansText) {
                this.columnName = new String[tmpColumnName.size()];
                i = 0;
                while (i < tmpColumnName.size()) {
                    this.columnName[i] = (String)tmpColumnName.get(i);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.exit(5678);
        }
    }

    public int numColumns() {
        return this.numColumns;
    }

    public int numRows() {
        return this.numRows;
    }

    public int getValue(int column, int row) {
        return this.attribute[column + row * this.numColumns];
    }

    public String getColumnName(int index) {
        return this.columnName[index];
    }

    public String getRowName(int column, int row) {
        return this.rowName[column + row * 4];
    }

    public String getTranslationName(int row) {
        if (Global.SETTINGS_DATA.getVal("DEBUG_MESSAGES") == 1) {
            return "x-x-x";
        }
        return this.getRowName(1, row);
    }
}

