/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Country;
import game.Game;
import game.Global;
import game.TechAdvance;
import game.TechnologyAttributes;
import game.p_resource.PResource;
import game.unit.Unit;
import java.io.Serializable;

public class Technology
implements Serializable {
    private static final long serialVersionUID = 81L;
    Country country;
    private final String name;
    private final String translationName;
    int cost;
    double progress;
    int maxLevel;

    public Technology(Country c, String nam, String translationNam, int cos, int startLevel) {
        this.country = c;
        this.name = nam;
        this.translationName = translationNam.replaceAll("_", " ");
        this.cost = cos;
        this.determineMaxLevel();
        this.setLevel(startLevel);
    }

    public String getTranslationName() {
        return this.translationName;
    }

    public int getCost() {
        return this.cost;
    }

    public void setLevel(int level) {
        int realLevel = Math.min(level, this.maxLevel);
        this.progress = this.cost * realLevel;
    }

    public Country getCountry() {
        return this.country;
    }

    public int getLevel() {
        return (int)this.progress / this.cost;
    }

    public int getLevelProgress() {
        return (int)this.progress;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    private void determineMaxLevel() {
        int numLev = 0;
        TechnologyAttributes ta = Global.TECHNOLOGY_ATTRIBUTES;
        int i = 0;
        while (i < ta.numRows) {
            String rowName = ta.getRowName(0, i);
            if (rowName.startsWith(this.name) && ta.getValue(1, i) == 1) {
                ++numLev;
            }
            ++i;
        }
        this.maxLevel = numLev;
    }

    public void progress(Game g, int roll, double effort) {
        double preProgress = this.progress;
        int preLevel = this.getLevel();
        if (preLevel < this.getMaxLevel()) {
            this.progress += this.progressIncrease(roll, effort);
            if (this.getLevel() > preLevel) {
                this.progress = (preLevel + 1) * this.cost;
                if (g.whosTurn() != g.playerSide() || g.getGameMode() == 2000 || g.getGameMode() == 4000) {
                    g.getWarWindow().getTechAdvancesVector().add(new TechAdvance(this.country, this.getLevel(), this.country.getResearch().getResearchArea(this), this));
                }
            } else if (this.progress - preProgress > (double)(this.getCost() / 5) && (g.whosTurn() != g.playerSide() || g.getGameMode() == 2000 || g.getGameMode() == 4000)) {
                g.getWarWindow().getTechAdvancesVector().add(new TechAdvance(this.country, -1, this.country.getResearch().getResearchArea(this), this));
            }
        }
    }

    private double progressIncrease(int roll, double effort) {
        double val = 0.0;
        val = !this.country.getGame().getGameState().getRandomResearch() ? 2.0 * effort : (roll <= 26 ? effort : (roll <= 29 ? 8.0 * effort : 15.0 * effort));
        return val;
    }

    public int getMaxUpgrades(Unit u) {
        TechnologyAttributes ta = Global.TECHNOLOGY_ATTRIBUTES;
        int upgrades = 0;
        int unitIndex = -1;
        int i = 0;
        while (i < ta.numColumns()) {
            if (ta.getColumnName(i).compareTo(u.getClassName()) == 0) {
                unitIndex = i;
                break;
            }
            ++i;
        }
        if (unitIndex != -1) {
            i = 0;
            while (i < ta.numRows()) {
                if (ta.getValue(1, i) == 1 && ta.getValue(unitIndex, i) == 1 && ta.getRowName(0, i).startsWith(this.name)) {
                    ++upgrades;
                }
                ++i;
            }
        }
        return upgrades;
    }

    public int getUpgradesHeld(Unit u, int level) {
        TechnologyAttributes ta = Global.TECHNOLOGY_ATTRIBUTES;
        int numUpgrades = 0;
        int unitIndex = -1;
        int i = 0;
        while (i < ta.numColumns()) {
            if (ta.getColumnName(i).compareTo(u.getClassName()) == 0) {
                unitIndex = i;
                break;
            }
            ++i;
        }
        if (unitIndex != -1) {
            i = 0;
            while (i < ta.numRows()) {
                if (ta.getValue(0, i) <= level && ta.getValue(1, i) == 1 && ta.getValue(unitIndex, i) == 1 && ta.getRowName(0, i).startsWith(this.name)) {
                    ++numUpgrades;
                }
                ++i;
            }
        }
        return numUpgrades;
    }

    public int getNumLevels() {
        TechnologyAttributes ta = Global.TECHNOLOGY_ATTRIBUTES;
        int levels = 0;
        int i = 0;
        while (i < ta.numRows()) {
            if (ta.getValue(1, i) == 1 && ta.getRowName(0, i).startsWith(this.name)) {
                ++levels;
            }
            ++i;
        }
        return levels;
    }

    public int getUnitTechBonus(Unit u, int column, int level) {
        TechnologyAttributes ta = Global.TECHNOLOGY_ATTRIBUTES;
        int bonus = 0;
        int unitIndex = -1;
        int i = 0;
        while (i < ta.numColumns()) {
            if (ta.getColumnName(i).compareTo(u.getClassName()) == 0) {
                unitIndex = i;
                break;
            }
            ++i;
        }
        if (unitIndex != -1) {
            i = 0;
            while (i < ta.numRows()) {
                if (ta.getValue(0, i) <= level && ta.getValue(1, i) == 1 && ta.getValue(unitIndex, i) == 1 && ta.getRowName(0, i).startsWith(this.name)) {
                    bonus += ta.getValue(column, i);
                }
                ++i;
            }
        }
        return bonus;
    }

    public int getLevelBonus(int column, int level) {
        TechnologyAttributes ta = Global.TECHNOLOGY_ATTRIBUTES;
        boolean bonus = false;
        int i = 0;
        while (i < ta.numRows()) {
            if (ta.getValue(0, i) == level && ta.getValue(1, i) == 1 && ta.getRowName(0, i).startsWith(this.name)) {
                return ta.getValue(column, i);
            }
            ++i;
        }
        return 0;
    }

    public boolean hasLevelBonus(String className, int level) {
        boolean ret = false;
        TechnologyAttributes ta = Global.TECHNOLOGY_ATTRIBUTES;
        int unitIndex = -1;
        int i = 0;
        while (i < ta.numColumns()) {
            if (ta.getColumnName(i).compareTo(className) == 0) {
                unitIndex = i;
                break;
            }
            ++i;
        }
        if (unitIndex != -1) {
            i = 0;
            while (i < ta.numRows()) {
                if (ta.getValue(0, i) == level && ta.getValue(1, i) == 1 && ta.getValue(unitIndex, i) == 1 && ta.getRowName(0, i).startsWith(this.name)) {
                    ret = true;
                }
                ++i;
            }
        }
        return ret;
    }

    public int getPResourceTechBonus(PResource pr, int column) {
        TechnologyAttributes ta = Global.TECHNOLOGY_ATTRIBUTES;
        int bonus = 0;
        int unitIndex = -1;
        int i = 0;
        while (i < ta.numColumns()) {
            if (ta.getColumnName(i).compareTo(pr.getClassName()) == 0) {
                unitIndex = i;
                break;
            }
            ++i;
        }
        if (unitIndex != -1) {
            i = 0;
            while (i < ta.numRows()) {
                if (ta.getValue(0, i) <= this.getLevel() && ta.getValue(1, i) == 1 && ta.getValue(unitIndex, i) == 1 && ta.getRowName(0, i).startsWith(this.name)) {
                    bonus += ta.getValue(column, i);
                }
                ++i;
            }
        }
        return bonus;
    }

    public int getIndustryTechBonus() {
        TechnologyAttributes ta = Global.TECHNOLOGY_ATTRIBUTES;
        int bonus = 0;
        int i = 0;
        while (i < ta.numRows()) {
            if (ta.getValue(0, i) <= this.getLevel() && ta.getValue(1, i) == 1 && ta.getRowName(0, i).startsWith(this.name)) {
                bonus += ta.getValue(17, i);
            }
            ++i;
        }
        return bonus;
    }
}

