/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Country;
import game.Game;
import game.hex.Hex;
import game.hex.LandHex;
import game.p_resource.Capital;
import game.unit.Transport;
import game.unit.Unit;
import java.io.Serializable;

public class Strategy
implements Serializable {
    private static final long serialVersionUID = 78L;
    private int primaryTarget = -1;
    private int secondaryTarget = -1;
    private int tertiaryTarget = -1;
    private int unitsPerLab = 20;
    private int landShare = 0;
    private int airShare = 0;
    private int motorisedShare = 0;
    private int armourShare = 0;
    private int bomberShare = 0;
    private int subShare = 0;

    public int getPrimaryTarget() {
        return this.primaryTarget;
    }

    public int getSecondaryTarget() {
        return this.secondaryTarget;
    }

    public int getTertiaryTarget() {
        return this.tertiaryTarget;
    }

    public int getLandShare() {
        return this.landShare;
    }

    public int getAirShare() {
        return this.airShare;
    }

    public void setLandShare(int val) {
        this.landShare = val;
    }

    public void setAirShare(int val) {
        this.airShare = val;
    }

    public void setUnitsPerLab(int val) {
        this.unitsPerLab = val;
    }

    public void resetTargets() {
        this.primaryTarget = -1;
        this.secondaryTarget = -1;
        this.tertiaryTarget = -1;
    }

    public void setPrimaryTarget(Country c) {
        this.primaryTarget = this.targetCountry(c);
    }

    public void setSecondaryTarget(Country c) {
        this.secondaryTarget = this.targetCountry(c);
    }

    public void setTertiaryTarget(Country c) {
        this.tertiaryTarget = this.targetCountry(c);
    }

    private int targetCountry(Country c) {
        if (c.activeCapital() != -1) {
            return c.activeCapital();
        }
        if (c.getPrimaryCapital() != -1) {
            return c.getPrimaryCapital();
        }
        return -1;
    }

    public int getUnitsPerLab() {
        return this.unitsPerLab;
    }

    public int getMotorisedShare() {
        return this.motorisedShare;
    }

    public int getArmourShare() {
        return this.armourShare;
    }

    public int getBomberShare() {
        return this.bomberShare;
    }

    public int getSubShare() {
        return this.subShare;
    }

    public void setMotorisedShare(int val) {
        this.motorisedShare = val;
    }

    public void setArmourShare(int val) {
        this.armourShare = val;
    }

    public void setBomberShare(int val) {
        this.bomberShare = val;
    }

    public void setSubShare(int val) {
        this.subShare = val;
    }

    private boolean resetObseleteDestination(Unit u) {
        Game g = u.getCountry().getGame();
        Hex h = u.getDestinationHex();
        int hexIndex = g.getHexIndex(h);
        if (u.getDestinationHex() != null) {
            int dest = u.getCountry().getGame().getHexIndex(u.getDestinationHex());
            if (this.primaryTarget == dest) {
                return false;
            }
            if (this.secondaryTarget == dest) {
                return false;
            }
            if (this.tertiaryTarget == dest) {
                return false;
            }
            if (u.capitalDefenceDuty()) {
                return false;
            }
            if (u instanceof Transport) {
                return false;
            }
            if (u.getOnHex() == null) {
                return false;
            }
            if (!(h.getOwningCountry() != u.getCountryIndex() || !(h instanceof LandHex) || h.getPResource() instanceof Capital && g.militaryAdvantageRatioOverHex(u.getSide(), hexIndex) > 1.0)) {
                return false;
            }
        }
        u.setDestinationHex(null);
        u.setWayPoint(null);
        return true;
    }

    public void updateLandDestinations(Unit u) {
        Game g = u.getCountry().getGame();
        if (u.garrisonDuty()) {
            u.setDestinationHex(null);
        }
        if (this.resetObseleteDestination(u)) {
            double advantageRatio;
            Hex h = u.getOnHex();
            if (!u.onDefenceMission() && h != null && !g.inAfrica(g.getHexIndex(h)) && (advantageRatio = g.militaryAdvantageRatioOverHex(u.getSide(), g.getHexIndex(u.getOnHex()))) > 1.2) {
                if (Math.random() < 0.4 + 0.02 * u.getLandInfluence() && this.primaryTarget != -1) {
                    u.setDestinationHex(g.getHex(this.primaryTarget));
                } else if (Math.random() < 0.05 + 0.01 * u.getLandInfluence() && this.secondaryTarget != -1) {
                    u.setDestinationHex(g.getHex(this.secondaryTarget));
                } else if (Math.random() < 0.05 && this.tertiaryTarget != -1) {
                    u.setDestinationHex(g.getHex(this.tertiaryTarget));
                }
            }
        }
    }
}

