/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.XThread;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SoundPlayer
extends XThread {
    long lastSoundStartTime = 0L;
    Vector<File> vector = new Vector(2, 1);
    boolean running = false;
    int maxSounds = 1;
    static int closeCounter = 0;

    public SoundPlayer() {
        this.setPriority(1);
    }

    public void setMaxSounds(int max) {
        this.maxSounds = max;
    }

    public long getLastSoundStartTime() {
        return this.lastSoundStartTime;
    }

    public void setRunning(boolean b) {
        this.running = b;
    }

    public boolean getRunning() {
        return this.running;
    }

    public void addSound(File url) {
        if (this.vector.size() < this.maxSounds) {
            this.vector.add(url);
        }
        this.interrupt();
    }

    public boolean hasSound() {
        return this.vector.size() > 0;
    }

    public static void playAudioFile(String fileName) {
        File soundFile = new File(fileName);
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(soundFile);
            SoundPlayer.playAudioStream(audioInputStream);
            audioInputStream = null;
        }
        catch (Exception e) {
            System.out.println("Problem with file " + fileName + ":");
            e.printStackTrace();
        }
    }

    public static void playAudioStream(AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        System.out.println("AudioPlayer.playAudioStream audio format: " + audioFormat);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        if (!AudioSystem.isLineSupported(info)) {
            System.out.println("AudioPlayer.playAudioStream does not  handle this type of audio.");
            return;
        }
        try {
            SourceDataLine dataLine = (SourceDataLine)AudioSystem.getLine(info);
            dataLine.open(audioFormat);
            dataLine.start();
            int bufferSize = (int)audioFormat.getSampleRate() * audioFormat.getFrameSize();
            byte[] buffer = new byte[bufferSize];
            try {
                int bytesRead = 0;
                while (bytesRead >= 0) {
                    bytesRead = audioInputStream.read(buffer, 0, buffer.length);
                    if (bytesRead < 0) continue;
                    dataLine.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        this.running = true;
        while (true) {
            if (!this.running) {
                continue;
            }
            do {
                if (this.vector.size() > 0) {
                    File tmp = this.vector.get(0);
                    this.lastSoundStartTime = System.currentTimeMillis();
                    SoundPlayer.playAudioFile(tmp.toString());
                    if (this.vector.size() <= 0) continue;
                    this.vector.remove(0);
                    continue;
                }
                SoundPlayer.delay(2099999999L);
            } while (this.running);
        }
    }
}

