/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import game.Global;
import game.Research;
import game.Technology;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.Serializable;

public class ResearchArea
implements Serializable {
    private static final long serialVersionUID = 75L;
    int labs = 0;
    Technology[] tech;
    Research research;
    int focus = -1;
    String name;
    String imageName;

    public ResearchArea(Research r, Technology[] t, String nam, String imageNam) {
        this.research = r;
        this.tech = t;
        this.name = nam;
        this.imageName = imageNam;
    }

    public String getName() {
        return this.name;
    }

    public Research getResearch() {
        return this.research;
    }

    public void changeLabs(int change) {
        this.labs += change;
    }

    public void setFocus(int i) {
        this.focus = i;
    }

    public Image getImage(int width, String state) {
        String s = "";
        if (state.length() > 0) {
            s = "_" + state;
        }
        return Toolkit.getDefaultToolkit().getImage(String.valueOf(Global.getImagePath()) + this.imageName + s + "_" + width + ".png");
    }

    public int getFocus() {
        return this.focus;
    }

    public int getLabs() {
        return this.labs;
    }

    public double getEffort(int tech) {
        double effort = 0.0;
        if (this.focus == -1) {
            effort = 1.0 / (double)this.tech.length;
        } else {
            double piece = 1.0 / (double)(this.tech.length + 1);
            effort = tech == this.focus ? 2.0 * piece : piece;
        }
        return effort *= (double)this.labs;
    }

    public void progress(Game g, int rolll, int roll2, int roll3) {
        this.tech[0].progress(g, rolll, this.getEffort(0));
        this.tech[1].progress(g, roll2, this.getEffort(1));
        this.tech[2].progress(g, roll3, this.getEffort(2));
    }

    public Technology getTech(int i) {
        return this.tech[i];
    }
}

